<?php
/**
 * Title: Users video slider
 * Slug: modiram/section-user-video-slider
 *  Viewport width: 1400
 * Description: A hero section with a title, a paragraph, a CTA button, and an image.
 */

global $meta;

if (!$meta || !isset($meta['results'][0]) || empty($meta['results'][0])) {
    $meta['results'][0] = [
        [
            'poster' => 'https://picsum.photos/500',
            'video' => 'https://test-videos.co.uk/vids/bigbuckbunny/mp4/h264/360/Big_Buck_Bunny_360_10s_5MB.mp4',
            'full_name' => 'زهرا عباسی',
            'title' => 'هنرجو',
        ],
        [
            'poster' => 'https://picsum.photos/500',
            'video' => 'https://test-videos.co.uk/vids/bigbuckbunny/mp4/h264/360/Big_Buck_Bunny_360_10s_5MB.mp4',
            'full_name' => 'زهرا عباسی',
            'title' => 'هنرجو',
        ],
        [
            'poster' => 'https://picsum.photos/500',
            'video' => 'https://test-videos.co.uk/vids/bigbuckbunny/mp4/h264/360/Big_Buck_Bunny_360_10s_5MB.mp4',
            'full_name' => 'زهرا عباسی',
            'title' => 'هنرجو',
        ],
        [
            'poster' => 'https://picsum.photos/500',
            'video' => 'https://test-videos.co.uk/vids/bigbuckbunny/mp4/h264/360/Big_Buck_Bunny_360_10s_5MB.mp4',
            'full_name' => 'زهرا عباسی',
            'title' => 'هنرجو',
        ],
    ];
}

?>

<!-- videos-slider -->
<div class="videos-slider my-lg-0 my-4">
    <div class="swiper">
        <div class="swiper-wrapper">
            <?php foreach (maybe_unserialize($meta['results'][0]) as $result) { ?>
                <div class="swiper-slide">
                    <div class="holder-video pause-hide-controls mb-3">
                        <video poster="<?php echo $result['poster'] ?>">
                            <source src="<?php echo $result['video'] ?>">
                            "
                            type="video/mp4">
                            Your browser does not support the video tag.
                        </video>

                        <div class="holder-play-video d-flex flex-column justify-content-end align-items-center text-white text-center pb-4 px-2">
                            <button class="btn-play-video mb-3">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45"
                                     viewBox="0 0 24 24">
                                    <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                </svg>
                            </button>
                            <div class="user-name line-clamp-1 mb-1">
                                <?php echo $result['full_name'] ?? '' ?>
                            </div>
                            <div class="user-idea">
                                <?php echo $result['title'] ?? '' ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <!--arrows-->
    <button class="slide-button slide-prev mx-sm-0 mx-1">
        <svg width="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <polygon fill="var(--ci-primary-color, currentColor)"
                     points="359.873 121.377 337.246 144.004 433.243 240.001 16 240.001 16 240.002 16 272.001 16 272.002 433.24 272.002 337.246 367.996 359.873 390.623 494.498 256 359.873 121.377"
                     class="ci-primary"/>
        </svg>
    </button>

    <button class="slide-button slide-next mx-sm-0 mx-1">
        <svg width="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
            <polygon fill="var(--ci-primary-color, currentColor)"
                     points="497.333 239.999 80.092 239.999 176.087 144.004 153.46 121.377 18.837 256 153.46 390.623 176.087 367.996 80.09 271.999 497.333 271.999 497.333 239.999"
                     class="ci-primary"/>
        </svg>
    </button>
</div>

