<?php
/**
 * Title: Single post
 * Slug: modiram/section-single
 * Categories: post
 * Post Types: post
 */

global $post;

if (!$post ) {
    return;
}

$thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
$writer = get_user_by('ID', $post->post_author);
$content = $post->post_content;
?>

<section class="header-single-article overflow-hidden pt-sm-5 mb-5">
    <div class="container px-sm-3 px-0">
        <div class="row">
            <div class="col-lg-6 px-sm-3 p-0">
                <div class="article-image mb-md-0">
                    <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="h-100 d-flex flex-column justify-content-between pt-md-5 pt-4 px-sm-0 px-3">
                    <div class="breadcrumb-links text-sm mb-4">
                        <?php mdr_print_breadcrumb() ?>
                    </div>
                    <div class="mb-4">
                        <h1 class="article-title text-xl mb-3">
                            <?php echo $post->post_title ?>
                        </h1>
                        <div class="d-flex flex-wrap align-items-center text-gray-text text-sm">
                            <div class="d-flex align-items-center ml-4 mb-2">
                                <div class="me-2">
                                    <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_3047)">
                                            <path d="M12 0.5C9.62663 0.5 7.30655 1.20379 5.33316 2.52236C3.35977 3.84094 1.8217 5.71509 0.913451 7.9078C0.00519943 10.1005 -0.232441 12.5133 0.230582 14.8411C0.693605 17.1689 1.83649 19.3071 3.51472 20.9853C5.19295 22.6635 7.33115 23.8064 9.65892 24.2694C11.9867 24.7324 14.3995 24.4948 16.5922 23.5866C18.7849 22.6783 20.6591 21.1402 21.9776 19.1668C23.2962 17.1935 24 14.8734 24 12.5C23.9966 9.31846 22.7312 6.26821 20.4815 4.01852C18.2318 1.76883 15.1815 0.503441 12 0.5V0.5ZM12 22.5C10.0222 22.5 8.08879 21.9135 6.4443 20.8147C4.79981 19.7159 3.51809 18.1541 2.76121 16.3268C2.00433 14.4996 1.8063 12.4889 2.19215 10.5491C2.578 8.60929 3.53041 6.82746 4.92894 5.42893C6.32746 4.03041 8.10929 3.078 10.0491 2.69215C11.9889 2.3063 13.9996 2.50433 15.8268 3.2612C17.6541 4.01808 19.2159 5.29981 20.3147 6.9443C21.4135 8.58879 22 10.5222 22 12.5C21.9971 15.1513 20.9426 17.6931 19.0679 19.5679C17.1931 21.4426 14.6513 22.4971 12 22.5Z"
                                                  fill="#FFA6B2"/>
                                            <path d="M12.0004 6.5C11.7352 6.5 11.4809 6.60536 11.2933 6.79289C11.1058 6.98043 11.0004 7.23478 11.0004 7.5V11.825L7.62943 13.937C7.404 14.0778 7.24374 14.3024 7.18392 14.5614C7.1241 14.8204 7.1696 15.0926 7.31043 15.318C7.45126 15.5434 7.67588 15.7037 7.93487 15.7635C8.19386 15.8233 8.466 15.7778 8.69143 15.637L12.5314 13.237C12.6765 13.1461 12.7958 13.0195 12.878 12.8692C12.9601 12.719 13.0022 12.5502 13.0004 12.379V7.5C13.0004 7.23478 12.8951 6.98043 12.7075 6.79289C12.52 6.60536 12.2657 6.5 12.0004 6.5Z"
                                                  fill="#FFA6B2"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2885_3047">
                                                <rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <span>3 دقیقه</span>
                            </div>
                            <div class="d-flex align-items-center ms-4 mb-2">
                                <div class="me-2">
                                    <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_3044)">
                                            <path d="M19 2.5H18V1.5C18 1.23478 17.8946 0.98043 17.7071 0.792893C17.5196 0.605357 17.2652 0.5 17 0.5C16.7348 0.5 16.4804 0.605357 16.2929 0.792893C16.1054 0.98043 16 1.23478 16 1.5V2.5H8V1.5C8 1.23478 7.89464 0.98043 7.70711 0.792893C7.51957 0.605357 7.26522 0.5 7 0.5C6.73478 0.5 6.48043 0.605357 6.29289 0.792893C6.10536 0.98043 6 1.23478 6 1.5V2.5H5C3.67441 2.50159 2.40356 3.02888 1.46622 3.96622C0.528882 4.90356 0.00158786 6.17441 0 7.5L0 19.5C0.00158786 20.8256 0.528882 22.0964 1.46622 23.0338C2.40356 23.9711 3.67441 24.4984 5 24.5H19C20.3256 24.4984 21.5964 23.9711 22.5338 23.0338C23.4711 22.0964 23.9984 20.8256 24 19.5V7.5C23.9984 6.17441 23.4711 4.90356 22.5338 3.96622C21.5964 3.02888 20.3256 2.50159 19 2.5ZM2 7.5C2 6.70435 2.31607 5.94129 2.87868 5.37868C3.44129 4.81607 4.20435 4.5 5 4.5H19C19.7956 4.5 20.5587 4.81607 21.1213 5.37868C21.6839 5.94129 22 6.70435 22 7.5V8.5H2V7.5ZM19 22.5H5C4.20435 22.5 3.44129 22.1839 2.87868 21.6213C2.31607 21.0587 2 20.2956 2 19.5V10.5H22V19.5C22 20.2956 21.6839 21.0587 21.1213 21.6213C20.5587 22.1839 19.7956 22.5 19 22.5Z"
                                                  fill="#FFA6B2"/>
                                            <path d="M12 17C12.8284 17 13.5 16.3284 13.5 15.5C13.5 14.6716 12.8284 14 12 14C11.1716 14 10.5 14.6716 10.5 15.5C10.5 16.3284 11.1716 17 12 17Z"
                                                  fill="#FFA6B2"/>
                                            <path d="M7 17C7.82843 17 8.5 16.3284 8.5 15.5C8.5 14.6716 7.82843 14 7 14C6.17157 14 5.5 14.6716 5.5 15.5C5.5 16.3284 6.17157 17 7 17Z"
                                                  fill="#FFA6B2"/>
                                            <path d="M17 17C17.8284 17 18.5 16.3284 18.5 15.5C18.5 14.6716 17.8284 14 17 14C16.1716 14 15.5 14.6716 15.5 15.5C15.5 16.3284 16.1716 17 17 17Z"
                                                  fill="#FFA6B2"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2885_3044">
                                                <rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <span>
                                        <?php echo verta($post->post_date)->format('Y/n/j') ?>
                                    </span>
                            </div>
                            <div class="d-flex align-items-center ms-4 mb-2">
                                <div class="me-2">
                                    <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_3041)">
                                            <path d="M18.656 1.43032L6.46402 13.6223C5.99836 14.0855 5.6292 14.6364 5.3779 15.2432C5.1266 15.8499 4.99817 16.5006 5.00002 17.1573V18.5003C5.00002 18.7655 5.10538 19.0199 5.29291 19.2074C5.48045 19.395 5.7348 19.5003 6.00002 19.5003H7.34302C7.99978 19.5022 8.65039 19.3737 9.25718 19.1224C9.86396 18.8711 10.4149 18.502 10.878 18.0363L23.07 5.84432C23.6544 5.25849 23.9826 4.46479 23.9826 3.63732C23.9826 2.80984 23.6544 2.01615 23.07 1.43032C22.4757 0.86221 21.6852 0.545166 20.863 0.545166C20.0408 0.545166 19.2503 0.86221 18.656 1.43032ZM21.656 4.43032L9.46402 16.6223C8.90015 17.1827 8.13803 17.4982 7.34302 17.5003H7.00002V17.1573C7.0021 16.3623 7.31759 15.6002 7.87802 15.0363L20.07 2.84432C20.2836 2.64027 20.5676 2.52641 20.863 2.52641C21.1584 2.52641 21.4424 2.64027 21.656 2.84432C21.866 3.05483 21.9839 3.34001 21.9839 3.63732C21.9839 3.93463 21.866 4.2198 21.656 4.43032Z"
                                                  fill="#FFA6B2"/>
                                            <path d="M23 9.479C22.7348 9.479 22.4804 9.58436 22.2929 9.77189C22.1054 9.95943 22 10.2138 22 10.479V15.5H18C17.2044 15.5 16.4413 15.8161 15.8787 16.3787C15.3161 16.9413 15 17.7044 15 18.5V22.5H5C4.20435 22.5 3.44129 22.1839 2.87868 21.6213C2.31607 21.0587 2 20.2957 2 19.5V5.5C2 4.70435 2.31607 3.94129 2.87868 3.37868C3.44129 2.81607 4.20435 2.5 5 2.5H14.042C14.3072 2.5 14.5616 2.39464 14.7491 2.20711C14.9366 2.01957 15.042 1.76522 15.042 1.5C15.042 1.23478 14.9366 0.98043 14.7491 0.792893C14.5616 0.605357 14.3072 0.5 14.042 0.5H5C3.67441 0.501588 2.40356 1.02888 1.46622 1.96622C0.528882 2.90356 0.00158786 4.17441 0 5.5L0 19.5C0.00158786 20.8256 0.528882 22.0964 1.46622 23.0338C2.40356 23.9711 3.67441 24.4984 5 24.5H16.343C16.9999 24.5019 17.6507 24.3735 18.2576 24.1222C18.8646 23.8709 19.4157 23.5017 19.879 23.036L22.535 20.378C23.0008 19.9149 23.37 19.364 23.6215 18.7572C23.873 18.1504 24.0016 17.4998 24 16.843V10.479C24 10.2138 23.8946 9.95943 23.7071 9.77189C23.5196 9.58436 23.2652 9.479 23 9.479ZM18.465 21.622C18.063 22.023 17.5547 22.3006 17 22.422V18.5C17 18.2348 17.1054 17.9804 17.2929 17.7929C17.4804 17.6054 17.7348 17.5 18 17.5H21.925C21.8013 18.0535 21.524 18.5609 21.125 18.964L18.465 21.622Z"
                                                  fill="#FFA6B2"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2885_3041">
                                                <rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <span><?php echo $writer->display_name ?></span>
                            </div>
                        </div>
                    </div>
                    <?php if (!empty($post->post_excerpt)) { ?>
                        <div class="box-info d-flex p-3">
                            <div class="me-3">
                                <svg width="25" height="23" viewBox="0 0 25 23" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M15.9834 2H9.244C8.60105 1.99898 7.96916 2.16737 7.41195 2.48816C6.85473 2.80895 6.39186 3.27083 6.06989 3.82737L2.71695 9.66711C2.39569 10.2235 2.22656 10.8547 2.22656 11.4972C2.22656 12.1397 2.39569 12.7709 2.71695 13.3274L6.06989 19.1671C6.39158 19.7243 6.85425 20.187 7.41142 20.5087C7.96858 20.8305 8.60061 20.9999 9.244 21H15.9834C16.6268 20.9999 17.2588 20.8305 17.816 20.5087C18.3732 20.187 18.8358 19.7243 19.1575 19.1671L22.5105 13.3274C22.8317 12.7709 23.0008 12.1397 23.0008 11.4972C23.0008 10.8547 22.8317 10.2235 22.5105 9.66711L19.1575 3.82737C18.8356 3.27083 18.3727 2.80895 17.8155 2.48816C17.2582 2.16737 16.6264 1.99898 15.9834 2V2Z"
                                          stroke="#3A4651" stroke-width="2.5" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path d="M12.6133 10.8418V16.0668" stroke="#3A4651" stroke-width="2.5"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <circle cx="12.6273" cy="7.53941" r="0.838235" fill="#3A4651" stroke="#3A4651"/>
                                </svg>
                            </div>
                            <div>
                                <?php echo $post->post_excerpt; ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="mb-5">
    <div class="container">
        <div class="row align-items-start position-relative">

            <div class="col-md-3 article-sidebar d-md-block d-none">
                <div class="mb-4">
                    <?php mdr_print_h2_lists_from_content($content); ?>
                </div>
                <!--adv-->
                <a href="#" class="d-block">
                    <img class="w-100"
                         src="/wp-content/themes/modiram/assets/images/image-placeholder2.png">
                </a>
            </div>

            <div class="col-md-9 text-justify article-main">
                <?php mdr_print_content_by_h2_section_id($content); ?>

                <!-- wp:pattern {"slug":"modiram/section-post-tags"} /-->
            </div>
        </div>
    </div>
</section>

<!-- wp:pattern {"slug":"modiram/section-post-comments"} /-->

