<?php
/**
 * Title: video
 * Slug: modiram/section-single-video
 * Categories: content
 * Post Types: post, page
 */

global $post, $category, $pagination;

if (!$post) {
    return;
}

$thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
$category = get_the_terms($post, 'video_category')[0] ?? [];

$categories = get_categories([
    'taxonomy' => 'video_category',
    'parent' => 0,
    'number' => 4,
]);

$posts = new WP_Query([
    'post_type' => 'video',
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'posts_per_page' => get_option('posts_per_page'),
    'offset' => 0,
    'tax_query' => array(
        array(
            'taxonomy' => 'video_category',
            'field' => 'slug',
            'terms' => $category->slug ?? '',
        ),
    ),
]);

$pagination = [
    'post_type' => 'video',
    'taxonomy' => 'video_category',
    'term_slug' => $category->slug ?? '',
    'max_num_pages' => $posts->max_num_pages ?? 1
];

?>

<header class="header-page mb-5">
    <div class="container position-relative overflow-hidden py-5">

        <!--background image-->
        <div class="bg-image pl-md-5">
            <div class="image">
                <img src="/wp-content/themes/modiram/assets/images/header-videos.png">

                <!-- bg-overlay -->
                <div class="bg-overlay"></div>
            </div>
        </div>

        <div class="pb-5">
            <div class="section-title d-inline-flex mb-3">
                <div class="title-icon bg-white rounded-start-2">
                    <svg width="22" height="15" viewBox="0 0 22 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="1" y="1" width="14" height="13" rx="3.5" fill="black" stroke="black" stroke-width="1.5"/>
                        <path d="M15 6.16062L19.1162 3.3063C19.912 2.75446 21 3.324 21 4.29241V10.7255C21 11.6903 19.919 12.2607 19.1226 11.716L15 8.89637V6.16062Z" fill="black" stroke="black" stroke-width="1.5"/>
                    </svg>
                </div>
                <h3 class="title-text rounded-end-2">
                    <?php echo $category->name ?? ''; ?>
                </h3>
            </div>
            <div class="text-white">
                در این صفحه، آخرین ویدیوها را مشاهده خواهید نمود
            </div>
        </div>

    </div>
</header>
<div class="container">
    <div class="row">
        <div class="breadcrumb-links breadcrumb-archive text-sm mb-4 col d-flex text-gray-100 column-gap-2">
            <?php mdr_print_breadcrumb() ?>
        </div>
    </div>
</div>

<?php if (!empty($post)) {
    $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
    $videos_link = get_post_meta($post->ID, 'videos', true);
    if (empty($videos_link)) $videos_link = [];
    ?>
    <section class="section-to-top mb-5">
        <div class="container px-sm-3 px-0">
            <div class="video-preview p-sm-4 rounded-4">
                <div class="row">
                    <div class="col-lg-6 col-12 px-sm-3 p-0">
                        <div class="holder-video large-video mb-3">
                            <video poster="<?php echo $videos_link[array_key_first($videos_link) ?? 1]['poster'] ?? get_theme_file_uri('assets/images/card.png') ?>">
                                <source src="<?php echo $videos_link[array_key_first($videos_link) ?? 1]['video'] ?? '' ?>"
                                        type="video/mp4">
                                Your browser does not support the video tag.
                            </video>

                            <div class="holder-play-video d-flex justify-content-center align-items-center">
                                <button class="btn-play-video">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45"
                                         viewBox="0 0 24 24">
                                        <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-12 px-sm-3 p-0">
                        <div class="h-100 d-flex flex-column text-sm-right text-center px-sm-0 px-3">
                            <div class="h-100 d-flex flex-column justify-content-center mb-3">
                                <div class="text-xl font-extrabold d-flex mb-sm-4 mb-3">
                                    <div class="d-sm-inline d-none ml-2">
                                        <svg width="16" height="29" viewBox="0 0 16 29" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M0.650924 28.9998L1.35803 0.00842386L15.5002 14.1506L0.650924 28.9998Z"
                                                  fill="#FFAC00"/>
                                        </svg>
                                    </div>
                                    <span><?php echo $post->post_title ?? '' ?></span>
                                </div>
                                <div class="text-gray-text">
                                    <?php echo $post->post_excerpt ?? '' ?>
                                </div>
                            </div>
                            <div class="small-videos">
                                <?php foreach ($videos_link as $key => $video) { ?>
                                    <div class="small-video <?php echo ($key == array_key_first($videos_link)) ? 'active' : '' ?>">
                                        <video poster="<?php echo $video['poster'] ?? '' ?>">
                                            <source src="<?php echo $video['video'] ?? '' ?>"
                                                    type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>
                                        <div class="icon-play">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="12"
                                                 viewBox="0 0 24 24">
                                                <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                            </svg>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
<section class="mb-5">
    <div class="container">
        <div class="d-md-flex flex-wrap align-items-center justify-content-between mb-4">
            <div class="text-light text-2xl font-extrabold text-md-right text-center mb-md-0 mb-3">
                لیست آخرین ویدیو‌ها
            </div>
            <div class="dropdown-filters mr-auto ml-md-0 ml-auto">
                <div class="clickable d-flex align-items-center d-lg-none">
                    <div class="current-value ml-2">
                        <?php echo $category->name ?? '' ?>
                    </div>
                    <div class="arrow mr-auto">
                        <svg width="15" height="10" viewBox="0 0 15 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M2 2L7.5 7L13 2" stroke="#FFAC00" stroke-width="3" stroke-linecap="round"/>
                        </svg>
                    </div>
                </div>

                <!--items-->
                <div class="filters-items rounded-2">
                    <?php foreach ($categories as $video_category) { ?>
                        <div class="rounded-2 filter <?php echo ($video_category->slug == $category->slug) ? 'selected' : '' ?>"
                             value="0"
                             onclick="mdr_get_list_items('video', 'video_category', '<?php echo $video_category->slug ?>' )">
                            <?php echo $video_category->name ?? '' ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div id="mdr_list_items" class="list-videos">
            <?php foreach ($posts->posts as $post_list) {
                $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post_list->ID), 'single-post-thumbnail');
                ?>
                <div class="card-video mb-3">
                    <a href="<?php echo get_permalink($post_list) ?>" class="holder-video large-video mb-3">
                        <img class="rounded-4" src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>"
                             width="100%">
                        <div class="holder-play-video d-flex justify-content-center align-items-center">
                            <button class="btn-play-video">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45" viewBox="0 0 24 24">
                                    <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                </svg>
                            </button>
                        </div>
                    </a>
                    <div class="d-flex align-items-center mb-2">
                        <div class="me-2 pb-1">
                            <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M15 0.833251L9.53674e-07 14.8333L-2.70245e-07 0.833252L15 0.833251Z"
                                      fill="#FFAC00"/>
                            </svg>
                        </div>
                        <div class="text-light card-title font-weight-bold line-clamp-1">
                            <?php echo $post_list->post_title ?? '' ?>
                        </div>
                    </div>
                    <div class="text-theme-content-dark line-clamp-3 text-justify pr-4">
                        <?php echo $post->post_excerpt; ?>
                    </div>
                </div>
            <?php } ?>
        </div>
        <!-- wp:pattern {"slug":"modiram/section-pagination"} /-->
    </div>
    <div id="mdr_list_item" class="card-video mb-3" style="display: none">
        <a href="#" class="mdr_list_item_link holder-video large-video mb-3">
            <img class="mdr_list_item_image" src="" width="100%">
            <div class="holder-play-video d-flex justify-content-center align-items-center">
                <button class="btn-play-video">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45" viewBox="0 0 24 24">
                        <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                    </svg>
                </button>
            </div>
        </a>
        <div class="d-flex align-items-center mb-2">
            <div class="ml-2 pb-1">
                <svg width="15" height="15" viewBox="0 0 15 15" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 0.833251L9.53674e-07 14.8333L-2.70245e-07 0.833252L15 0.833251Z"
                          fill="#FFAC00"/>
                </svg>
            </div>
            <div class="mdr_list_item_title card-title font-weight-bold line-clamp-1">

            </div>
        </div>
        <div class="mdr_list_item_description text-gray-text line-clamp-3 text-justify pr-4">

        </div>
    </div>
</section>


