<?php
/**
 * Title: Single Product
 * Slug: modiram/section-single-product
 * Categories: product
 * Viewport width: 1400
 * Description: wide banner with text for first page.
 */

global $product, $meta, $thumbnail, $wp_query;

if (!class_exists('woocommerce') || !$product) {
    return;
}

$product = wc_get_product();
/**
 * @var WC_Product $product
 */

$thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($product->get_id()), 'single-post-thumbnail');
$content = $product->get_description();
$gallery_image_ids = $product->get_gallery_image_ids() ?? [];
$meta = get_post_meta($product->get_id());

?>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-xl-9 col-lg-8 col-md-7 order-md-0 order-1">
                <?php if (isset($meta['_video'][0])) { ?>
                    <div class="course-header-video mb-md-5 mb-4">
                        <div class="holder-video pause-hide-controls">
                            <video poster="<?php echo $meta['_poster'][0] ?>">
                                <source src="<?php echo  $meta['_video'][0]  ?>"
                                        type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                            <div class="holder-play-video d-flex flex-column justify-content-center align-items-center text-white text-center px-2">
                                <button class="btn-play-video mb-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45"
                                         viewBox="0 0 24 24">
                                        <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                    </svg>
                                </button>

                                <div class="video-info d-flex align-items-center justify-content-between p-3">
                                    <div class="logo-video ml-auto">
                                        <img src="/wp-content/themes/modiram/assets/images/app-rene-logo.png">
                                    </div>
                                    <div class="time-video fw-bold">
                                        00:00
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <?php the_content(); ?>

                <!-- wp:pattern {"slug":"modiram/section-consultation"} /-->

                <!-- wp:pattern {"slug":"modiram/section-seasons"} /-->

                <!-- wp:pattern {"slug":"modiram/section-user-video-slider"} /-->

                <!-- wp:pattern {"slug":"modiram/section-benefits"} /-->

                <!-- wp:pattern {"slug":"modiram/section-info"} /-->

                <!-- wp:pattern {"slug":"modiram/section-faq"} /-->
            </div>

            <!--sidebar-->
            <div class="col-xl-3 col-lg-4 col-md-5 order-md-1 order-0">
                <div class="single-course mb-4">
                    <div class="card-course p-md-3 p-4">
                        <div class="card-image mb-3">
                            <img src="<?php echo $thumbnail[0] ?? ''; ?>">
                        </div>
                        <div class="d-flex px-sm-1 mb-2">
                            <div class="me-1 pb-1">
                                <svg width="19" height="24" viewBox="0 0 19 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9.94695 17.3752L4.97158 19.9899L5.92407 14.4505L1.89746 10.5247L7.45927 9.7179L9.94695 4.67529L12.4384 9.7179L18.0002 10.5247L13.9736 14.4505L14.9261 19.9899L9.94695 17.3752Z"
                                          stroke="#FFAC00" stroke-width="2" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <div class="card-title fw-bold">
                                <?php echo $product->get_title(); ?>
                            </div>
                        </div>
                        <div class="card-labels px-sm-1 mb-3">
                            <?php if (!empty($meta['_teacher'][0])) { ?>
                                <div class="card-label">
                                    <div>
                                        <svg width="17" height="18" viewBox="0 0 17 18" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M4.77734 4.57548C4.77734 3.62721 5.15404 2.7178 5.82457 2.04727C6.4951 1.37674 7.40454 1 8.35281 1C9.30108 1 10.2105 1.37674 10.881 2.04727C11.5516 2.7178 11.9283 3.62721 11.9283 4.57548C11.9283 6.54992 10.3272 8.70172 8.35281 8.70172C6.37837 8.70172 4.77734 6.54525 4.77734 4.57548Z"
                                                  stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                            <path d="M15.4996 17.0011C14.9768 14.4198 11.9801 11.9646 8.35329 11.9646C4.72648 11.9646 1.72515 14.4198 1.20703 17.0011"
                                                  stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"
                                                  stroke-linecap="round"/>
                                        </svg>
                                    </div>
                                    <div class="text-label">
                                        مدرس:
                                    </div>
                                    <div>
                                        <?php echo $meta['_teacher'][0] ?? '' ?>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php if (!empty($meta['_time'][0])) { ?>
                                <div class="card-label">
                                    <div>
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8.20703 15.0005C12.073 15.0005 15.207 11.8665 15.207 8.00049C15.207 4.13449 12.073 1.00049 8.20703 1.00049C4.34104 1.00049 1.20703 4.13449 1.20703 8.00049C1.20703 11.8665 4.34104 15.0005 8.20703 15.0005Z"
                                                  stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                            <path d="M8.20703 4.15063V8.35063" stroke="#BBBBBB" stroke-width="2"
                                                  stroke-linecap="round" stroke-linejoin="round"/>
                                            <path d="M10.5453 9.56132L8.31934 8.53931" stroke="#BBBBBB" stroke-width="2"
                                                  stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </div>
                                    <div class="text-label">
                                        زمان:
                                    </div>
                                    <div>
                                        <?php echo $meta['_time'][0] ?? 0 ?>ساعت
                                    </div>
                                </div>
                            <?php } ?>
                            <?php if (!empty($meta['_participants'][0])) { ?>
                                <div class="card-label">
                                    <div>
                                        <svg width="21" height="19" viewBox="0 0 21 19" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M6.01074 4.77124C6.01074 6.05121 6.99874 7.02124 8.13574 7.02124V9.02124C5.82096 9.02124 4.01074 7.08112 4.01074 4.77124H6.01074ZM8.13574 7.02124C9.27274 7.02124 10.2607 6.05121 10.2607 4.77124H12.2607C12.2607 7.08112 10.4505 9.02124 8.13574 9.02124V7.02124ZM10.2607 4.77124C10.2607 3.49127 9.27274 2.52124 8.13574 2.52124V0.52124C10.4505 0.52124 12.2607 2.46136 12.2607 4.77124H10.2607ZM8.13574 2.52124C6.99874 2.52124 6.01074 3.49127 6.01074 4.77124H4.01074C4.01074 2.46136 5.82096 0.52124 8.13574 0.52124V2.52124ZM11.2607 12.2712H5.01074V10.2712H11.2607V12.2712ZM5.01074 16.7712H11.2607V18.7712H5.01074V16.7712ZM11.2607 16.7712C12.3977 16.7712 13.3857 15.8012 13.3857 14.5212H15.3857C15.3857 16.8311 13.5755 18.7712 11.2607 18.7712V16.7712ZM2.88574 14.5212C2.88574 15.8012 3.87374 16.7712 5.01074 16.7712V18.7712C2.69596 18.7712 0.885743 16.8311 0.885743 14.5212H2.88574ZM5.01074 12.2712C3.87374 12.2712 2.88574 13.2413 2.88574 14.5212H0.885743C0.885743 12.2114 2.69596 10.2712 5.01074 10.2712V12.2712ZM11.2607 10.2712C13.5755 10.2712 15.3857 12.2114 15.3857 14.5212H13.3857C13.3857 13.2413 12.3977 12.2712 11.2607 12.2712V10.2712Z"
                                                  fill="#BBBBBB"/>
                                            <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                                  fill="#BBBBBB"/>
                                            <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                                  fill="#BBBBBB"/>
                                            <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                                  stroke="#BBBBBB" stroke-width="0.5"/>
                                            <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                                  stroke="#BBBBBB" stroke-width="0.5"/>
                                        </svg>
                                    </div>
                                    <div class="text-label">
                                        شرکت‌کنندگان:
                                    </div>
                                    <div>
                                        <?php echo number_format($meta['_participants'][0] ?? 0) ?>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php if (!empty($meta['_execution'][0])) { ?>
                                <div class="card-label">
                                    <div class="pb-1">
                                        <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M7.39941 9.57519C8.54497 9.57519 9.47363 8.64654 9.47363 7.50098C9.47363 6.35542 8.54497 5.42676 7.39941 5.42676C6.25385 5.42676 5.3252 6.35542 5.3252 7.50098C5.3252 8.64654 6.25385 9.57519 7.39941 9.57519Z"
                                                  stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M13.5004 7.56657C13.5022 6.61966 13.2836 5.6853 12.8619 4.83749C12.4402 3.98968 11.8269 3.25168 11.0706 2.6819C10.3143 2.11212 9.4357 1.72622 8.50444 1.55473C7.57318 1.38325 6.61479 1.4309 5.70514 1.6939C4.79548 1.9569 3.95953 2.42803 3.26346 3.07001C2.56739 3.71199 2.03033 4.50718 1.69476 5.39264C1.35919 6.27811 1.23435 7.22953 1.3301 8.1716C1.42586 9.11366 1.73959 10.0205 2.24646 10.8203L3.02737 12.0405L7.39959 18.548L11.7718 12.0405L12.5527 10.8203C13.1716 9.84793 13.5003 8.7192 13.5004 7.56657V7.56657Z"
                                                  stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <?php echo $meta['_execution'][0] ?? '' ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="px-sm-1">
                            <a href="#pay_form"
                               class="btn-card bg-yellow btn-register d-flex align-items-center justify-content-between py-2 px-2 mt-auto">
                                <div class="d-flex align-items-center">
                                    <div class="me-1">
                                        <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path d="M21.25 12.4458C21.25 7.33717 17.1086 3.1958 12 3.1958C6.89137 3.1958 2.75 7.33717 2.75 12.4458C2.75 17.5544 6.89137 21.6958 12 21.6958C17.1086 21.6958 21.25 17.5544 21.25 12.4458Z"
                                                  stroke="#1B1B1B" stroke-width="1.5"/>
                                            <path d="M9 12.4458L11 14.4458L15 10.4458" stroke="#1B1B1B"
                                                  stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </div>
                                    <span class="fw-bold py-1">ثبت‌نام</span>
                                </div>
                                <div class="mr-auto">
                                    <?php if (!empty($meta['_sale_price'][0])) { ?>
                                        <div class="off-price text-sm">
                                            <?php echo number_format($meta['_regular_price'][0] ?? 0) ?>
                                        </div>
                                    <?php } ?>
                                    <div class="d-flex align-items-center">
                                        <span class="current-price text-lg fw-bold ml-1 ">
                                            <?php echo number_format($meta['_price'][0] ?? 0) ?>
                                        </span>
                                        <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                  d="M3.60288 1.63719L2.8437 0.78125L2.07261 1.59144L2.79879 2.39748L3.60288 1.63719ZM0.372938 2.01685L1.49673 2.514C1.45647 2.6587 1.41427 2.80037 1.37257 2.94032C1.28099 3.24769 1.19187 3.54682 1.13128 3.85185C0.979335 4.62655 1.31983 5.1273 2.0973 5.21437C2.567 5.2676 3.05306 5.23239 3.52581 5.18137C3.83081 5.1481 4.06289 4.9407 4.1006 4.60769C4.13471 4.30907 4.14524 4.00656 4.14968 3.70545C4.15514 3.32925 4.15534 2.95294 4.15554 2.57658V2.5762V2.5762V2.57619C4.15565 2.37959 4.15576 2.18297 4.15661 1.98635C4.16132 1.95891 4.16895 1.93205 4.17935 1.90622H5.37329C5.37329 2.19527 5.37911 2.48438 5.38493 2.77317C5.3982 3.43153 5.41143 4.08827 5.35554 4.73912C5.27763 5.64386 4.69009 6.22974 3.79366 6.36089C3.12155 6.45933 2.41256 6.50674 1.74627 6.40498C0.404547 6.20035 -0.315255 5.12952 -0.146673 3.74953C-0.115613 3.49151 -0.0618914 3.23673 0.0138685 2.98814C0.0809864 2.76986 0.164244 2.55625 0.253002 2.32853L0.253007 2.32852C0.292216 2.22792 0.332499 2.12457 0.372938 2.01685ZM0.42905 6.76642L0.429001 6.7664C0.318171 6.72224 0.204233 6.67685 0.0865058 6.62854C0.0865058 7.00028 0.0861867 7.36829 0.0858698 7.73368L0.0858698 7.73375C0.0851217 8.59638 0.0843863 9.44441 0.0878922 10.2924C0.0934376 11.6649 1.3664 12.4352 2.60332 11.8294C2.70785 11.7781 2.87116 11.7919 2.98845 11.8313C3.13364 11.8802 3.27556 11.9401 3.41735 11.9999L3.41738 11.9999C3.6108 12.0815 3.80399 12.163 4.00493 12.2164C4.82539 12.4346 5.54297 12.0875 5.75176 11.3411C5.85383 10.9712 5.8807 10.5847 5.83078 10.2043C5.73041 9.48279 5.37467 8.90717 4.6166 8.70116C3.89181 8.50429 3.26378 8.70476 2.80739 9.29341C2.59954 9.56171 2.46419 9.89439 2.3342 10.2139L2.31634 10.2578C2.14055 10.6903 1.99027 10.8331 1.63231 10.7613C1.31125 10.6974 1.32991 10.4668 1.34738 10.2508C1.35159 10.1988 1.35573 10.1475 1.35503 10.0997C1.34917 9.64433 1.34914 9.18873 1.3491 8.73306C1.34907 8.28288 1.34904 7.83262 1.34339 7.38244C1.34228 7.28207 1.27518 7.13068 1.1956 7.09241C0.95204 6.97477 0.699825 6.87429 0.42905 6.76642ZM4.66221 10.4542C4.67586 10.4957 4.68795 10.5325 4.69951 10.5619C4.68952 11.0474 4.56059 11.1406 4.18904 11.0314L4.17449 11.0271C4.10972 11.008 4.04488 10.9889 3.9822 10.9632C3.45011 10.7541 3.39216 10.3609 3.83829 9.98327C4.04375 9.80831 4.34543 9.82605 4.4921 10.0579C4.57481 10.1884 4.62444 10.3394 4.66221 10.4542ZM10.2552 10.2393C10.1625 10.238 10.0671 10.2366 9.96798 10.2366C9.96798 10.1769 9.96885 10.1175 9.96971 10.0583V10.0583V10.0582V10.0582C9.97157 9.93091 9.97341 9.80456 9.96659 9.67873C9.91973 8.79617 9.28561 8.05225 8.49372 7.94439C7.49581 7.80824 6.76519 8.21833 6.49929 9.12224C6.10307 10.4679 6.74884 11.4244 8.06838 11.471C8.19775 11.4755 8.327 11.4835 8.48073 11.4931L8.48086 11.4931L8.48124 11.4931C8.55733 11.4978 8.63943 11.503 8.73051 11.5082C8.36197 12.1395 7.80301 12.1927 7.2637 12.244C7.12702 12.257 6.99159 12.2699 6.86085 12.292V13.4976C7.64942 13.4682 8.39806 13.3917 9.07183 12.9855C9.6286 12.6494 9.88729 12.1218 9.98018 11.5024C10.089 11.4968 10.1952 11.4918 10.2995 11.4868L10.3002 11.4868H10.3002H10.3002C10.5415 11.4753 10.773 11.4642 11.0042 11.4491C11.7234 11.4017 12.3988 10.8965 12.4604 10.2588C12.5034 9.81244 12.4934 9.36105 12.4831 8.89918C12.4786 8.69369 12.474 8.48612 12.474 8.276L11.2373 8.6506C11.2373 8.77343 11.2366 8.893 11.2358 9.01029C11.2341 9.27401 11.2325 9.5262 11.2398 9.778C11.2482 10.0633 11.109 10.2147 10.8414 10.2324C10.651 10.245 10.4596 10.2423 10.2553 10.2393H10.2553H10.2553H10.2552H10.2552ZM8.70874 10.0289L8.70875 10.0289L8.70875 10.0289C8.71491 10.1021 8.72126 10.1774 8.72968 10.2555H8.73079C8.64254 10.2555 8.56184 10.2569 8.48631 10.2582H8.48626H8.48622H8.48618H8.48614H8.48612C8.33317 10.2608 8.20142 10.2631 8.07115 10.2527C7.74009 10.2263 7.59341 10.0797 7.58981 9.79962C7.58509 9.45719 7.77003 9.18934 8.0437 9.14165C8.32181 9.09341 8.57524 9.2509 8.64649 9.55396C8.68144 9.70475 8.69461 9.86105 8.70874 10.0289ZM9.58645 6.12429L9.62553 6.16131C9.85149 6.37539 10.0913 6.60264 10.3498 6.84797L9.56455 7.57942L8.90297 6.82856L9.58645 6.12429ZM10.4041 6.8556C10.6576 7.09683 10.9032 7.33112 11.1708 7.58649L11.9164 6.83314L11.1708 6.12859L10.4041 6.8556Z"
                                                  fill="black"/>
                                        </svg>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- wp:pattern {"slug":"modiram/section-product-landing-pay"} /-->

<!-- wp:pattern {"slug":"modiram/section-post-comments"} /-->
