<?php
/**
 * Title: podcast
 * Slug: modiram/section-single-podcast
 * Categories: content
 * Post Types: post, page
 */

global $post, $category, $pagination;

if (!$post) {
    return;
}

$thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
$writer = get_user_by('ID', $post->post_author);
$content = $post->post_content;
$category = get_the_terms($post, 'podcast_category')[0];
$meta = get_post_meta($post->ID);

$categories = get_categories([
    'taxonomy' => 'podcast_category',
    'parent' => 0,
    'number' => 4,
]);

$podcasts = new WP_Query([
    'post_type' => 'podcast',
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'posts_per_page' => get_option('posts_per_page'),
    'offset' => 0,
    'tax_query' => array(
        array(
            'taxonomy' => 'podcast_category',
            'field' => 'slug',
            'terms' => $category->slug,
        ),
    ),
]);

$pagination = [
    'post_type' => 'podcast',
    'taxonomy' => 'podcast_category',
    'term_slug' => $category->slug,
    'max_num_pages' => $podcasts->max_num_pages
]
?>

<header class="header-page mb-5">
    <div class="container position-relative overflow-hidden py-5">

        <!--background image-->
        <div class="bg-image">
            <div class="image">
                <img src="/wp-content/themes/modiram/assets/images/header-podcasts.png">

                <!-- bg-overlay -->
                <div class="bg-overlay"></div>
            </div>
        </div>

        <div class="pb-5">
            <div class="section-title d-inline-flex mb-3">
                <div class="title-icon bg-white">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="8" y="2" width="8" height="13" rx="4" fill="black" stroke="black" stroke-width="1.5"/>
                        <path d="M20 11.5C20 15.9183 16.4183 19.5 12 19.5C7.58172 19.5 4 15.9183 4 11.5" stroke="black"
                              stroke-width="1.5" stroke-linecap="round"/>
                        <path d="M12 22V20" stroke="black" stroke-width="1.5" stroke-linecap="round"/>
                    </svg>
                </div>
                <h3 class="title-text">
                    <?php echo $category->name ?? ''; ?>
                </h3>
            </div>
            <div class="text-white">
                در این صفحه به آخرین پادکست‌های رنه سینانی گوش خواهید داد
            </div>
        </div>

    </div>
</header>
<div class="container">
    <div class="row">
        <div class="breadcrumb-links breadcrumb-archive text-sm mb-4 col d-flex text-gray-100 column-gap-2">
            <?php mdr_print_breadcrumb() ?>
        </div>
    </div>
</div>

<section class="section-to-top mb-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-12 d-lg-block d-none pl-1">
                <div class="h-100 podcast-preview">
                    <div class="d-flex">
                        <div class="podcast-image ml-3">
                            <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                        </div>
                        <div class="w-100 d-flex align-items-center justify-content-around">
                            <div class="podcast-info">
                                <div class="text-gray font-weight-bold text-lg mb-2">
                                    <?php echo $post->post_title ?? '' ?>
                                </div>
                                <div class="text-gray-100 mb-2">
                                    <?php echo $post->post_excerpt ?? '' ?>
                                </div>
                                <div class="d-flex text-yellow-100 text-sm font-semibold">
                                    <div class="d-flex align-items-center me-3">
                                        <div class="me-1">
                                            <svg width="16" height="13" viewBox="0 0 16 13" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                      d="M8.00017 4.00008C6.61945 4.00008 5.50017 5.11937 5.50017 6.50008C5.50017 7.88079 6.61945 9.00008 8.00017 9.00008C9.38088 9.00008 10.5002 7.88079 10.5002 6.50008C10.5002 5.11937 9.38088 4.00008 8.00017 4.00008ZM6.50017 6.50008C6.50017 5.67165 7.17174 5.00008 8.00017 5.00008C8.82859 5.00008 9.50017 5.67165 9.50017 6.50008C9.50017 7.32851 8.82859 8.00008 8.00017 8.00008C7.17174 8.00008 6.50017 7.32851 6.50017 6.50008Z"
                                                      fill="#D4B114"/>
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                      d="M8.00017 0.666748C6.57286 0.666748 5.28233 1.37274 4.23465 2.23056C3.18125 3.09306 2.31991 4.15251 1.74111 4.95876L1.69337 5.02514C1.34493 5.5093 1.05811 5.90785 1.05811 6.50008C1.05811 7.09231 1.34493 7.49086 1.69337 7.97502L1.74111 8.04141C2.31991 8.84765 3.18125 9.90711 4.23465 10.7696C5.28233 11.6274 6.57286 12.3334 8.00017 12.3334C9.42747 12.3334 10.718 11.6274 11.7657 10.7696C12.8191 9.90711 13.6804 8.84765 14.2592 8.0414L14.307 7.97503C14.6554 7.49086 14.9422 7.09231 14.9422 6.50008C14.9422 5.90785 14.6554 5.50931 14.307 5.02514L14.2592 4.95876C13.6804 4.15251 12.8191 3.09306 11.7657 2.23056C10.718 1.37274 9.42747 0.666748 8.00017 0.666748ZM2.55345 5.54194C3.1063 4.77185 3.90915 3.78951 4.86817 3.00429C5.8329 2.21439 6.90299 1.66675 8.00017 1.66675C9.09735 1.66675 10.1674 2.21439 11.1322 3.00429C12.0912 3.78951 12.894 4.77185 13.4469 5.54194C13.8629 6.12137 13.9422 6.26107 13.9422 6.50008C13.9422 6.7391 13.8629 6.87879 13.4469 7.45822C12.894 8.22831 12.0912 9.21065 11.1322 9.99587C10.1674 10.7858 9.09735 11.3334 8.00017 11.3334C6.90299 11.3334 5.8329 10.7858 4.86817 9.99587C3.90915 9.21066 3.1063 8.22831 2.55345 7.45822C2.13747 6.87879 2.05811 6.7391 2.05811 6.50008C2.05811 6.26107 2.13747 6.12137 2.55345 5.54194Z"
                                                      fill="#D4B114"/>
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                      d="M8.00017 4.00008C6.61945 4.00008 5.50017 5.11937 5.50017 6.50008C5.50017 7.88079 6.61945 9.00008 8.00017 9.00008C9.38088 9.00008 10.5002 7.88079 10.5002 6.50008C10.5002 5.11937 9.38088 4.00008 8.00017 4.00008ZM6.50017 6.50008C6.50017 5.67165 7.17174 5.00008 8.00017 5.00008C8.82859 5.00008 9.50017 5.67165 9.50017 6.50008C9.50017 7.32851 8.82859 8.00008 8.00017 8.00008C7.17174 8.00008 6.50017 7.32851 6.50017 6.50008Z"
                                                      stroke="#D4B114" stroke-width="0.7"/>
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                      d="M8.00017 0.666748C6.57286 0.666748 5.28233 1.37274 4.23465 2.23056C3.18125 3.09306 2.31991 4.15251 1.74111 4.95876L1.69337 5.02514C1.34493 5.5093 1.05811 5.90785 1.05811 6.50008C1.05811 7.09231 1.34493 7.49086 1.69337 7.97502L1.74111 8.04141C2.31991 8.84765 3.18125 9.90711 4.23465 10.7696C5.28233 11.6274 6.57286 12.3334 8.00017 12.3334C9.42747 12.3334 10.718 11.6274 11.7657 10.7696C12.8191 9.90711 13.6804 8.84765 14.2592 8.0414L14.307 7.97503C14.6554 7.49086 14.9422 7.09231 14.9422 6.50008C14.9422 5.90785 14.6554 5.50931 14.307 5.02514L14.2592 4.95876C13.6804 4.15251 12.8191 3.09306 11.7657 2.23056C10.718 1.37274 9.42747 0.666748 8.00017 0.666748ZM2.55345 5.54194C3.1063 4.77185 3.90915 3.78951 4.86817 3.00429C5.8329 2.21439 6.90299 1.66675 8.00017 1.66675C9.09735 1.66675 10.1674 2.21439 11.1322 3.00429C12.0912 3.78951 12.894 4.77185 13.4469 5.54194C13.8629 6.12137 13.9422 6.26107 13.9422 6.50008C13.9422 6.7391 13.8629 6.87879 13.4469 7.45822C12.894 8.22831 12.0912 9.21065 11.1322 9.99587C10.1674 10.7858 9.09735 11.3334 8.00017 11.3334C6.90299 11.3334 5.8329 10.7858 4.86817 9.99587C3.90915 9.21066 3.1063 8.22831 2.55345 7.45822C2.13747 6.87879 2.05811 6.7391 2.05811 6.50008C2.05811 6.26107 2.13747 6.12137 2.55345 5.54194Z"
                                                      stroke="#D4B114" stroke-width="0.7"/>
                                            </svg>
                                        </div>
                                        <div>
                                            2,214 بازدید
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="me-1">
                                            <svg width="16" height="17" viewBox="0 0 16 17" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path d="M12.6667 8.49992C12.6667 10.3668 12.6667 11.3002 12.3034 12.0132C11.9838 12.6404 11.4738 13.1504 10.8466 13.4699C10.1336 13.8333 9.20018 13.8333 7.33333 13.8333C5.46649 13.8333 4.53307 13.8333 3.82003 13.4699C3.19282 13.1504 2.68289 12.6404 2.36331 12.0132C2 11.3002 2 10.3668 2 8.49992C2 6.63308 2 5.69966 2.36331 4.98662C2.68289 4.35941 3.19282 3.84947 3.82003 3.5299C4.53307 3.16659 5.46649 3.16659 7.33333 3.16659C9.20018 3.16659 10.1336 3.16659 10.8466 3.5299C11.4738 3.84947 11.9838 4.35941 12.3034 4.98662C12.6667 5.69966 12.6667 6.63308 12.6667 8.49992ZM12.6667 8.49992H14M7.33334 5.83325V8.16659C7.33334 8.71887 7.78105 9.16659 8.33333 9.16659V9.16659H9.33333M4.66667 1.83325H10M4.66667 15.1666H10"
                                                      stroke="#D4B114" stroke-width="1.5" stroke-linecap="round"/>
                                            </svg>
                                        </div>
                                        <div>
                                            2 دقیقه
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="audio-bar-animation mr-auto me-4">
                                <div class="bars stop">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12 pr-lg-1">
                <!--audio player-->
                <div class="d-flex flex-column justify-content-center audio-player position-relative" id="audio-player">

                    <div class="podcast-image d-lg-none mb-3">
                        <img class="w-100" src="<?php get_theme_file_uri('assets/images/podcast-image.png') ?>">
                    </div>

                    <div class="d-flex mb-lg-4 mb-3 justify-content-between">

                        <!-- Volume Slider -->
                        <div class="volume-control d-flex align-items-center">
                            <button class="btn-mute">
                                <svg width="27" height="20" viewBox="0 0 27 20" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6.48658 14.4994C4.05241 14.4994 2.70899 13.977 1.96383 13.2643C1.23097 12.5634 0.9 11.5079 0.9 10.0013C0.9 8.55615 1.31388 7.48065 2.11852 6.75249C2.93838 6.01057 4.30782 5.49787 6.48659 5.49787C7.77929 5.49787 8.75596 5.21145 9.53213 4.73034C10.2947 4.25766 10.7953 3.63707 11.1859 3.10937C11.2669 2.99991 11.3415 2.89736 11.4116 2.80102C11.706 2.39646 11.9207 2.10138 12.196 1.86355C12.4772 1.62068 12.8174 1.44995 13.4012 1.44995C14.0013 1.44995 14.4538 1.63135 14.8244 1.94964C15.2127 2.28309 15.5591 2.80963 15.8431 3.56581C16.4175 5.09479 16.65 7.32225 16.65 10.0013C16.65 12.6803 16.4175 14.9071 15.8432 16.4353C15.5592 17.1911 15.2128 17.7173 14.8246 18.0505C14.454 18.3686 14.0015 18.55 13.4012 18.55C12.8212 18.55 12.524 18.3825 12.2895 18.1618C12.0603 17.946 11.893 17.6922 11.6562 17.3328C11.5739 17.2079 11.4832 17.0703 11.3786 16.9171C11.0069 16.3728 10.5151 15.7396 9.71498 15.2602C8.91062 14.7783 7.87714 14.4994 6.48658 14.4994Z"
                                          stroke="#4F4F4F" stroke-width="1.8"/>
                                    <path d="M22.1084 3.25C22.1084 3.25 23.1589 4.48583 23.6513 5.5C24.3949 7.03178 24.8084 8.12314 24.8084 10C24.8084 11.8769 24.3949 12.9682 23.6513 14.5C23.1589 15.5142 22.1084 16.75 22.1084 16.75"
                                          stroke="#4F4F4F" stroke-width="1.8" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                    <path d="M20.25 6.8501C20.25 6.8501 20.6002 7.42682 20.7643 7.9001C21.0122 8.61493 21.15 9.12423 21.15 10.0001C21.15 10.876 21.0122 11.3853 20.7643 12.1001C20.6002 12.5734 20.25 13.1501 20.25 13.1501"
                                          stroke="#4F4F4F" stroke-width="1.8" stroke-linecap="round"
                                          stroke-linejoin="round"/>
                                </svg>
                            </button>
                            <div class="customize-range-input">
                                <input type="range" min="0" max="1" step="0.1" value="1">

                                <!--bar active-->
                                <div class="progress-active progress-active-volume"></div>
                            </div>
                        </div>

                        <!--play back Rate-->
                        <button class="btn-play-back-rate font-semibold text-lg text-gray ml-auto">
                            2x
                        </button>

                    </div>

                    <!--controls-->
                    <div class="audio-controls d-lg-inline-flex d-flex justify-content-center mb-lg-0 mb-md-4 mb-3">

                        <!-- +15s -->
                        <button class="btn-back">
                            <svg width="24" height="26" viewBox="0 0 24 26" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M0.178817 18.3498C1.1387 20.3417 2.61671 22.0388 4.45795 23.2631C6.29918 24.4874 8.43585 25.194 10.644 25.3086C17.4372 25.6602 23.2392 20.4318 23.5908 13.6386C23.9436 6.84541 18.714 1.04461 11.9208 0.691811C10.1385 0.597991 8.35721 0.893192 6.70048 1.55692C5.39525 2.07983 4.192 2.8216 3.1414 3.74774L3.01201 1.65909C3.00651 1.53986 2.97736 1.42293 2.92624 1.31508C2.87512 1.20723 2.80307 1.11062 2.71427 1.03089C2.62546 0.951147 2.52169 0.889867 2.40898 0.850612C2.29627 0.811358 2.17688 0.794912 2.05776 0.802233C1.93863 0.809554 1.82215 0.840495 1.7151 0.893256C1.60805 0.946016 1.51256 1.01954 1.43419 1.10955C1.35582 1.19957 1.29613 1.30427 1.25861 1.41756C1.22108 1.53086 1.20646 1.65049 1.21561 1.76949L1.50721 6.48549C1.52202 6.7237 1.63085 6.94627 1.80976 7.10425C1.98867 7.26222 2.22299 7.34267 2.46121 7.32789L7.23601 7.03269C7.35523 7.02719 7.47217 6.99803 7.58002 6.94692C7.68786 6.8958 7.78447 6.82375 7.86421 6.73494C7.94395 6.64614 8.00523 6.54237 8.04448 6.42966C8.08374 6.31695 8.10018 6.19756 8.09286 6.07844C8.08554 5.95931 8.0546 5.84283 8.00184 5.73578C7.94908 5.62873 7.87555 5.53324 7.78554 5.45486C7.69553 5.37649 7.59083 5.31681 7.47753 5.27928C7.36423 5.24176 7.24461 5.22714 7.12561 5.23629L3.97254 5.43049C4.95041 4.48419 6.10402 3.73581 7.36999 3.22854C8.7849 2.66158 10.3062 2.40937 11.8284 2.48941C17.6292 2.79061 22.0944 7.74421 21.7932 13.545C21.4932 19.3458 16.5384 23.8122 10.7376 23.511C8.85176 23.4129 7.02702 22.8093 5.45457 21.7636C3.88212 20.7179 2.61985 19.2686 1.80002 17.5674C1.69626 17.3524 1.51136 17.1875 1.28598 17.1088C1.0606 17.0302 0.813202 17.0443 0.598217 17.148C0.383233 17.2518 0.218269 17.4367 0.139616 17.6621C0.0609632 17.8874 0.0750644 18.1348 0.178817 18.3498ZM7.34883 10.0255V17.2255C7.34883 17.4642 7.44365 17.6932 7.61243 17.8619C7.78121 18.0307 8.01013 18.1255 8.24883 18.1255C8.48752 18.1255 8.71644 18.0307 8.88522 17.8619C9.054 17.6932 9.14883 17.4642 9.14883 17.2255V10.0255C9.14883 9.78684 9.054 9.55793 8.88522 9.38914C8.71644 9.22036 8.48752 9.12554 8.24883 9.12554C8.01013 9.12554 7.78121 9.22036 7.61243 9.38914C7.44365 9.55793 7.34883 9.78684 7.34883 10.0255ZM14.8488 9.12554H11.8488C11.6101 9.12554 11.3812 9.22036 11.2124 9.38914C11.0436 9.55793 10.9488 9.78684 10.9488 10.0255V13.0255C10.9488 13.5223 11.352 13.9255 11.8488 13.9255H13.6488C14.1876 13.9255 14.5488 14.4967 14.5488 15.1255C14.5488 15.7543 14.1876 16.3255 13.6488 16.3255H11.8488C11.6101 16.3255 11.3812 16.4204 11.2124 16.5891C11.0436 16.7579 10.9488 16.9868 10.9488 17.2255C10.9488 17.4642 11.0436 17.6932 11.2124 17.8619C11.3812 18.0307 11.6101 18.1255 11.8488 18.1255H13.6488C15.0996 18.1255 16.3488 16.8175 16.3488 15.1255C16.3488 13.4323 15.0996 12.1255 13.6488 12.1255H12.7488V10.9255H14.8488C15.0875 10.9255 15.3164 10.8307 15.4852 10.6619C15.654 10.4932 15.7488 10.2642 15.7488 10.0255C15.7488 9.78684 15.654 9.55793 15.4852 9.38914C15.3164 9.22036 15.0875 9.12554 14.8488 9.12554Z"
                                      fill="#4F4F4F"/>
                            </svg>
                        </button>

                        <!-- play-pause -->
                        <button class="btn-play-pause">
                                <span class="icon-paly">
                                    <svg width="36" height="36" viewBox="0 0 33 36" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M31.1046 15.5455C31.5188 15.7784 31.8635 16.1173 32.1034 16.5275C32.3433 16.9377 32.4697 17.4043 32.4697 17.8794C32.4697 18.3546 32.3433 18.8212 32.1034 19.2314C31.8635 19.6415 31.5188 19.9805 31.1046 20.2134L4.96931 34.915C4.56182 35.1445 4.10134 35.2632 3.63371 35.2594C3.16608 35.2555 2.70761 35.1293 2.30391 34.8933C1.90022 34.6572 1.56538 34.3196 1.33272 33.9139C1.10006 33.5082 0.977688 33.0487 0.977789 32.5811L0.977789 3.17777C0.977793 2.71028 1.10019 2.25094 1.33279 1.84543C1.5654 1.43991 1.90011 1.10236 2.30364 0.866338C2.70718 0.630316 3.16547 0.504049 3.63294 0.500096C4.10041 0.496142 4.56078 0.61464 4.96824 0.843803L31.1046 15.5455Z"
                                              fill="#4F4F4F"/>
                                    </svg>
                                </span>
                            <span class="icon-pause">
                                    <svg fill="none" height="36" viewBox="0 0 12 12" xmlns="http://www.w3.org/2000/svg">
                                        <g fill="#4F4F4F">
                                            <path d="m3 2c-.55229 0-1 .44772-1 1v6c0 .55228.44771 1 1 1h1c.55229 0 1-.44772 1-1v-6c0-.55228-.44771-1-1-1z"/>
                                            <path d="m8 2c-.55229 0-1 .44772-1 1v6c0 .55228.44771 1 1 1h1c.55229 0 1-.44772 1-1v-6c0-.55228-.44771-1-1-1z"/>
                                        </g>
                                    </svg>
                                </span>
                        </button>

                        <!-- -15s -->
                        <button class="btn-forward">
                            <svg width="25" height="26" viewBox="0 0 25 26" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M22.4151 17.5673C21.5952 19.2685 20.333 20.7178 18.7605 21.7635C17.1881 22.8092 15.3633 23.4128 13.4775 23.5109C7.67667 23.8121 2.72187 19.3469 2.42187 13.5449C2.12067 7.74413 6.58587 2.79053 12.3867 2.48933C13.909 2.40919 15.4304 2.66148 16.8454 3.22866C18.1113 3.7361 19.2648 4.4847 20.2424 5.43125L17.0895 5.23608C16.8588 5.23434 16.6363 5.32107 16.4677 5.47843C16.2991 5.63579 16.1973 5.85179 16.1831 6.08197C16.169 6.31216 16.2436 6.53901 16.3917 6.71582C16.5398 6.89264 16.75 7.00597 16.9791 7.03248L21.7539 7.32768C21.9921 7.34246 22.2264 7.26202 22.4053 7.10404C22.5842 6.94606 22.693 6.72349 22.7079 6.48528L22.9995 1.77048C23.0112 1.534 22.9293 1.30241 22.7715 1.1259C22.6137 0.949382 22.3927 0.842168 22.1564 0.827487C21.92 0.812806 21.6875 0.891841 21.509 1.04746C21.3306 1.20309 21.2206 1.42276 21.2031 1.65888L21.0736 3.74867C20.0231 2.82245 18.8199 2.08055 17.5147 1.5575C15.858 0.893567 14.0766 0.59814 12.2943 0.691726C5.50107 1.04453 0.271473 6.84533 0.624273 13.6385C0.975873 20.4317 6.77787 25.6613 13.5711 25.3085C15.7791 25.1939 17.9156 24.4875 19.7568 23.2634C21.598 22.0393 23.0761 20.3426 24.0363 18.3509C24.128 18.1377 24.1338 17.8973 24.0527 17.6798C23.9715 17.4623 23.8095 17.2846 23.6005 17.1835C23.3916 17.0825 23.1516 17.0661 22.9308 17.1375C22.71 17.209 22.5252 17.363 22.4151 17.5673ZM9.06626 10.0253V17.2253C9.06626 17.464 9.16108 17.6929 9.32987 17.8617C9.49865 18.0304 9.72757 18.1253 9.96626 18.1253C10.205 18.1253 10.4339 18.0304 10.6027 17.8617C10.7714 17.6929 10.8663 17.464 10.8663 17.2253V10.0253C10.8663 9.78657 10.7714 9.55765 10.6027 9.38887C10.4339 9.22009 10.205 9.12527 9.96626 9.12527C9.72757 9.12527 9.49865 9.22009 9.32987 9.38887C9.16108 9.55765 9.06626 9.78657 9.06626 10.0253ZM16.5663 9.12527H13.5663C13.3276 9.12527 13.0986 9.22009 12.9299 9.38887C12.7611 9.55765 12.6663 9.78657 12.6663 10.0253V13.0253C12.6663 13.5221 13.0695 13.9253 13.5663 13.9253H15.3663C15.9051 13.9253 16.2663 14.4965 16.2663 15.1253C16.2663 15.7541 15.9051 16.3253 15.3663 16.3253H13.5663C13.3276 16.3253 13.0986 16.4201 12.9299 16.5889C12.7611 16.7577 12.6663 16.9866 12.6663 17.2253C12.6663 17.464 12.7611 17.6929 12.9299 17.8617C13.0986 18.0304 13.3276 18.1253 13.5663 18.1253H15.3663C16.8171 18.1253 18.0663 16.8173 18.0663 15.1253C18.0663 13.4333 16.8171 12.1253 15.3663 12.1253H14.4663V10.9253H16.5663C16.805 10.9253 17.0339 10.8304 17.2027 10.6617C17.3714 10.4929 17.4663 10.264 17.4663 10.0253C17.4663 9.78657 17.3714 9.55765 17.2027 9.38887C17.0339 9.22009 16.805 9.12527 16.5663 9.12527Z"
                                      fill="#4F4F4F"/>
                            </svg>
                        </button>

                    </div>

                    <div class="d-flex align-items-center" dir="ltr">
                        <span class="current-time font-weight-bold">0:00</span>

                        <!-- Track Slider -->
                        <div class="customize-range-input track-slider w-100 mx-2">
                            <input type="range" min="0" value="0">

                            <!--bar active-->
                            <div class="progress-active progress-active-track"></div>
                        </div>

                        <span class="total-duration font-semibold">0:00</span>
                    </div>

                    <!-- Audio -->
                    <audio controls class="d-none">
                        <source src="<?php echo $meta['mdr_podcast_url'][0] ?? '' ?>" type="audio/mpeg">
                        Your browser does not support the audio tag.
                    </audio>

                </div>
            </div>
        </div>
    </div>
</section>

<section class="mb-5">
    <div class="container">
        <div class="d-md-flex flex-wrap align-items-center justify-content-between mb-4">
            <div class="text-2xl font-extrabold text-md-right text-center mb-md-0 mb-3">
                لیست آخرین پادکست‌ها
            </div>
            <div class="dropdown-filters mr-auto ml-md-0 ml-auto">
                <div class="clickable d-flex align-items-center justify-content-between d-lg-none">
                    <div class="current-value ml-2">
                        <?php echo $category->name ?? '' ?>
                    </div>
                    <div class="arrow mr-auto">
                        <svg width="15" height="10" viewBox="0 0 15 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M2 2L7.5 7L13 2" stroke="#FFAC00" stroke-width="3" stroke-linecap="round"/>
                        </svg>
                    </div>
                </div>

                <!--items-->
                <div class="filters-items">
                    <?php foreach ($categories as $podcast_category) { ?>
                        <div class="filter <?php echo ($podcast_category->slug == $category->slug) ? 'selected' : '' ?>"
                             value="0"
                             onclick="mdr_get_list_items('podcast', 'podcast_category', '<?php echo $podcast_category->slug ?>' )">
                            <?php echo $podcast_category->name ?? '' ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div id="mdr_list_items" class="list-podcasts mb-5">
            <?php foreach ($podcasts->posts as $podcast_list) {
                $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($podcast_list->ID), 'single-post-thumbnail');
                ?>
                <a href="<?php echo get_permalink($podcast_list) ?>" class="card-podcast card-red mb-2">
                    <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                    <div class="podcast-description d-flex align-items-center justify-content-between py-2 px-3">
                        <div class="podcast-title line-clamp-1 text-white font-weight-bold ml-1">
                            <?php echo $podcast_list->post_title ?? '' ?>
                        </div>
                        <div>
                            <svg width="34" height="34" viewBox="0 0 34 34" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <circle cx="17" cy="17" r="17" fill="white"/>
                                <mask id="mask0_2885_1202" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0"
                                      y="0"
                                      width="34" height="34">
                                    <circle cx="17" cy="17" r="17" fill="#DF331F"/>
                                </mask>
                                <g mask="url(#mask0_2885_1202)">
                                </g>
                                <path d="M23.8402 15.6711C24.8631 16.2617 24.8631 17.7381 23.8402 18.3287L14.7307 23.588C13.7078 24.1786 12.4291 23.4404 12.4291 22.2592L12.4291 11.7405C12.4291 10.5594 13.7078 9.82113 14.7307 10.4117L23.8402 15.6711Z"
                                      fill="currentColor"/>
                            </svg>
                        </div>
                    </div>
                </a>
            <?php } ?>
        </div>
        <!-- wp:pattern {"slug":"modiram/section-pagination"} /-->
    </div>
    <a id="mdr_list_item" href="#" class="card-podcast card-red mb-2" style="display: none">
        <img class="mdr_list_item_image" src="">
        <div class="podcast-description d-flex align-items-center justify-content-between py-2 px-3">
            <div class="mdr_list_item_title podcast-title line-clamp-1 text-white font-weight-bold ml-1">

            </div>
            <div>
                <svg width="34" height="34" viewBox="0 0 34 34" fill="none"
                     xmlns="http://www.w3.org/2000/svg">
                    <circle cx="17" cy="17" r="17" fill="white"/>
                    <mask id="mask0_2885_1202" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0"
                          y="0"
                          width="34" height="34">
                        <circle cx="17" cy="17" r="17" fill="#DF331F"/>
                    </mask>
                    <g mask="url(#mask0_2885_1202)">
                    </g>
                    <path d="M23.8402 15.6711C24.8631 16.2617 24.8631 17.7381 23.8402 18.3287L14.7307 23.588C13.7078 24.1786 12.4291 23.4404 12.4291 22.2592L12.4291 11.7405C12.4291 10.5594 13.7078 9.82113 14.7307 10.4117L23.8402 15.6711Z"
                          fill="currentColor"/>
                </svg>
            </div>
        </div>
    </a>
</section>

