<?php
/**
 * Title: seminars
 * Slug: modiram/section-seminars
 * Categories: query
 * Post Types: post, page
 */
?>

<section class="section-to-top mb-5">
    <div class="container">
        <div class="selected-seminar p-md-4 p-3">
            <div class="row">
                <div class="col-md-6">
                    <div class="seminar-image mb-lg-0 mb-3">
                        <img src="/wp-content/themes/modiram/assets/images/seminar1.png">

                        <!-- date -->
                        <div class="seminar-date d-inline-flex align-items-center mb-3">
                            <div class="date-icon">
                                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M1.82651 6.0973C2.09192 4.05971 3.83434 2.48617 5.94428 2.48617H11.7221C13.832 2.48617 15.5744 4.05971 15.8398 6.0973H1.82651ZM1.7915 7.18064V12.4167C1.7915 14.7102 3.65077 16.5695 5.94428 16.5695H11.7221C14.0156 16.5695 15.8748 14.7102 15.8748 12.4167V7.18064H1.7915ZM4.86106 10.0694C4.5619 10.0694 4.31939 9.82693 4.31939 9.52778C4.31939 9.22862 4.5619 8.98611 4.86106 8.98611H5.58328C5.88243 8.98611 6.12495 9.22862 6.12495 9.52778C6.12495 9.82693 5.88243 10.0694 5.58328 10.0694H4.86106ZM7.9305 9.52778C7.9305 9.82693 8.17301 10.0694 8.47217 10.0694H9.19439C9.49354 10.0694 9.73606 9.82693 9.73606 9.52778C9.73606 9.22862 9.49354 8.98611 9.19439 8.98611H8.47217C8.17301 8.98611 7.9305 9.22862 7.9305 9.52778ZM12.0833 10.0694C11.7841 10.0694 11.5416 9.82693 11.5416 9.52778C11.5416 9.22862 11.7841 8.98611 12.0833 8.98611H12.8055C13.1047 8.98611 13.3472 9.22862 13.3472 9.52778C13.3472 9.82693 13.1047 10.0694 12.8055 10.0694H12.0833ZM4.3195 12.4166C4.3195 12.7157 4.56201 12.9582 4.86117 12.9582H5.58339C5.88254 12.9582 6.12505 12.7157 6.12505 12.4166C6.12505 12.1174 5.88254 11.8749 5.58339 11.8749H4.86117C4.56201 11.8749 4.3195 12.1174 4.3195 12.4166ZM8.47228 12.9582C8.17312 12.9582 7.93061 12.7157 7.93061 12.4166C7.93061 12.1174 8.17312 11.8749 8.47228 11.8749H9.1945C9.49365 11.8749 9.73617 12.1174 9.73617 12.4166C9.73617 12.7157 9.49365 12.9582 9.1945 12.9582H8.47228ZM11.5417 12.4166C11.5417 12.7157 11.7842 12.9582 12.0834 12.9582H12.8056C13.1048 12.9582 13.3473 12.7157 13.3473 12.4166C13.3473 12.1174 13.1048 11.8749 12.8056 11.8749H12.0834C11.7842 11.8749 11.5417 12.1174 11.5417 12.4166ZM12.0832 1.40283C11.784 1.40283 11.5415 1.64534 11.5415 1.9445V4.11117C11.5415 4.41032 11.784 4.65283 12.0832 4.65283C12.3823 4.65283 12.6248 4.41032 12.6248 4.11117V1.9445C12.6248 1.64534 12.3823 1.40283 12.0832 1.40283ZM5.58317 1.40283C5.28402 1.40283 5.0415 1.64534 5.0415 1.9445L5.0415 4.11117C5.0415 4.41032 5.28402 4.65283 5.58317 4.65283C5.88232 4.65283 6.12484 4.41032 6.12484 4.11117V1.9445C6.12484 1.64534 5.88232 1.40283 5.58317 1.40283Z" fill="white"/>
                                </svg>
                            </div>
                            <div class="date-text font-semibold pt-1 px-2">
                                1403/06/18
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="h-100 d-flex flex-column justify-content-center">
                        <div class="d-flex align-items-center mb-3">
                            <div class="ml-1">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                                    <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                                    <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                                    <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                                    <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                                    <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                                    <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                                    <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                                    <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                                    <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                                </svg>
                            </div>
                            <div class="seminar-title font-weight-bold line-clamp-1">
                                همایش بزرگ توربو
                            </div>
                        </div>
                        <div class="d-flex align-items-center flex-wrap mb-3">
                            <div class="d-flex align-items-center ml-4 mb-1">
                                <div class="ml-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                                        <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div>
                                    18 شهریور 1403
                                </div>
                            </div>
                            <div class="d-flex align-items-center mb-1">
                                <div class="ml-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                                        <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                                    </svg>
                                </div>
                                <div class="line-clamp-1">
                                    سالن بین‌المللی همایش‌های برج میلاد
                                </div>
                            </div>
                        </div>

                        <!--set time in data-date attr (format is "Nov 29, 2024 16:50:24") -->
                        <div id="timer-holder" class="timer-holder d-flex align-items-center flex-wrap mb-3" data-date="Nov 29, 2024 16:59:24">
                            <div class="box-numbers days mx-1 mb-2">
                                <div class="number digit-1">0</div>
                                <div class="number digit-2">0</div>
                            </div>
                            روز و
                            <div class="box-numbers hours mx-1 mb-2">
                                <div class="number digit-1">0</div>
                                <div class="number digit-2">0 </div>
                            </div>
                            ساعت و
                            <div class="box-numbers minutes mx-1 mb-2">
                                <div class="number digit-1">0</div>
                                <div class="number digit-2">0</div>
                            </div>
                            دقیقه تا انتهای ثبت‌نام باقی است.
                        </div>

                        <a href="#" class="seminar-button bg-yellow d-flex align-items-center justify-content-between py-2 px-3">
                            <div class="d-flex align-items-center">
                                <div class="ml-1">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#1B1B1B" stroke-width="1.5"/>
                                        <path d="M9 12L11 14L15 10" stroke="#1B1B1B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span class="font-weight-bold py-1">ثبت‌نام</span>
                            </div>
                            <div class="mr-auto">
                                <div class="off-price text-sm">
                                    2,730,000
                                </div>
                                <div class="d-flex align-items-center">
                                    <span class="current-price text-xl font-weight-bold ml-1 ">1,250,000</span>
                                    <svg width="13" height="14" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M3.60288 1.63719L2.8437 0.78125L2.07261 1.59144L2.79879 2.39748L3.60288 1.63719ZM0.372938 2.01685L1.49673 2.514C1.45647 2.6587 1.41427 2.80037 1.37257 2.94032C1.28099 3.24769 1.19187 3.54682 1.13128 3.85185C0.979335 4.62655 1.31983 5.1273 2.0973 5.21437C2.567 5.2676 3.05306 5.23239 3.52581 5.18137C3.83081 5.1481 4.06289 4.9407 4.1006 4.60769C4.13471 4.30907 4.14524 4.00656 4.14968 3.70545C4.15514 3.32925 4.15534 2.95294 4.15554 2.57658V2.5762V2.5762V2.57619C4.15565 2.37959 4.15576 2.18297 4.15661 1.98635C4.16132 1.95891 4.16895 1.93205 4.17935 1.90622H5.37329C5.37329 2.19527 5.37911 2.48438 5.38493 2.77317C5.3982 3.43153 5.41143 4.08827 5.35554 4.73912C5.27763 5.64386 4.69009 6.22974 3.79366 6.36089C3.12155 6.45933 2.41256 6.50674 1.74627 6.40498C0.404547 6.20035 -0.315255 5.12952 -0.146673 3.74953C-0.115613 3.49151 -0.0618914 3.23673 0.0138685 2.98814C0.0809864 2.76986 0.164244 2.55625 0.253002 2.32853L0.253007 2.32852C0.292216 2.22792 0.332499 2.12457 0.372938 2.01685ZM0.42905 6.76642L0.429001 6.7664C0.318171 6.72224 0.204233 6.67685 0.0865058 6.62854C0.0865058 7.00028 0.0861867 7.36829 0.0858698 7.73368L0.0858698 7.73375C0.0851217 8.59638 0.0843863 9.44441 0.0878922 10.2924C0.0934376 11.6649 1.3664 12.4352 2.60332 11.8294C2.70785 11.7781 2.87116 11.7919 2.98845 11.8313C3.13364 11.8802 3.27556 11.9401 3.41735 11.9999L3.41738 11.9999C3.6108 12.0815 3.80399 12.163 4.00493 12.2164C4.82539 12.4346 5.54297 12.0875 5.75176 11.3411C5.85383 10.9712 5.8807 10.5847 5.83078 10.2043C5.73041 9.48279 5.37467 8.90717 4.6166 8.70116C3.89181 8.50429 3.26378 8.70476 2.80739 9.29341C2.59954 9.56171 2.46419 9.89439 2.3342 10.2139L2.31634 10.2578C2.14055 10.6903 1.99027 10.8331 1.63231 10.7613C1.31125 10.6974 1.32991 10.4668 1.34738 10.2508C1.35159 10.1988 1.35573 10.1475 1.35503 10.0997C1.34917 9.64433 1.34914 9.18873 1.3491 8.73306C1.34907 8.28288 1.34904 7.83262 1.34339 7.38244C1.34228 7.28207 1.27518 7.13068 1.1956 7.09241C0.95204 6.97477 0.699825 6.87429 0.42905 6.76642ZM4.66221 10.4542C4.67586 10.4957 4.68795 10.5325 4.69951 10.5619C4.68952 11.0474 4.56059 11.1406 4.18904 11.0314L4.17449 11.0271C4.10972 11.008 4.04488 10.9889 3.9822 10.9632C3.45011 10.7541 3.39216 10.3609 3.83829 9.98327C4.04375 9.80831 4.34543 9.82605 4.4921 10.0579C4.57481 10.1884 4.62444 10.3394 4.66221 10.4542ZM10.2552 10.2393C10.1625 10.238 10.0671 10.2366 9.96798 10.2366C9.96798 10.1769 9.96885 10.1175 9.96971 10.0583V10.0583V10.0582V10.0582C9.97157 9.93091 9.97341 9.80456 9.96659 9.67873C9.91973 8.79617 9.28561 8.05225 8.49372 7.94439C7.49581 7.80824 6.76519 8.21833 6.49929 9.12224C6.10307 10.4679 6.74884 11.4244 8.06838 11.471C8.19775 11.4755 8.327 11.4835 8.48073 11.4931L8.48086 11.4931L8.48124 11.4931C8.55733 11.4978 8.63943 11.503 8.73051 11.5082C8.36197 12.1395 7.80301 12.1927 7.2637 12.244C7.12702 12.257 6.99159 12.2699 6.86085 12.292V13.4976C7.64942 13.4682 8.39806 13.3917 9.07183 12.9855C9.6286 12.6494 9.88729 12.1218 9.98018 11.5024C10.089 11.4968 10.1952 11.4918 10.2995 11.4868L10.3002 11.4868H10.3002H10.3002C10.5415 11.4753 10.773 11.4642 11.0042 11.4491C11.7234 11.4017 12.3988 10.8965 12.4604 10.2588C12.5034 9.81244 12.4934 9.36105 12.4831 8.89918C12.4786 8.69369 12.474 8.48612 12.474 8.276L11.2373 8.6506C11.2373 8.77343 11.2366 8.893 11.2358 9.01029C11.2341 9.27401 11.2325 9.5262 11.2398 9.778C11.2482 10.0633 11.109 10.2147 10.8414 10.2324C10.651 10.245 10.4596 10.2423 10.2553 10.2393H10.2553H10.2553H10.2552H10.2552ZM8.70874 10.0289L8.70875 10.0289L8.70875 10.0289C8.71491 10.1021 8.72126 10.1774 8.72968 10.2555H8.73079C8.64254 10.2555 8.56184 10.2569 8.48631 10.2582H8.48626H8.48622H8.48618H8.48614H8.48612C8.33317 10.2608 8.20142 10.2631 8.07115 10.2527C7.74009 10.2263 7.59341 10.0797 7.58981 9.79962C7.58509 9.45719 7.77003 9.18934 8.0437 9.14165C8.32181 9.09341 8.57524 9.2509 8.64649 9.55396C8.68144 9.70475 8.69461 9.86105 8.70874 10.0289ZM9.58645 6.12429L9.62553 6.16131C9.85149 6.37539 10.0913 6.60264 10.3498 6.84797L9.56455 7.57942L8.90297 6.82856L9.58645 6.12429ZM10.4041 6.8556C10.6576 7.09683 10.9032 7.33112 11.1708 7.58649L11.9164 6.83314L11.1708 6.12859L10.4041 6.8556Z" fill="black"/>
                                    </svg>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="mb-5">
    <div class="container">
        <div class="text-2xl font-extrabold mb-4">
            لیست آخرین سمینارها
        </div>

        <div class="list-seminars">
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/seminar1.png">
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        همایش بزرگ توربو
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن بین‌المللی همایش‌های برج میلاد
                    </div>
                </div>
                <a href="#" class="btn-card btn-register d-flex align-items-center justify-content-between py-2 px-3">
                    <div class="d-flex align-items-center">
                        <div class="ml-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#1B1B1B" stroke-width="1.5"/>
                                <path d="M9 12L11 14L15 10" stroke="#1B1B1B" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="font-weight-bold py-1">ثبت‌نام</span>
                    </div>
                    <div class="mr-auto">
                        <div class="off-price text-sm">
                            2,730,000
                        </div>
                        <div class="d-flex align-items-center">
                            <span class="current-price text-xl font-weight-bold ml-1 ">1,250,000</span>
                            <svg width="13" height="14" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.60288 1.63719L2.8437 0.78125L2.07261 1.59144L2.79879 2.39748L3.60288 1.63719ZM0.372938 2.01685L1.49673 2.514C1.45647 2.6587 1.41427 2.80037 1.37257 2.94032C1.28099 3.24769 1.19187 3.54682 1.13128 3.85185C0.979335 4.62655 1.31983 5.1273 2.0973 5.21437C2.567 5.2676 3.05306 5.23239 3.52581 5.18137C3.83081 5.1481 4.06289 4.9407 4.1006 4.60769C4.13471 4.30907 4.14524 4.00656 4.14968 3.70545C4.15514 3.32925 4.15534 2.95294 4.15554 2.57658V2.5762V2.5762V2.57619C4.15565 2.37959 4.15576 2.18297 4.15661 1.98635C4.16132 1.95891 4.16895 1.93205 4.17935 1.90622H5.37329C5.37329 2.19527 5.37911 2.48438 5.38493 2.77317C5.3982 3.43153 5.41143 4.08827 5.35554 4.73912C5.27763 5.64386 4.69009 6.22974 3.79366 6.36089C3.12155 6.45933 2.41256 6.50674 1.74627 6.40498C0.404547 6.20035 -0.315255 5.12952 -0.146673 3.74953C-0.115613 3.49151 -0.0618914 3.23673 0.0138685 2.98814C0.0809864 2.76986 0.164244 2.55625 0.253002 2.32853L0.253007 2.32852C0.292216 2.22792 0.332499 2.12457 0.372938 2.01685ZM0.42905 6.76642L0.429001 6.7664C0.318171 6.72224 0.204233 6.67685 0.0865058 6.62854C0.0865058 7.00028 0.0861867 7.36829 0.0858698 7.73368L0.0858698 7.73375C0.0851217 8.59638 0.0843863 9.44441 0.0878922 10.2924C0.0934376 11.6649 1.3664 12.4352 2.60332 11.8294C2.70785 11.7781 2.87116 11.7919 2.98845 11.8313C3.13364 11.8802 3.27556 11.9401 3.41735 11.9999L3.41738 11.9999C3.6108 12.0815 3.80399 12.163 4.00493 12.2164C4.82539 12.4346 5.54297 12.0875 5.75176 11.3411C5.85383 10.9712 5.8807 10.5847 5.83078 10.2043C5.73041 9.48279 5.37467 8.90717 4.6166 8.70116C3.89181 8.50429 3.26378 8.70476 2.80739 9.29341C2.59954 9.56171 2.46419 9.89439 2.3342 10.2139L2.31634 10.2578C2.14055 10.6903 1.99027 10.8331 1.63231 10.7613C1.31125 10.6974 1.32991 10.4668 1.34738 10.2508C1.35159 10.1988 1.35573 10.1475 1.35503 10.0997C1.34917 9.64433 1.34914 9.18873 1.3491 8.73306C1.34907 8.28288 1.34904 7.83262 1.34339 7.38244C1.34228 7.28207 1.27518 7.13068 1.1956 7.09241C0.95204 6.97477 0.699825 6.87429 0.42905 6.76642ZM4.66221 10.4542C4.67586 10.4957 4.68795 10.5325 4.69951 10.5619C4.68952 11.0474 4.56059 11.1406 4.18904 11.0314L4.17449 11.0271C4.10972 11.008 4.04488 10.9889 3.9822 10.9632C3.45011 10.7541 3.39216 10.3609 3.83829 9.98327C4.04375 9.80831 4.34543 9.82605 4.4921 10.0579C4.57481 10.1884 4.62444 10.3394 4.66221 10.4542ZM10.2552 10.2393C10.1625 10.238 10.0671 10.2366 9.96798 10.2366C9.96798 10.1769 9.96885 10.1175 9.96971 10.0583V10.0583V10.0582V10.0582C9.97157 9.93091 9.97341 9.80456 9.96659 9.67873C9.91973 8.79617 9.28561 8.05225 8.49372 7.94439C7.49581 7.80824 6.76519 8.21833 6.49929 9.12224C6.10307 10.4679 6.74884 11.4244 8.06838 11.471C8.19775 11.4755 8.327 11.4835 8.48073 11.4931L8.48086 11.4931L8.48124 11.4931C8.55733 11.4978 8.63943 11.503 8.73051 11.5082C8.36197 12.1395 7.80301 12.1927 7.2637 12.244C7.12702 12.257 6.99159 12.2699 6.86085 12.292V13.4976C7.64942 13.4682 8.39806 13.3917 9.07183 12.9855C9.6286 12.6494 9.88729 12.1218 9.98018 11.5024C10.089 11.4968 10.1952 11.4918 10.2995 11.4868L10.3002 11.4868H10.3002H10.3002C10.5415 11.4753 10.773 11.4642 11.0042 11.4491C11.7234 11.4017 12.3988 10.8965 12.4604 10.2588C12.5034 9.81244 12.4934 9.36105 12.4831 8.89918C12.4786 8.69369 12.474 8.48612 12.474 8.276L11.2373 8.6506C11.2373 8.77343 11.2366 8.893 11.2358 9.01029C11.2341 9.27401 11.2325 9.5262 11.2398 9.778C11.2482 10.0633 11.109 10.2147 10.8414 10.2324C10.651 10.245 10.4596 10.2423 10.2553 10.2393H10.2553H10.2553H10.2552H10.2552ZM8.70874 10.0289L8.70875 10.0289L8.70875 10.0289C8.71491 10.1021 8.72126 10.1774 8.72968 10.2555H8.73079C8.64254 10.2555 8.56184 10.2569 8.48631 10.2582H8.48626H8.48622H8.48618H8.48614H8.48612C8.33317 10.2608 8.20142 10.2631 8.07115 10.2527C7.74009 10.2263 7.59341 10.0797 7.58981 9.79962C7.58509 9.45719 7.77003 9.18934 8.0437 9.14165C8.32181 9.09341 8.57524 9.2509 8.64649 9.55396C8.68144 9.70475 8.69461 9.86105 8.70874 10.0289ZM9.58645 6.12429L9.62553 6.16131C9.85149 6.37539 10.0913 6.60264 10.3498 6.84797L9.56455 7.57942L8.90297 6.82856L9.58645 6.12429ZM10.4041 6.8556C10.6576 7.09683 10.9032 7.33112 11.1708 7.58649L11.9164 6.83314L11.1708 6.12859L10.4041 6.8556Z" fill="black"/>
                            </svg>
                        </div>
                    </div>
                </a>
            </div>
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/life-field1.png">
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        دورهمی ارتعاش ثروت - کد 7
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن 300 نفره هتل قلب
                    </div>
                </div>
                <a href="#" class="btn-card btn-end d-flex align-items-center justify-content-center py-2 px-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <mask id="mask0_2885_1546" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="2" y="4" width="20" height="16">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.95872 10.2445C2.47427 9.97928 1.99841 9.55221 2.00148 8.99994C2.01359 6.82495 2.11005 5.64706 2.87843 4.87868C3.7571 4 5.17132 4 7.99975 4H15.9998C18.8282 4 20.2424 4 21.1211 4.87868C21.8895 5.64706 21.9859 6.82497 21.998 8.99999C22.0011 9.55225 21.5253 9.9793 21.0409 10.2445C20.4205 10.5841 19.9999 11.2429 19.9999 12C19.9999 12.7571 20.4205 13.4159 21.0409 13.7555C21.5253 14.0207 22.0011 14.4478 21.998 15C21.9859 17.175 21.8895 18.3529 21.1211 19.1213C20.2424 20 18.8282 20 15.9998 20H7.99975C5.17132 20 3.7571 20 2.87843 19.1213C2.11005 18.3529 2.01359 17.175 2.00148 15.0001C1.99841 14.4478 2.47427 14.0207 2.95872 13.7555C3.57907 13.4159 3.99975 12.7571 3.99975 12C3.99975 11.2429 3.57907 10.5841 2.95872 10.2445Z" fill="white"/>
                            </mask>
                            <g mask="url(#mask0_2885_1546)">
                                <path d="M21.1211 19.1213L22.1818 20.182L21.1211 19.1213ZM2.87843 19.1213L1.81776 20.182H1.81777L2.87843 19.1213ZM21.0409 13.7555L21.7612 12.4398L21.0409 13.7555ZM21.998 15L20.4981 14.9917L21.998 15ZM21.998 9L20.4981 9.00835L21.998 9ZM21.0409 10.2445L21.7612 11.5602L21.0409 10.2445ZM2.00148 8.99995L0.501504 8.9916L2.00148 8.99995ZM2.95872 10.2445L2.23845 11.5602L2.95872 10.2445ZM1.81777 3.81803C1.1521 4.48369 0.837828 5.28726 0.681034 6.14084C0.532116 6.95155 0.507492 7.91607 0.501504 8.9916L3.50146 9.0083C3.50758 7.90884 3.53724 7.19692 3.63167 6.68284C3.71823 6.21163 3.83637 6.04206 3.93909 5.93935L1.81777 3.81803ZM7.99975 2.50001C6.62794 2.50001 5.44818 2.49682 4.50806 2.62322C3.52478 2.75542 2.58226 3.05354 1.81777 3.81803L3.93909 5.93935C4.05327 5.82516 4.25719 5.68394 4.9078 5.59647C5.60156 5.5032 6.54313 5.50001 7.99975 5.50001V2.50001ZM15.9998 2.50001H7.99975V5.50001H15.9998V2.50001ZM22.1818 3.81803C21.4173 3.05354 20.4747 2.75542 19.4915 2.62322C18.5513 2.49682 17.3716 2.50001 15.9998 2.50001V5.50001C17.4564 5.50001 18.398 5.5032 19.0917 5.59647C19.7423 5.68394 19.9463 5.82516 20.0604 5.93935L22.1818 3.81803ZM23.498 8.99165C23.492 7.91611 23.4674 6.95158 23.3185 6.14086C23.1617 5.28727 22.8474 4.4837 22.1818 3.81803L20.0604 5.93935C20.1632 6.04207 20.2813 6.21164 20.3679 6.68285C20.4623 7.19694 20.492 7.90887 20.4981 9.00835L23.498 8.99165ZM21.4999 12C21.4999 11.8128 21.6022 11.6472 21.7612 11.5602L20.3206 8.92877C19.2388 9.52096 18.4999 10.6731 18.4999 12H21.4999ZM21.7612 12.4398C21.6022 12.3528 21.4999 12.1872 21.4999 12H18.4999C18.4999 13.3269 19.2388 14.4791 20.3206 15.0712L21.7612 12.4398ZM22.1818 20.182C22.8474 19.5163 23.1617 18.7127 23.3185 17.8591C23.4674 17.0484 23.492 16.0839 23.498 15.0084L20.4981 14.9917C20.492 16.0911 20.4623 16.8031 20.3679 17.3172C20.2813 17.7884 20.1632 17.9579 20.0604 18.0607L22.1818 20.182ZM15.9998 21.5C17.3716 21.5 18.5513 21.5032 19.4915 21.3768C20.4747 21.2446 21.4173 20.9465 22.1818 20.182L20.0604 18.0607C19.9463 18.1748 19.7423 18.3161 19.0917 18.4035C18.398 18.4968 17.4564 18.5 15.9998 18.5V21.5ZM7.99975 21.5H15.9998V18.5H7.99975V21.5ZM1.81777 20.182C2.58226 20.9465 3.52478 21.2446 4.50806 21.3768C5.44818 21.5032 6.62794 21.5 7.99975 21.5V18.5C6.54313 18.5 5.60156 18.4968 4.9078 18.4035C4.25719 18.3161 4.05327 18.1748 3.93909 18.0607L1.81777 20.182ZM0.501504 15.0084C0.507492 16.0839 0.532116 17.0485 0.681034 17.8592C0.837829 18.7128 1.1521 19.5163 1.81776 20.182L3.93909 18.0607C3.83637 17.9579 3.71823 17.7884 3.63167 17.3172C3.53724 16.8031 3.50758 16.0912 3.50146 14.9917L0.501504 15.0084ZM2.49975 12C2.49975 12.1873 2.3974 12.3528 2.23845 12.4398L3.67899 15.0713C4.76075 14.4791 5.49975 13.3269 5.49975 12H2.49975ZM2.23845 11.5602C2.3974 11.6472 2.49975 11.8127 2.49975 12H5.49975C5.49975 10.6731 4.76075 9.5209 3.67899 8.92873L2.23845 11.5602ZM3.50146 14.9917C3.50193 15.0759 3.48304 15.1474 3.46227 15.1963C3.44328 15.241 3.42733 15.2566 3.43606 15.2464C3.44487 15.2362 3.46874 15.2114 3.51408 15.1768C3.55869 15.1428 3.61445 15.1066 3.67899 15.0713L2.23845 12.4398C1.89489 12.6278 1.49174 12.9051 1.1585 13.2938C0.818565 13.6903 0.497402 14.2717 0.501504 15.0084L3.50146 14.9917ZM20.3206 15.0712C20.3851 15.1066 20.4409 15.1428 20.4855 15.1768C20.5308 15.2114 20.5547 15.2361 20.5635 15.2464C20.5722 15.2566 20.5562 15.2409 20.5373 15.1962C20.5165 15.1473 20.4976 15.0759 20.4981 14.9917L23.498 15.0084C23.5021 14.2716 23.181 13.6903 22.8411 13.2938C22.5079 12.9051 22.1047 12.6278 21.7612 12.4398L20.3206 15.0712ZM20.4981 9.00835C20.4976 8.92412 20.5165 8.85268 20.5373 8.80379C20.5562 8.75908 20.5722 8.74343 20.5635 8.75362C20.5547 8.76389 20.5308 8.78864 20.4855 8.82322C20.4409 8.85725 20.3851 8.89344 20.3206 8.92877L21.7612 11.5602C22.1047 11.3722 22.5079 11.0949 22.8411 10.7062C23.181 10.3097 23.5021 9.72838 23.498 8.99165L20.4981 9.00835ZM0.501504 8.9916C0.497402 9.72835 0.818565 10.3097 1.1585 10.7062C1.49173 11.0949 1.89489 11.3722 2.23845 11.5602L3.67899 8.92873C3.61445 8.8934 3.55869 8.8572 3.51408 8.82317C3.46874 8.78859 3.44487 8.76384 3.43606 8.75357C3.42733 8.74337 3.44328 8.75903 3.46227 8.80373C3.48304 8.85263 3.50193 8.92407 3.50146 9.0083L0.501504 8.9916Z" fill="white"/>
                                <path d="M9.75 5.75V8.25" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M9.75 11.75V13.25" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M9.75 16.75V18.25" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            </g>
                        </svg>
                    </div>
                    <span class="font-weight-bold py-1">
                            پایان مهلت ثبت‌نام
                        </span>
                </a>
            </div>
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/seminar1.png">

                    <!-- bell icon -->
                    <div class="bell-icon text-white">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9" />
                            <path d="M13.73 21a2 2 0 0 1-3.46 0" />
                        </svg>
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        سمینار آوانگارد 5
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن 300 نفره هتل قلب
                    </div>
                </div>
                <a href="#" class="btn-card btn-soon d-flex align-items-center justify-content-between py-2 px-3">
                    <div class="d-flex align-items-center">
                        <div class="ml-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M10.3042 18.7642C9.77927 18.7642 9.3801 19.2535 9.6547 19.7008C10.1383 20.4887 11.0078 21.0142 12.0001 21.0142C12.9923 21.0142 13.8618 20.4887 14.3455 19.7008C14.6201 19.2535 14.2209 18.7642 13.696 18.7642C13.3619 18.7642 13.075 18.9842 12.8238 19.2044C12.6039 19.3973 12.3156 19.5142 12.0001 19.5142C11.6845 19.5142 11.3963 19.3973 11.1763 19.2044C10.9252 18.9842 10.6382 18.7642 10.3042 18.7642Z" fill="white"/>
                                <mask id="mask0_2885_1527" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="3" y="1" width="18" height="17">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M19.5 10.8501C19.5 7.86172 18.0167 5.06825 15.5411 3.3944L14.2405 2.51498C12.887 1.59982 11.113 1.59982 9.75949 2.51498L8.45887 3.39439C5.9833 5.06825 4.5 7.86171 4.5 10.8501V12.764C3.88625 13.3133 3.5 14.1116 3.5 15.0001C3.5 16.657 4.84315 18.0001 6.5 18.0001H17.5C19.1569 18.0001 20.5 16.657 20.5 15.0001C20.5 14.1116 20.1137 13.3133 19.5 12.764V10.8501Z" fill="white"/>
                                </mask>
                                <g mask="url(#mask0_2885_1527)">
                                    <path d="M15.5411 3.3944L14.7009 4.63701L15.5411 3.3944ZM19.5 10.8501H21H19.5ZM14.2405 2.51498L15.0807 1.27237L14.2405 2.51498ZM9.75949 2.51498L8.91931 1.27237L9.75949 2.51498ZM8.45887 3.39439L9.29906 4.63701L8.45887 3.39439ZM4.5 10.8501H6H4.5ZM4.5 12.764L5.50037 13.8817L6 13.4345V12.764H4.5ZM19.5 12.764H18V13.4345L18.4996 13.8817L19.5 12.764ZM14.7009 4.63701C16.7639 6.03188 18 8.35977 18 10.8501H21C21 7.36366 19.2695 4.10461 16.3813 2.15178L14.7009 4.63701ZM13.4003 3.75759L14.7009 4.63701L16.3813 2.15178L15.0807 1.27237L13.4003 3.75759ZM10.5997 3.75759C11.4456 3.18562 12.5544 3.18562 13.4003 3.75759L15.0807 1.27237C13.2196 0.0140277 10.7804 0.0140273 8.91931 1.27237L10.5997 3.75759ZM9.29906 4.63701L10.5997 3.75759L8.91931 1.27237L7.61868 2.15178L9.29906 4.63701ZM6 10.8501C6 8.35977 7.23608 6.03188 9.29906 4.63701L7.61868 2.15178C4.73051 4.10461 3 7.36366 3 10.8501H6ZM6 12.764V10.8501H3V12.764H6ZM5 15.0001C5 14.556 5.1911 14.1585 5.50037 13.8817L3.49963 11.6463C2.5814 12.4681 2 13.6672 2 15.0001H5ZM6.5 16.5001C5.67157 16.5001 5 15.8285 5 15.0001H2C2 17.4854 4.01472 19.5001 6.5 19.5001V16.5001ZM17.5 16.5001H6.5V19.5001H17.5V16.5001ZM19 15.0001C19 15.8285 18.3284 16.5001 17.5 16.5001V19.5001C19.9853 19.5001 22 17.4854 22 15.0001H19ZM18.4996 13.8817C18.8089 14.1585 19 14.556 19 15.0001H22C22 13.6672 21.4186 12.4681 20.5004 11.6463L18.4996 13.8817ZM18 10.8501V12.764H21V10.8501H18Z" fill="white"/>
                                </g>
                            </svg>
                        </div>
                        <span class="font-weight-bold py-1">ثبت‌نام</span>
                    </div>
                    <div class="mr-auto">
                        به زودی
                    </div>
                </a>
            </div>
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/seminar1.png">

                    <!--sold out-->
                    <div class="sold-out">
                        <div class="text-sold-out">
                            SoldOut
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        سمینار آوانگارد 5
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن 300 نفره هتل قلب
                    </div>
                </div>
                <a href="#" class="btn-card btn-completion d-flex align-items-center justify-content-center py-2 px-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M14 10L10 14" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M14 14L10 10" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="white" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <span class="font-weight-bold py-1">
                            تکمیل ظرفیت
                        </span>
                </a>
            </div>
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/seminar1.png">

                    <!--sold out-->
                    <div class="sold-out">
                        <div class="text-sold-out">
                            SoldOut
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        سمینار آوانگارد 5
                        (مطالعه خواهید نمود)
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن 300 نفره هتل قلب
                        ( (مطالعه خواهید نمود))
                    </div>
                </div>
                <a href="#" class="btn-card btn-completion d-flex align-items-center justify-content-center py-2 px-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M14 10L10 14" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M14 14L10 10" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="white" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <span class="font-weight-bold py-1">
                            تکمیل ظرفیت
                        </span>
                </a>
            </div>
            <div class="card-seminar p-xl-4 p-3 mb-3">
                <div class="card-image mb-3">
                    <img src="/wp-content/themes/modiram/assets/images/seminar1.png">

                    <!--sold out-->
                    <div class="sold-out">
                        <div class="text-sold-out">
                            SoldOut
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 4.75H6C4.20507 4.75 2.75 6.20507 2.75 8V18C2.75 19.7949 4.20507 21.25 6 21.25H18C19.7949 21.25 21.25 19.7949 21.25 18V8C21.25 6.20507 19.7949 4.75 18 4.75Z" stroke="#CFCFCF" stroke-width="2"/>
                            <path d="M6.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M3.75 9.25H20.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M17.75 2.75V6.25" stroke="#CFCFCF" stroke-width="2" stroke-linecap="round"/>
                            <path d="M8.25 14C8.66421 14 9 13.6642 9 13.25C9 12.8358 8.66421 12.5 8.25 12.5C7.83579 12.5 7.5 12.8358 7.5 13.25C7.5 13.6642 7.83579 14 8.25 14Z" fill="#CFCFCF"/>
                            <path d="M12.25 14C12.6642 14 13 13.6642 13 13.25C13 12.8358 12.6642 12.5 12.25 12.5C11.8358 12.5 11.5 12.8358 11.5 13.25C11.5 13.6642 11.8358 14 12.25 14Z" fill="#CFCFCF"/>
                            <path d="M16.25 14C16.6642 14 17 13.6642 17 13.25C17 12.8358 16.6642 12.5 16.25 12.5C15.8358 12.5 15.5 12.8358 15.5 13.25C15.5 13.6642 15.8358 14 16.25 14Z" fill="#CFCFCF"/>
                            <path d="M8.25 18C8.66421 18 9 17.6642 9 17.25C9 16.8358 8.66421 16.5 8.25 16.5C7.83579 16.5 7.5 16.8358 7.5 17.25C7.5 17.6642 7.83579 18 8.25 18Z" fill="#CFCFCF"/>
                            <path d="M12.25 18C12.6642 18 13 17.6642 13 17.25C13 16.8358 12.6642 16.5 12.25 16.5C11.8358 16.5 11.5 16.8358 11.5 17.25C11.5 17.6642 11.8358 18 12.25 18Z" fill="#CFCFCF"/>
                            <path d="M16.25 18C16.6642 18 17 17.6642 17 17.25C17 16.8358 16.6642 16.5 16.25 16.5C15.8358 16.5 15.5 16.8358 15.5 17.25C15.5 17.6642 15.8358 18 16.25 18Z" fill="#CFCFCF"/>
                        </svg>
                    </div>
                    <div class="card-title font-weight-bold line-clamp-1">
                        سمینار آوانگارد 5
                    </div>
                </div>
                <div class="d-flex align-items-center mb-1">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="#CFCFCF" stroke-width="1.5"/>
                            <path d="M12 7.5V12L15 15" stroke="#CFCFCF" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div>
                        18 شهریور 1403
                    </div>
                </div>
                <div class="d-flex align-items-center mb-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 3C7.58172 3 4 6.58172 4 11V11.3274C4 13.013 4.53207 14.646 5.50638 16H5.5L5.52299 16.023C5.72211 16.2976 5.9395 16.5607 6.1744 16.8103C6.52837 17.1864 12 21.5 12 21.5C12.7985 21.0933 17.174 17.5026 17.8256 16.8103C18.063 16.5581 18.2824 16.2921 18.4833 16.0143L18.5 16H18.4936C19.4679 14.646 20 13.013 20 11.3274V11C20 6.58172 16.4183 3 12 3Z" stroke="#CFCFCF" stroke-width="1.5" stroke-linejoin="round"/>
                            <path d="M15.25 11C15.25 9.20507 13.7949 7.75 12 7.75C10.2051 7.75 8.75 9.20507 8.75 11C8.75 12.7949 10.2051 14.25 12 14.25C13.7949 14.25 15.25 12.7949 15.25 11Z" stroke="#CFCFCF" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="line-clamp-1">
                        سالن 300 نفره هتل قلب
                    </div>
                </div>
                <a href="#" class="btn-card btn-completion d-flex align-items-center justify-content-center py-2 px-3">
                    <div class="ml-1">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M14 10L10 14" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M14 14L10 10" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                            <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z" stroke="white" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <span class="font-weight-bold py-1">
                            تکمیل ظرفیت
                        </span>
                </a>
            </div>
        </div>
    </div>
</section>
