<?php
/**
 * Title: Seasons
 * Slug: modiram/section-seasons
 * Categories: content
 * Post Types: post
 */

global $post, $meta;

if (!$post || !$meta || !isset($meta['seasons'][0]) || empty($meta['seasons'][0])) {
    return;
}

?>

<!-- course-headlines -->
<div class="course-headlines">
    <div class="row">
        <div class="col-lg-2">
            <div class="font-extrabold text-xl text-yellow text-md-right text-center mb-3">
                سرفصل‌ها
            </div>
        </div>
        <div class="col-lg-10">
            <?php
            $season_num = 0;

            foreach (maybe_unserialize($meta['seasons'][0]) as $season) {
                $season_num++ ?>
                <div class="headline d-flex mb-2 <?php echo ($season_num == 1) ? 'open' : ''; ?>">
                    <div class="headline-number d-flex align-items-center justify-content-center text-white bg-yellow ml-2">
                        <?php echo $season_num  ?>
                    </div>
                    <div class="headline-details w-100">
                        <div class="headline-header d-flex align-items-center p-3">
                            <div class="fw-bold me-2">
                                <?php echo $season['title'] ?>
                            </div>
                            <?php if (empty($season['description'])) { ?>
                                <div class="mr-auto">
                                    <svg width="16" height="17" viewBox="0 0 16 17" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_2295)">
                                            <path d="M12.6663 6.116V5.16667C12.6663 3.92899 12.1747 2.742 11.2995 1.86684C10.4243 0.991665 9.23735 0.5 7.99967 0.5C6.762 0.5 5.57501 0.991665 4.69984 1.86684C3.82467 2.742 3.33301 3.92899 3.33301 5.16667V6.116C2.73925 6.37514 2.23387 6.80168 1.87867 7.34347C1.52348 7.88527 1.33386 8.51882 1.33301 9.16667V13.1667C1.33407 14.0504 1.6856 14.8976 2.31049 15.5225C2.93538 16.1474 3.78261 16.4989 4.66634 16.5H11.333C12.2167 16.4989 13.064 16.1474 13.6889 15.5225C14.3138 14.8976 14.6653 14.0504 14.6663 13.1667V9.16667C14.6655 8.51882 14.4759 7.88527 14.1207 7.34347C13.7655 6.80168 13.2601 6.37514 12.6663 6.116ZM4.66634 5.16667C4.66634 4.28261 5.01753 3.43477 5.64265 2.80964C6.26777 2.18452 7.11562 1.83333 7.99967 1.83333C8.88373 1.83333 9.73158 2.18452 10.3567 2.80964C10.9818 3.43477 11.333 4.28261 11.333 5.16667V5.83333H4.66634V5.16667ZM13.333 13.1667C13.333 13.6971 13.1223 14.2058 12.7472 14.5809C12.3721 14.956 11.8634 15.1667 11.333 15.1667H4.66634C4.13591 15.1667 3.6272 14.956 3.25213 14.5809C2.87705 14.2058 2.66634 13.6971 2.66634 13.1667V9.16667C2.66634 8.63623 2.87705 8.12753 3.25213 7.75245C3.6272 7.37738 4.13591 7.16667 4.66634 7.16667H11.333C11.8634 7.16667 12.3721 7.37738 12.7472 7.75245C13.1223 8.12753 13.333 8.63623 13.333 9.16667V13.1667Z"
                                                  fill="#121212"/>
                                            <path d="M7.99968 9.83313C7.82287 9.83313 7.6533 9.90337 7.52827 10.0284C7.40325 10.1534 7.33301 10.323 7.33301 10.4998V11.8331C7.33301 12.0099 7.40325 12.1795 7.52827 12.3045C7.6533 12.4296 7.82287 12.4998 7.99968 12.4998C8.17649 12.4998 8.34606 12.4296 8.47109 12.3045C8.59611 12.1795 8.66635 12.0099 8.66635 11.8331V10.4998C8.66635 10.323 8.59611 10.1534 8.47109 10.0284C8.34606 9.90337 8.17649 9.83313 7.99968 9.83313Z"
                                                  fill="#121212"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2885_2295">
                                                <rect width="16" height="16" fill="white"
                                                      transform="translate(0 0.5)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if (!empty($season['description'])) { ?>
                            <div class="headline-body">
                                <div class="text-justify text-sm py-3 px-md-4 px-3">
                                    <?php echo $season['description'] ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>

