<?php
/**
 * Title: Product landing pay
 * Slug: modiram/section-product-landing-pay
 * Categories: pay
 * Post Types: post, page
 */

global $theme_settings, $product, $meta, $thumbnail, $mdr_pay_message_error;

if (!$product || !$theme_settings['payment']['onePay']['active'] ) {
    return;
}

use Mdr\Services\MdrPay;
$pay = new MdrPay();
?>

<section id="pay_form" class="mb-5">
    <div class="container">
        <div class="course-buy-preview px-lg-5 py-lg-4 py-3 px-3"
             style="background-image: url('<?php echo get_template_directory_uri(); ?>/assets/images/bg-buy-preview.png');">
            <div class="row align-items-center">
                <div class="col-xl-4 col-lg-6 order-0">
                    <div class="course-image mb-xl-3 mb-4">
                        <img src="<?php echo $thumbnail[0] ?? ''; ?>">
                    </div>
                </div>
                <div class="col-xl-4 col-lg-12 order-xl-1 order-2">
                    <div class="px-lg-3">
                        <div class="fw-bold text-lg mb-3 fw-bold">
                            <?php echo $product->get_title(); ?>
                        </div>
                        <div class="d-flex flex-wrap justify-content-between mb-3">
                            <?php if (!empty($product->get_sale_price())) { ?>
                                <div class="off-price ml-auto">
                                    <?php echo number_format($product->get_regular_price() ?? 0) ?>
                                </div>
                            <?php } ?>
                            <div class="current-price d-flex align-items-end">
                                    <span class="font-semibold">
                                        <?php echo number_format($product->get_price() ?? 0) ?>
                                    </span>
                                <span class="text-sm mr-1">
                                        تومان
                                    </span>
                            </div>
                        </div>
                        <form>
                            <div class="input-holder mb-2">
                                <input type="text" name="full_name" class="bg-white p-2 text-center"
                                       placeholder="نام و نام خانوادگی">
                            </div>
                            <div class="input-holder mb-2">
                                <input type="text" name="phone" class="bg-white p-2 text-center" placeholder="شماره تماس">
                            </div>
                            <div class="error-text text-red text-xs response">
                                <?php echo $mdr_pay_message_error ? '<p class="response_error">'. $mdr_pay_message_error. '</p>' : ''?>
                            </div>
                            <input type="hidden" name="product_id" value="<?php echo $product->get_id(); ?>">
                            <button type="button" class="btn-submit block w-100 bg-yellow text-white p-2"
                                    onclick="mdr_product_pay(this)">
                                خرید دوره
                            </button>
                        </form>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6 order-xl-2 order-1">
                    <div class="course-details h-100 d-lg-flex d-none flex-column justify-content-center px-lg-3">
                        <div class="d-flex align-items-center mb-3">
                                <span class="me-3">
                                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_2644)">
                                        <path d="M18.2849 4.69705C18.2507 4.67705 12.2965 1.92873 12.2965 1.92873C10.8667 1.14127 9.13307 1.14127 7.70323 1.92873C7.70323 1.92873 1.74991 4.67705 1.71491 4.69705C0.120651 5.5649 -0.468216 7.56088 0.399636 9.15514C0.702253 9.71107 1.15897 10.1678 1.71491 10.4704C1.74991 10.4904 4.16659 11.6071 4.16659 11.6071V15.5463C4.16893 17.2429 5.27382 18.7411 6.89409 19.2446C7.90323 19.5361 8.9496 19.6784 9.99991 19.6671C11.0503 19.6784 12.0966 19.5361 13.1057 19.2446C14.726 18.7411 15.8309 17.2429 15.8332 15.5463V11.607L17.4999 10.8387V16.7504C17.4999 17.4407 18.0595 18.0004 18.7499 18.0004C19.4402 18.0004 19.9999 17.4407 19.9999 16.7504V7.55119C19.9668 6.3224 19.3796 5.23037 18.2849 4.69705ZM13.3332 15.5462C13.3362 16.1417 12.9522 16.6702 12.3849 16.8512C10.8225 17.2704 9.17725 17.2704 7.61487 16.8512C7.04753 16.6702 6.6635 16.1417 6.66655 15.5462V12.7604L7.70323 13.2387C9.13257 14.0282 10.8672 14.0282 12.2965 13.2387L13.3332 12.7604V15.5462H13.3332ZM17.0707 8.28369C17.0707 8.28369 11.1299 11.0254 11.0965 11.0454C10.4165 11.4321 9.58315 11.4321 8.90319 11.0454C8.86987 11.0254 2.92901 8.28369 2.92901 8.28369C2.54241 8.08646 2.38889 7.61318 2.58612 7.22658C2.66139 7.079 2.78143 6.959 2.92901 6.88369C2.92901 6.88369 8.86983 4.14201 8.90319 4.12201C9.58315 3.73529 10.4165 3.73529 11.0965 4.12201C11.1298 4.14201 17.0707 6.88369 17.0707 6.88369C17.4573 7.08092 17.6108 7.5542 17.4136 7.9408C17.3383 8.08842 17.2183 8.20842 17.0707 8.28369Z"
                                              fill="black"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_2885_2644">
                                        <rect width="20" height="20" fill="white" transform="translate(0 0.5)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </span>
                            <span>رنه سینانی</span>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                                <span class="me-3">
                                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_2647)">
                                        <path d="M15.4167 2.16667H15V1.75C15 1.41848 14.8683 1.10054 14.6339 0.866116C14.3995 0.631696 14.0815 0.5 13.75 0.5V0.5C13.4185 0.5 13.1005 0.631696 12.8661 0.866116C12.6317 1.10054 12.5 1.41848 12.5 1.75V2.16667H7.5V1.75C7.5 1.41848 7.3683 1.10054 7.13388 0.866116C6.89946 0.631696 6.58152 0.5 6.25 0.5V0.5C5.91848 0.5 5.60054 0.631696 5.36612 0.866116C5.1317 1.10054 5 1.41848 5 1.75V2.16667H4.58333C3.36776 2.16667 2.20197 2.64955 1.34243 3.50909C0.482886 4.36864 0 5.53442 0 6.75L0 15.9167C0 17.1322 0.482886 18.298 1.34243 19.1576C2.20197 20.0171 3.36776 20.5 4.58333 20.5H15.4167C16.6322 20.5 17.798 20.0171 18.6576 19.1576C19.5171 18.298 20 17.1322 20 15.9167V6.75C20 5.53442 19.5171 4.36864 18.6576 3.50909C17.798 2.64955 16.6322 2.16667 15.4167 2.16667ZM15.4167 18H4.58333C4.0308 18 3.5009 17.7805 3.11019 17.3898C2.71949 16.9991 2.5 16.4692 2.5 15.9167V8.83333H17.5V15.9167C17.5 16.4692 17.2805 16.9991 16.8898 17.3898C16.4991 17.7805 15.9692 18 15.4167 18Z"
                                              fill="black"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_2885_2647">
                                        <rect width="20" height="20" fill="white" transform="translate(0 0.5)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </span>
                            <span>بدون محدودیت زمانی</span>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                                <span class="me-3">
                                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_2650)">
                                        <path d="M18.75 11.3333H18.3333V5.08333C18.332 3.86816 17.8487 2.70314 16.9894 1.84389C16.1302 0.984634 14.9652 0.501323 13.75 0.5L6.25 0.5C5.03483 0.501323 3.86981 0.984634 3.01056 1.84389C2.1513 2.70314 1.66799 3.86816 1.66667 5.08333V11.3333H1.25C0.918479 11.3333 0.600537 11.465 0.366116 11.6994C0.131696 11.9339 0 12.2518 0 12.5833C0 12.9149 0.131696 13.2328 0.366116 13.4672C0.600537 13.7016 0.918479 13.8333 1.25 13.8333H8.75V16.3333H7.5C6.72645 16.3333 5.98459 16.6406 5.43761 17.1876C4.89062 17.7346 4.58333 18.4765 4.58333 19.25C4.58333 19.5815 4.71503 19.8995 4.94945 20.1339C5.18387 20.3683 5.50181 20.5 5.83333 20.5C6.16485 20.5 6.4828 20.3683 6.71722 20.1339C6.95164 19.8995 7.08333 19.5815 7.08333 19.25C7.08333 19.1395 7.12723 19.0335 7.20537 18.9554C7.28351 18.8772 7.38949 18.8333 7.5 18.8333H12.5C12.6105 18.8333 12.7165 18.8772 12.7946 18.9554C12.8728 19.0335 12.9167 19.1395 12.9167 19.25C12.9167 19.5815 13.0484 19.8995 13.2828 20.1339C13.5172 20.3683 13.8351 20.5 14.1667 20.5C14.4982 20.5 14.8161 20.3683 15.0505 20.1339C15.285 19.8995 15.4167 19.5815 15.4167 19.25C15.4167 18.4765 15.1094 17.7346 14.5624 17.1876C14.0154 16.6406 13.2735 16.3333 12.5 16.3333H11.25V13.8333H18.75C19.0815 13.8333 19.3995 13.7016 19.6339 13.4672C19.8683 13.2328 20 12.9149 20 12.5833C20 12.2518 19.8683 11.9339 19.6339 11.6994C19.3995 11.465 19.0815 11.3333 18.75 11.3333ZM4.16667 5.08333C4.16667 4.5308 4.38616 4.0009 4.77686 3.61019C5.16756 3.21949 5.69747 3 6.25 3H13.75C14.3025 3 14.8324 3.21949 15.2231 3.61019C15.6138 4.0009 15.8333 4.5308 15.8333 5.08333V11.3333H4.16667V5.08333Z"
                                              fill="black"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_2885_2650">
                                        <rect width="20" height="20" fill="white" transform="translate(0 0.5)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </span>
                            <span>
                                    ویدئو ضبط شده با کیفیت بالا
                                </span>
                        </div>
                        <div class="d-flex align-items-center mb-3">
                                <span class="me-3">
                                    <svg width="20" height="21" viewBox="0 0 20 21" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2885_2653)">
                                        <path d="M1.24973 20.507C1.41403 20.5074 1.57676 20.4751 1.72852 20.4122C1.88028 20.3493 2.01806 20.2569 2.1339 20.1404L7.09223 15.1787L7.6989 15.8062C8.50495 16.6524 9.61395 17.1439 10.7822 17.1729C11.1844 17.1736 11.5838 17.1057 11.9631 16.972C12.5523 16.7642 13.0698 16.3922 13.4545 15.8999C13.8393 15.4077 14.0753 14.8157 14.1347 14.1937C14.2216 13.373 14.1615 12.5433 13.9572 11.7437L13.9222 11.577L16.7456 8.75453L17.1222 9.13203C17.3994 9.42322 17.7704 9.60728 18.17 9.65179C18.5695 9.6963 18.9719 9.59841 19.3064 9.37537C19.5023 9.23542 19.6654 9.05455 19.7844 8.84529C19.9034 8.63603 19.9755 8.40339 19.9956 8.1635C20.0158 7.92361 19.9835 7.68221 19.901 7.45604C19.8186 7.22987 19.6879 7.02434 19.5181 6.8537L13.7122 1.03453C13.4351 0.743343 13.064 0.559286 12.6645 0.514775C12.265 0.470263 11.8625 0.56815 11.5281 0.791199C11.3322 0.93114 11.1691 1.11201 11.0501 1.32127C10.9311 1.53053 10.859 1.76317 10.8389 2.00306C10.8187 2.24296 10.851 2.48436 10.9335 2.71053C11.0159 2.9367 11.1466 3.14223 11.3164 3.31287L11.7497 3.75037L8.93307 6.56787C8.11556 6.35364 7.26596 6.28955 6.42557 6.3787C5.77696 6.4454 5.16098 6.69631 4.65036 7.10179C4.13974 7.50727 3.75581 8.0504 3.5439 8.66703C3.31532 9.29526 3.27051 9.97562 3.4147 10.6284C3.5589 11.2812 3.88613 11.8794 4.35807 12.3529L5.35807 13.3829L0.365567 18.3737C0.190923 18.5486 0.0720323 18.7713 0.0239183 19.0137C-0.0241957 19.2561 0.000626793 19.5073 0.095249 19.7356C0.189871 19.9639 0.350046 20.1591 0.555533 20.2964C0.76102 20.4337 1.0026 20.507 1.24973 20.507ZM5.90057 9.50037C5.956 9.32995 6.05966 9.17927 6.19899 9.06656C6.33832 8.95386 6.50733 8.88397 6.68557 8.86537C7.23171 8.8082 7.7837 8.85055 8.31473 8.99037L9.00557 9.1662C9.21567 9.21972 9.43608 9.21767 9.64516 9.16025C9.85423 9.10283 10.0448 8.99202 10.1981 8.8387L13.5164 5.5187L14.9781 6.98537L11.6747 10.2895C11.5278 10.4365 11.4199 10.6178 11.3607 10.817C11.3014 11.0162 11.2928 11.227 11.3356 11.4304L11.5231 12.3162C11.6613 12.8438 11.703 13.3921 11.6464 13.9345C11.6385 14.0873 11.5845 14.2342 11.4916 14.3557C11.3986 14.4772 11.271 14.5678 11.1256 14.6154C10.8263 14.6857 10.5134 14.6703 10.2225 14.5708C9.93169 14.4713 9.67482 14.2918 9.4814 14.0529L6.1414 10.5987C6.00057 10.4577 5.90304 10.2794 5.86036 10.0848C5.81769 9.89011 5.83164 9.68733 5.90057 9.50037Z"
                                              fill="black"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_2885_2653">
                                        <rect width="20" height="20" fill="white" transform="translate(0 0.5)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </span>
                            <span>
                                    6 ماه پشتیبانی + بازگشت وجه
                                </span>
                        </div>
                        <div class="d-flex align-items-center">
                                <span class="me-3">
                                    <svg width="20" height="17" viewBox="0 0 20 17" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M19.1985 5.90336C17.1748 2.78105 13.7198 0.882075 9.99914 0.847168C6.27854 0.882075 2.82353 2.78105 0.799846 5.90336C-0.266615 7.46846 -0.266615 9.52677 0.799846 11.0919C2.82239 14.2161 6.27759 16.1171 9.99918 16.1531C13.7198 16.1182 17.1748 14.2192 19.1985 11.0969C20.2672 9.53066 20.2672 7.4696 19.1985 5.90336ZM17.1277 9.67288C15.5827 12.1235 12.8961 13.6186 9.99914 13.6401C7.10222 13.6187 4.41561 12.1235 2.87053 9.67288C2.38886 8.96523 2.38886 8.03502 2.87053 7.32741C4.41557 4.87679 7.10218 3.38166 9.99914 3.36018C12.8961 3.38162 15.5827 4.87679 17.1277 7.32741C17.6094 8.03502 17.6094 8.96523 17.1277 9.67288Z"
                                              fill="black"/>
                                        <path d="M9.99911 11.8506C11.8496 11.8506 13.3498 10.3505 13.3498 8.49997C13.3498 6.64944 11.8496 5.14929 9.99911 5.14929C8.14859 5.14929 6.64844 6.64944 6.64844 8.49997C6.64844 10.3505 8.14859 11.8506 9.99911 11.8506Z"
                                              fill="black"/>
                                    </svg>
                                </span>
                            <span>
                                    5,321 نفر شرکت‌کننده
                                </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
