<?php
/**
 * Title: post comments
 * Slug: modiram/section-post-comments
 * Categories: post
 * Post Types: post
 */

global $post;

if (!$post ) {
    return;
}

$comments = get_comments([
    'post_id' => $post->ID,
    'status' => 'approve',
    'order' => 'DESC',
    'parent' => 0,
]);

?>

<!--comment form-->
<section class="mb-5">
    <div class="container">
        <div class="comment-form pt-5" id="comment_form">
            <form>
                <div class="d-flex align-items-center mb-4">
                    <div class="me-2">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M22.0009 11.3727C21.8804 9.42268 21.1919 7.55059 20.0203 5.98719C18.8486 4.42378 17.2451 3.23741 15.4074 2.57433C13.5696 1.91125 11.578 1.80044 9.67807 2.25558C7.77812 2.71071 6.05289 3.71189 4.71507 5.13568C3.37724 6.55947 2.48531 8.34363 2.14923 10.2682C1.81314 12.1928 2.0476 14.1737 2.8237 15.9666C3.5998 17.7595 4.88361 19.2862 6.51686 20.3583C8.15011 21.4304 10.0614 22.0012 12.0151 22.0002H17.8343C18.939 21.9991 19.9982 21.5597 20.7793 20.7786C21.5605 19.9974 21.9998 18.9382 22.0009 17.8335V11.3727ZM20.3343 17.8335C20.3343 18.4965 20.0709 19.1324 19.602 19.6013C19.1332 20.0701 18.4973 20.3335 17.8343 20.3335H12.0151C10.8392 20.333 9.67664 20.0846 8.60319 19.6046C7.52973 19.1246 6.5695 18.4237 5.78511 17.5477C4.99692 16.6721 4.40505 15.6381 4.04919 14.515C3.69332 13.3919 3.58169 12.2057 3.72177 11.036C3.94297 9.19095 4.77193 7.47199 6.07797 6.1501C7.38402 4.82821 9.09286 3.97859 10.9351 3.73516C11.2945 3.69012 11.6563 3.6673 12.0184 3.66683C13.9605 3.66153 15.8424 4.34008 17.3343 5.5835C18.2055 6.30762 18.9207 7.20112 19.4364 8.20986C19.9521 9.21859 20.2575 10.3215 20.3343 11.4518V17.8335Z"
                                  fill="#313131" stroke="#313131" stroke-width="0.4"/>
                            <path d="M8.66536 9.49985H11.9987C12.2197 9.49985 12.4317 9.41206 12.588 9.25578C12.7442 9.0995 12.832 8.88754 12.832 8.66652C12.832 8.44551 12.7442 8.23355 12.588 8.07727C12.4317 7.92099 12.2197 7.83319 11.9987 7.83319H8.66536C8.44435 7.83319 8.23239 7.92099 8.07611 8.07727C7.91983 8.23355 7.83203 8.44551 7.83203 8.66652C7.83203 8.88754 7.91983 9.0995 8.07611 9.25578C8.23239 9.41206 8.44435 9.49985 8.66536 9.49985Z"
                                  fill="#313131" stroke="#313131" stroke-width="0.4"/>
                            <path d="M15.332 11.1668H8.66536C8.44435 11.1668 8.23239 11.2546 8.07611 11.4109C7.91983 11.5672 7.83203 11.7791 7.83203 12.0001C7.83203 12.2212 7.91983 12.4331 8.07611 12.5894C8.23239 12.7457 8.44435 12.8335 8.66536 12.8335H15.332C15.553 12.8335 15.765 12.7457 15.9213 12.5894C16.0776 12.4331 16.1654 12.2212 16.1654 12.0001C16.1654 11.7791 16.0776 11.5672 15.9213 11.4109C15.765 11.2546 15.553 11.1668 15.332 11.1668Z"
                                  fill="#313131" stroke="#313131" stroke-width="0.4"/>
                            <path d="M15.332 14.5H8.66536C8.44435 14.5 8.23239 14.5878 8.07611 14.7441C7.91983 14.9004 7.83203 15.1123 7.83203 15.3333C7.83203 15.5544 7.91983 15.7663 8.07611 15.9226C8.23239 16.0789 8.44435 16.1667 8.66536 16.1667H15.332C15.553 16.1667 15.765 16.0789 15.9213 15.9226C16.0776 15.7663 16.1654 15.5544 16.1654 15.3333C16.1654 15.1123 16.0776 14.9004 15.9213 14.7441C15.765 14.5878 15.553 14.5 15.332 14.5Z"
                                  fill="#313131" stroke="#313131" stroke-width="0.4"/>
                        </svg>
                    </div>
                    <div class="font-weight-bold comment_title">
                        ثبت دیدگاه
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="holder-input text-sm mb-3">
                            <textarea class="empty_loud" rows="5" name="comment_content"
                                      placeholder="دیدگاه خود را بنویسید..."></textarea>
                            <div class="error-text text-red text-sm"></div>
                        </div>
                    </div>
                    <div class="col-sm-9">
                        <div class="holder-input text-sm mb-3">
                            <input type="text" class="empty_loud" name="comment_author" rows="5"
                                   placeholder="نام و نام خانوادگی">
                            <div class="error-text text-red text-sm response">

                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3 pr-sm-0">
                        <input type="hidden" id="post_id" name="post_id" value="<?php echo $post->ID ?>">
                        <input type="hidden" class="comment_parent" name="comment_parent" value="">
                        <input type="hidden" id="_wpnonce" name="_wpnonce"
                               value="<?php echo wp_create_nonce('wp_rest') ?>">
                        <button type="button" class="btn-submit button-primary d-block w-100 text-white"
                                onclick="send_comment(this)">
                            ارسال دیدگاه
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<section class="single-page-comments mb-5">
    <div class="container">
        <?php foreach ($comments as $comment) { ?>
            <div class="comment-holder mb-4">
                <div class="comment pt-sm-4 pt-3 px-sm-5 px-3">
                    <div class="d-flex flex-wrap align-items-center justify-content-between">
                        <div class="user-info d-flex align-items-center ml-2 mb-3">
                            <div class="user-image me-2">
                                <img src="<?php echo get_avatar_url($comment->user_id) ?? '/wp-content/themes/modiram/assets/images/expert2.jpg' ?>">
                            </div>
                            <div class="text-sm">
                                <div class="font-weight-bold line-clamp-1">
                                    <?php echo $comment->comment_author; ?>
                                </div>
                                <div class="text-gray-text line-clamp-1">
                                    <?php echo verta($comment->comment_date)->format('Y/n/j'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="btn-replay d-flex text-yellow mr-auto mb-3"
                             onclick="reply_comment(this, <?php echo $comment->comment_ID; ?>)">
                            <span class="text-sm font-weight-bold ml-2">پاسخ دادن</span>
                            <div>
                                <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.543 8.0791H2.54297" stroke="#FFAC00" stroke-width="2"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                    <path d="M7.04297 3.5791L2.54297 8.0791L7.04297 12.5791" stroke="#FFAC00"
                                          stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="comment-text pb-4">
                        <p><?php echo $comment->comment_content; ?></p>
                    </div>
                </div>

                <?php
                $comment_children = $comment->get_children();
                if (!empty($comment_children)) { ?>
                    <div class="replays-holder">
                        <div class="replays mx-sm-5 mr-3 px-sm-4 px-3">
                            <?php foreach ($comment->get_children([
                                'status' => 'approve',
                                'order' => 'DESC',
                            ]) as $comment_child) {
                                if ($comment_child->comment_approved != 1) continue; ?>
                                <div class="replay py-sm-4 py-3">
                                    <div class="d-flex">
                                        <div class="ml-3">
                                            <svg width="17" height="20" viewBox="0 0 17 20" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.7754 11.875L14.8414 8.125L11.7754 4.375" stroke="#444444"
                                                      stroke-width="1.5" stroke-linecap="round"
                                                      stroke-linejoin="round"/>
                                                <path d="M2.57812 15.625C2.57813 13.6359 3.22419 11.7282 4.37418 10.3217C5.52417 8.91518 7.0839 8.125 8.71024 8.125H14.8424"
                                                      stroke="#444444" stroke-width="1.5" stroke-linecap="round"
                                                      stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                        <div>
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="user-info d-flex align-items-center ml-2">
                                                    <div class="user-image me-2">
                                                        <img src="<?php echo get_avatar_url($comment->user_id) ?? '/wp-content/themes/modiram/assets/images/expert2.jpg' ?>">
                                                    </div>
                                                    <div class="text-sm">
                                                        <div class="font-weight-bold line-clamp-1">
                                                            <?php echo $comment_child->comment_author; ?>
                                                        </div>
                                                        <div class="text-gray-text line-clamp-1">
                                                            <?php echo verta($comment_child->comment_date)->format('Y/n/j'); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="comment-text">
                                                <p><?php echo $comment_child->comment_content; ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </div>
</section>

