<?php
/**
 * Title: Pagination
 * Slug: modiram/section-pagination
 * Categories: content
 */

global $pagination;

if (!$pagination) {
    return;
}

?>
<!--mdr_pagination-->
<div id="pagination" class="row" style="justify-self: center;">
    <?php if ($pagination['max_num_pages'] > 1) { ?>
        <nav id="pagination_nav" aria-label="Page navigation example">
            <ul id="pagination_ul" class="pagination">
                <li class="page-item disabled">
                    <a class="page-link" href="#" aria-label="Previous"
                       onclick="mdr_get_list_items('<?php echo $pagination['post_type'] ?>', '<?php echo $pagination['taxonomy'] ?>', '<?php echo $pagination['term_slug'] ?>', 1 )">
                        <span aria-hidden="true">&laquo;</span>
                    </a>
                </li>
                <?php for ($i = 1; $i <= $pagination['max_num_pages']; $i++) { ?>
                    <li class="page-item <?php echo ($i == 1) ? 'active' : '' ?>">
                        <a class="page-link" href="#"
                           onclick="mdr_get_list_items('<?php echo $pagination['post_type'] ?>', '<?php echo $pagination['taxonomy'] ?>', '<?php echo $pagination['term_slug'] ?>', '<?php echo $i ?>' )">
                            <?php echo $i ?>
                        </a>
                    </li>
                <?php } ?>
                <li class="page-item">
                    <a class="page-link" href="#" aria-label="Next"
                       onclick="mdr_get_list_items('<?php echo $pagination['post_type'] ?>', '<?php echo $pagination['taxonomy'] ?>', '<?php echo $pagination['term_slug'] ?>', 2 )">
                        <span aria-hidden="true">&raquo;</span>
                    </a>
                </li>
            </ul>
        </nav>
    <?php } ?>
</div>
<nav id="mdr_pagination_clone" aria-label="mdr_pagination_nav Page navigation example" style="display: none">
    <ul class="mdr_pagination_ul pagination">
        <!--prev button-->
        <li class="mdr_pagination_prev page-item">
            <a class="mdr_pagination_link page-link" href="#" aria-label="Previous">
                <span aria-hidden="true">&laquo;</span>
            </a>
        </li>
        <!--items-->
        <li class="mdr_pagination_li page-item">
            <a class="mdr_pagination_link page-link" href="#">
            </a>
        </li>
        <!--next button-->
        <li class="mdr_pagination_next page-item">
            <a class="mdr_pagination_link page-link" href="#" aria-label="Next">
                <span aria-hidden="true">&raquo;</span>
            </a>
        </li>
    </ul>
</nav>

