<?php
/**
 * Title: last comments
 * Slug: modiram/section-last-comments
 * Categories: content
 * Post Types: post, page
 */

$posts = new WP_Query([
    'post_type' => 'viewpoint',
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'posts_per_page' => 3,
    'offset' => 0,
//    'tax_query' => array(
//        array(
//            'taxonomy' => 'podcast_category',
//            'field' => 'slug',
//            'terms' => '', //category slug
//        ),
//    ),
]);

if (empty($posts) || !$posts->have_posts()) {
    return;
}

?>

<section class="py-5"
         style="background-image: url('/wp-content/themes/modiram/assets/images/bg-comments.png')">
    <div class="container position-relative pt-4">
        <div class="comments-slider">
            <div class="d-sm-flex d-block flex-wrap justify-content-between align-items-center text-center px-3 mb-4">
                <div class="section-title d-inline-flex mb-sm-0 mb-3">
                    <div class="title-icon">
                        <svg width="16" height="19" viewBox="0 0 16 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="4" cy="4" r="4" transform="matrix(-1 0 0 1 12.1259 1)" fill="white"
                                    stroke="white" stroke-width="1.5"/>
                            <path d="M1.12592 14.9347C1.12592 14.0743 1.66677 13.3068 2.47701 13.0175C6.12996 11.7128 10.1219 11.7128 13.7748 13.0175C14.5851 13.3068 15.1259 14.0743 15.1259 14.9347V16.2502C15.1259 17.4376 14.0742 18.3498 12.8987 18.1818L11.9443 18.0455C9.41156 17.6837 6.84027 17.6837 4.30754 18.0455L3.35312 18.1818C2.17762 18.3498 1.12592 17.4376 1.12592 16.2502V14.9347Z"
                                  fill="white" stroke="white" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <h3 class="title-text">
                        نظر دانش‌پذیران
                    </h3>
                </div>
                <div>
                    <a href="#" class="link-view-all">
                        مشاهده همه
                    </a>
                </div>
            </div>
            <div class="swiper mb-sm-4 mb-3">
                <div class="swiper-wrapper">
                    <?php foreach ($posts as $post) {
                        $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
                        ?>
                        <div class="swiper-slide">
                            <div class="h-100 comment-card d-flex flex-column">
                                <div class="text-justify mb-5">
                                    <?php echo $post->post_content; ?>
                                </div>
                                <div class="user-details text-sm mt-auto">
                                    <div>
                                        <div class="font-weight-bold line-clamp-1">
                                            <?php echo $post->post_title ?? '' ?>
                                        </div>
                                        <div class="line-clamp-1">
                                            <?php echo $post->post_excerpt ?? '' ; ?>
                                        </div>
                                    </div>
                                    <div class="user-image">
                                        <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
