<?php
/**
 * Title: last videos
 * Slug: modiram/section-last-videos
 * Categories: content
 * Post Types: post, page
 */

$posts = new WP_Query([
    'post_type' => 'video',
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'posts_per_page' => 1,
    'offset' => 0,
//    'tax_query' => array(
//        array(
//            'taxonomy' => 'podcast_category',
//            'field' => 'slug',
//            'terms' => '', //category slug
//        ),
//    ),
]);

if (empty($posts) || !$posts->have_posts()) {
    return;
}

$post = $posts->posts[0];

if (!$post || empty($post)) {
    return;
}

$videos_link = get_post_meta($post->ID, 'videos', true);
if (empty($videos_link)) return;

?>

<section class="new-videos mb-5 pt-md-5 pt-3">
    <div class="container">
        <div class="d-sm-flex d-block flex-wrap justify-content-between align-items-center text-center mb-md-5 mb-4">
            <div class="section-title d-inline-flex mb-sm-0 mb-3">
                <div class="title-icon rounded-start-2">
                    <svg width="22" height="15" viewBox="0 0 22 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="1" y="1" width="14" height="13" rx="3.5" fill="white" stroke="white"
                              stroke-width="1.5"/>
                        <path d="M15 6.16062L19.1162 3.3063C19.912 2.75446 21 3.324 21 4.29241V10.7255C21 11.6903 19.919 12.2607 19.1226 11.716L15 8.89637V6.16062Z"
                              fill="white" stroke="white" stroke-width="1.5"/>
                    </svg>
                </div>
                <h3 class="title-text rounded-end-2">
                    تازه‌ترین ویدیوها
                </h3>
            </div>
            <div>
                <a href="<?php echo get_site_url(). '/video'?>" class="link-view-all">
                    مشاهده همه
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 col-12 order-lg-1 order-2">
                <div class="h-100 d-flex flex-column">
                    <div class="h-100 d-flex flex-column justify-content-center pb-3">
                        <div class="text-xl font-extrabold mb-4">
                            <?php echo $post->post_title ?? '' ?>
                        </div>
                        <div class="text-gray-text">
                            <?php echo $post->post_excerpt ?? '' ?>
                        </div>
                    </div>
                    <div class="small-videos">
                        <?php foreach ($videos_link as $key => $video) { ?>
                            <div class="small-video <?php echo ($key == array_key_first($videos_link)) ? 'active' : '' ?>">
                                <video poster="<?php echo $video['poster'] ?? '' ?>">
                                    <source src="<?php echo $video['video'] ?? '' ?>"
                                            type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                                <div class="icon-play">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="12"
                                         viewBox="0 0 24 24">
                                        <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                                    </svg>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-12 order-lg-2 order-1">
                <div class="large-video holder-video mb-3">
                    <video poster="<?php echo $videos_link[array_key_first($videos_link) ?? 1]['poster'] ?? get_theme_file_uri('assets/images/card.png') ?>">
                        <source src="<?php echo $videos_link[array_key_first($videos_link) ?? 1]['video'] ?? '' ?>"
                                type="video/mp4">
                        Your browser does not support the video tag.
                    </video>

                    <div class="holder-play-video d-flex justify-content-center align-items-center">
                        <button class="btn-play-video">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="white" height="45" viewBox="0 0 24 24">
                                <path d="M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z"/>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
