<?php
/**
 * Title: last podcasts
 * Slug: modiram/section-last-podcasts
 * Categories: content
 * Post Types: post, page
 */

$posts = new WP_Query([
    'post_type' => 'podcast',
    'post_status' => 'publish',
    'orderby' => 'date',
    'order' => 'DESC',
    'posts_per_page' => 3,
    'offset' => 0,
//    'tax_query' => array(
//        array(
//            'taxonomy' => 'podcast_category',
//            'field' => 'slug',
//            'terms' => '', //category slug
//        ),
//    ),
]);

if (empty($posts) || !$posts->have_posts()) {
    return;
}

?>

<section class="mb-5 pt-md-5 pt-3">
    <div class="container">
        <div class="d-sm-flex d-block flex-wrap justify-content-between align-items-center text-center mb-md-5 mb-4">
            <div class="section-title d-inline-flex mb-sm-0 mb-3">
                <div class="title-icon">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect x="8" y="2" width="8" height="13" rx="4" fill="white" stroke="white" stroke-width="1.5"/>
                        <path d="M20 11.5C20 15.9183 16.4183 19.5 12 19.5C7.58172 19.5 4 15.9183 4 11.5" stroke="white"
                              stroke-width="1.5" stroke-linecap="round"/>
                        <path d="M12 22V20" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                    </svg>
                </div>
                <h3 class="title-text">
                    آخرین پادکست‌ها
                </h3>
            </div>
            <div>
                <a href="<?php echo get_site_url(). '/podcast'?>" class="link-view-all">
                    مشاهده همه
                </a>
            </div>
        </div>

        <div class="row">
            <?php foreach ($posts->posts as $post) {
                $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
                ?>
                <div class="col-md-4">
                    <a href="<?php echo get_permalink($post) ?>" class="card-podcast card-red mb-4">
                        <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                        <div class="podcast-description d-flex align-items-center justify-content-between py-2 px-3">
                            <div class="podcast-title line-clamp-1 text-white font-weight-bold ml-1">
                                <?php echo $post->post_title ?>
                            </div>
                            <div>
                                <svg width="34" height="34" viewBox="0 0 34 34" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="17" cy="17" r="17" fill="white"/>
                                    <mask id="mask0_2885_1202" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0"
                                          y="0" width="34" height="34">
                                        <circle cx="17" cy="17" r="17" fill="#DF331F"/>
                                    </mask>
                                    <g mask="url(#mask0_2885_1202)">
                                    </g>
                                    <path d="M23.8402 15.6711C24.8631 16.2617 24.8631 17.7381 23.8402 18.3287L14.7307 23.588C13.7078 24.1786 12.4291 23.4404 12.4291 22.2592L12.4291 11.7405C12.4291 10.5594 13.7078 9.82113 14.7307 10.4117L23.8402 15.6711Z"
                                          fill="currentColor"/>
                                </svg>
                            </div>
                        </div>
                    </a>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
