<?php
/**
 * Title: section last article
 * Slug: modiram/section-last-article
 * Categories: content
 * Post Types: post, page
 */

$posts = get_posts([
    'posts_per_page' => 3,
    'orderby' => 'date',
    'order' => 'DESC',
    'post_type' => 'post',
    'post_status' => 'publish',
]);

if (empty($posts)) {
    return;
}

?>

<section class="new-articles py-5">
    <div class="container">
        <div class="d-sm-flex d-block flex-wrap justify-content-between align-items-center text-center px-3 mb-4">
            <div class="section-title d-inline-flex mb-sm-0 mb-3">
                <div class="title-icon">
                    <svg width="18" height="22" viewBox="0 0 18 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                              d="M0.25 5C0.25 2.37665 2.37665 0.25 5 0.25H13C15.6234 0.25 17.75 2.37665 17.75 5V17C17.75 19.6234 15.6234 21.75 13 21.75H5C2.37665 21.75 0.25 19.6234 0.25 17V5ZM5 5.25C4.58579 5.25 4.25 5.58579 4.25 6C4.25 6.41421 4.58579 6.75 5 6.75H13C13.4142 6.75 13.75 6.41421 13.75 6C13.75 5.58579 13.4142 5.25 13 5.25H5ZM4.25 11C4.25 10.5858 4.58579 10.25 5 10.25H13C13.4142 10.25 13.75 10.5858 13.75 11C13.75 11.4142 13.4142 11.75 13 11.75H5C4.58579 11.75 4.25 11.4142 4.25 11ZM5 15.25C4.58579 15.25 4.25 15.5858 4.25 16C4.25 16.4142 4.58579 16.75 5 16.75H9C9.41421 16.75 9.75 16.4142 9.75 16C9.75 15.5858 9.41421 15.25 9 15.25H5Z"
                              fill="white"/>
                    </svg>
                </div>
                <h3 class="title-text">
                    جدیدترین مقالات
                </h3>
            </div>
            <div>
                <a href="<?php echo get_site_url() ?>/article" class="link-view-all">
                    مشاهده همه
                </a>
            </div>
        </div>
        <div class="swiper">
            <div class="swiper-wrapper">
                <?php foreach ($posts as $post) {
                    $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail'); ?>
                    <div class="swiper-slide">
                        <div href="#" class="card-article">
                            <div class="card-image">
                                <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png'); ?>">
                            </div>
                            <h4 class="card-title line-clamp-1 font-weight-bold mb-1">
                                <?php echo $post->post_title ?>
                            </h4>
                            <div class="d-flex text-sm mb-3">
                                <div class="d-inline-flex text-yellow">
                                    <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.06467 4.52012C6.69512 4.52012 5.58488 5.63036 5.58488 6.99991C5.58488 8.36945 6.69512 9.47969 8.06467 9.47969C9.43421 9.47969 10.5445 8.36945 10.5445 6.99991C10.5445 5.63036 9.43421 4.52012 8.06467 4.52012ZM6.5768 6.99991C6.5768 6.17818 7.24294 5.51204 8.06467 5.51204C8.8864 5.51204 9.55254 6.17818 9.55254 6.99991C9.55254 7.82164 8.8864 8.48778 8.06467 8.48778C7.24294 8.48778 6.5768 7.82164 6.5768 6.99991Z"
                                              fill="#FFAC00"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.06467 1.21375C6.6489 1.21375 5.36881 1.91403 4.3296 2.76491C3.28472 3.62043 2.43034 4.67132 1.85622 5.47105L1.80887 5.53689C1.46325 6.01714 1.17874 6.41247 1.17874 6.99991C1.17874 7.58735 1.46325 7.98267 1.80887 8.46292L1.85622 8.52877C2.43034 9.32849 3.28472 10.3794 4.3296 11.2349C5.36881 12.0858 6.6489 12.7861 8.06467 12.7861C9.48043 12.7861 10.7605 12.0858 11.7997 11.2349C12.8446 10.3794 13.699 9.32849 14.2731 8.52877L14.3205 8.46293C14.6661 7.98267 14.9506 7.58735 14.9506 6.99991C14.9506 6.41247 14.6661 6.01714 14.3205 5.5369L14.2731 5.47105C13.699 4.67132 12.8446 3.62043 11.7997 2.76491C10.7605 1.91403 9.48043 1.21375 8.06467 1.21375ZM2.66199 6.04951C3.21037 5.28565 4.00673 4.31125 4.95799 3.53238C5.91492 2.74887 6.97636 2.20566 8.06467 2.20566C9.15298 2.20566 10.2144 2.74887 11.1713 3.53238C12.1226 4.31125 12.919 5.28565 13.4673 6.04951C13.88 6.62426 13.9587 6.76282 13.9587 6.99991C13.9587 7.23699 13.88 7.37555 13.4673 7.9503C12.919 8.71416 12.1226 9.68856 11.1713 10.4674C10.2144 11.2509 9.15298 11.7942 8.06467 11.7942C6.97636 11.7942 5.91492 11.2509 4.95799 10.4674C4.00673 9.68856 3.21037 8.71416 2.66199 7.9503C2.24938 7.37555 2.17066 7.23699 2.17066 6.99991C2.17066 6.76282 2.24938 6.62426 2.66199 6.04951Z"
                                              fill="#FFAC00"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.06467 4.52012C6.69512 4.52012 5.58488 5.63036 5.58488 6.99991C5.58488 8.36945 6.69512 9.47969 8.06467 9.47969C9.43421 9.47969 10.5445 8.36945 10.5445 6.99991C10.5445 5.63036 9.43421 4.52012 8.06467 4.52012ZM6.5768 6.99991C6.5768 6.17818 7.24294 5.51204 8.06467 5.51204C8.8864 5.51204 9.55254 6.17818 9.55254 6.99991C9.55254 7.82164 8.8864 8.48778 8.06467 8.48778C7.24294 8.48778 6.5768 7.82164 6.5768 6.99991Z"
                                              stroke="#FFAC00" stroke-width="0.69434"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                              d="M8.06467 1.21375C6.6489 1.21375 5.36881 1.91403 4.3296 2.76491C3.28472 3.62043 2.43034 4.67132 1.85622 5.47105L1.80887 5.53689C1.46325 6.01714 1.17874 6.41247 1.17874 6.99991C1.17874 7.58735 1.46325 7.98267 1.80887 8.46292L1.85622 8.52877C2.43034 9.32849 3.28472 10.3794 4.3296 11.2349C5.36881 12.0858 6.6489 12.7861 8.06467 12.7861C9.48043 12.7861 10.7605 12.0858 11.7997 11.2349C12.8446 10.3794 13.699 9.32849 14.2731 8.52877L14.3205 8.46293C14.6661 7.98267 14.9506 7.58735 14.9506 6.99991C14.9506 6.41247 14.6661 6.01714 14.3205 5.5369L14.2731 5.47105C13.699 4.67132 12.8446 3.62043 11.7997 2.76491C10.7605 1.91403 9.48043 1.21375 8.06467 1.21375ZM2.66199 6.04951C3.21037 5.28565 4.00673 4.31125 4.95799 3.53238C5.91492 2.74887 6.97636 2.20566 8.06467 2.20566C9.15298 2.20566 10.2144 2.74887 11.1713 3.53238C12.1226 4.31125 12.919 5.28565 13.4673 6.04951C13.88 6.62426 13.9587 6.76282 13.9587 6.99991C13.9587 7.23699 13.88 7.37555 13.4673 7.9503C12.919 8.71416 12.1226 9.68856 11.1713 10.4674C10.2144 11.2509 9.15298 11.7942 8.06467 11.7942C6.97636 11.7942 5.91492 11.2509 4.95799 10.4674C4.00673 9.68856 3.21037 8.71416 2.66199 7.9503C2.24938 7.37555 2.17066 7.23699 2.17066 6.99991C2.17066 6.76282 2.24938 6.62426 2.66199 6.04951Z"
                                              stroke="#FFAC00" stroke-width="0.69434"/>
                                    </svg>
                                    <span class="ms-1">
                                  <?php echo number_format(rand(1000, 2500)); ?>
                                    بازدید
                                </span>
                                </div>
                                <div class="d-inline-flex text-yellow ms-3">
                                    <svg width="14" height="16" viewBox="0 0 14 16" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M11.8634 7.99997C11.8634 9.85171 11.8634 10.7776 11.5031 11.4849C11.1861 12.107 10.6803 12.6128 10.0581 12.9298C9.35084 13.2902 8.42497 13.2902 6.57323 13.2902C4.72148 13.2902 3.79561 13.2902 3.08833 12.9298C2.4662 12.6128 1.96039 12.107 1.64339 11.4849C1.28302 10.7776 1.28302 9.85171 1.28302 7.99997C1.28302 6.14822 1.28302 5.22235 1.64339 4.51507C1.96039 3.89294 2.4662 3.38713 3.08833 3.07013C3.79561 2.70976 4.72148 2.70976 6.57323 2.70976C8.42497 2.70976 9.35084 2.70976 10.0581 3.07013C10.6803 3.38713 11.1861 3.89294 11.5031 4.51507C11.8634 5.22235 11.8634 6.14822 11.8634 7.99997ZM11.8634 7.99997H13.186M6.57323 5.35486V7.66933C6.57323 8.21715 7.01732 8.66124 7.56514 8.66124V8.66124H8.55705M3.92812 1.38721H9.21833M3.92812 14.6127H9.21833"
                                              stroke="#FFAC00" stroke-width="1.48787" stroke-linecap="round"/>
                                    </svg>
                                    <span class="ms-1">
                                    2
                                    دقیقه
                                </span>
                                </div>
                            </div>
                            <div class="card-description line-clamp-3 text-justify mb-4">
                                <?php echo $post->post_excerpt ?>
                            </div>
                            <div class="card-btn text-center">
                                <a class="card-link" href="<?php echo get_permalink($post) ?>">
                                    مطالعه بیشتر
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
