<?php
/**
 * Title: login header
 * Slug: modiram/section-header-login
 * Categories: header
 * Post Types: post, page
 */

global $theme_settings;

?>

<div class="d-flex justify-content-between">

    <!--logo-->
    <a href="<?php echo get_site_url(); ?>" class="image-logo">
        <img class="d-lg-inline-block d-none"
             src="<?php echo $theme_settings['information']['logo']['link-main-desktop'] ?? ''; ?>">
        <img class="d-lg-none"
             src="<?php echo $theme_settings['information']['logo']['link-main-mobile'] ?? '' ?>">
    </a>

    <!--background overlay!!!-->
    <div class="navigation-ovrlay btn-close-nav igation"></div>

    <!--links-->
    <div class="holder-navigation d-lg-flex align-items-center mx-auto">

        <div class="d-flex justify-content-end mb-3">
            <!--button search-->
            <button class="btn-close-navigation d-lg-none">
                <svg fill="none" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg">
                    <g stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5">
                        <path d="m19 4.99994-14 13.99996"/>
                        <path d="m5 4.99994 14 13.99996"/>
                    </g>
                </svg>
            </button>
        </div>

        <!--logo-->
        <div class="d-lg-none text-center mb-4">
            <a class="image-logo" href="#">
                <img src="/wp-content/themes/modiram/assets/images/logo-dark.png">
            </a>
        </div>

        <nav class="nav-menu-links d-lg-flex align-items-center">
            <?php if (is_user_logged_in()) { ?>
                <a class="nav-menu-link d-lg-inline-block d-block mx-md-3 mx-2 row d-lg-none header-profile-button"
                   onclick="$('.header-profile-menu-mobile').slideToggle('slow');" href="#">
                        <span class="col p-0 pe-1">
                            <svg style="border-radius: 50px;" width="35" height="36" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" id="Layer_1"
                                 viewBox="0 0 64 64">
                            <image width="64" height="64"
                                   xlink:href="data:image/png;base64,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"/>
                        </svg>
                        </span>
                    <span class="col p-0 fw-semibold">
                            پروفایل
                        </span>
                </a>
                <div class="header-profile-menu-mobile row bg-gray-200" style="display: none">
                    <?php foreach (mdr_get_menu_array('menu_profile') as $menu) { ?>
                        <a class="nav-menu-link d-lg-inline-block" href="<?php echo $menu['url']; ?>">
                            <?php echo $menu['title']; ?>
                        </a>
                    <?php } ?>
                    <a class="nav-menu-link d-lg-inline-block" href="#" onclick="logout()">
                        خروج
                    </a>
                </div>
            <?php } else { ?>
                <a class="nav-menu-link d-lg-inline-block d-block mx-md-3 mx-2 row d-lg-none" href="#"
                   onclick="login()">
                        <span class="col p-0 pe-1">
                            <svg style="border-radius: 50px;" width="35" height="36" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" id="Layer_1"
                                 viewBox="0 0 64 64">
                            <image width="64" height="64"
                                   xlink:href="data:image/png;base64,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"/>
                        </svg>
                        </span>
                    <span class="col p-0 fw-semibold">
                            پروفایل
                        </span>
                </a>
            <?php } ?>
            <?php foreach (mdr_get_menu_array('menu_main') as $menu) { ?>
                <a class="nav-menu-link d-lg-inline-block d-block mx-md-3 mx-2" href="<?php echo $menu['url']; ?>">
                    <?php echo $menu['title']; ?>
                </a>
            <?php } ?>
        </nav>
    </div>

    <!--button search-->
    <button class="mr-auto d-lg-inline-block d-none">
        <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
            <ellipse cx="9.16667" cy="9.33854" rx="6.66667" ry="6.66667" stroke="#403F3F" stroke-width="2"
                     stroke-linecap="round" stroke-linejoin="round"/>
            <path d="M13.75 14.3034L17.9167 18.4701" stroke="#403F3F" stroke-width="2" stroke-linecap="round"
                  stroke-linejoin="round"/>
        </svg>
    </button>
    <?php if (is_user_logged_in()) { ?>
        <button class="mr-auto d-lg-inline-block d-none header-profile-button">
            <svg style="border-radius: 50px;" width="35" height="36" xmlns="http://www.w3.org/2000/svg"
                 xmlns:xlink="http://www.w3.org/1999/xlink" id="Layer_1"
                 viewBox="0 0 64 64">
                <image width="64" height="64"
                       xlink:href="data:image/png;base64,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"/>
            </svg>
        </button>
        <div class="position-relative header-profile-menu">
            <div class="position-absolute">
                <ul class="mb-0">
                    <?php foreach (mdr_get_menu_array('menu_profile') as $menu) { ?>
                        <li class="btn btn-sm btn-light">
                            <a class="nav-menu-link d-lg-inline-block" href="<?php echo $menu['url']; ?>">
                                <?php echo $menu['title']; ?>
                            </a>
                        </li>
                    <?php } ?>
                    <li class="border-top btn btn-sm btn-light" onclick="logout()">خروج</li>
                </ul>
            </div>
        </div>
    <?php } else { ?>
        <button class="mr-auto d-lg-inline-block d-none" onclick="login()">
            <svg style="border-radius: 50px;" width="35" height="36" xmlns="http://www.w3.org/2000/svg"
                 xmlns:xlink="http://www.w3.org/1999/xlink" id="Layer_1"
                 viewBox="0 0 64 64">
                <image width="64" height="64"
                       xlink:href="data:image/png;base64,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"/>
            </svg>
        </button>
    <?php } ?>

    <!--button open navigation in mobile-->
    <button class="btn-open-navigation d-lg-none d-inline-block mr-auto">
        <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M3 6.6001H21" stroke="#FAFAFA" stroke-width="2" stroke-linecap="round"/>
            <path d="M3 12.6001H21" stroke="#FAFAFA" stroke-width="2" stroke-linecap="round"/>
            <path d="M3 18.6001H21" stroke="#FAFAFA" stroke-width="2" stroke-linecap="round"/>
        </svg>
    </button>
</div>
