<?php
/**
 * Title: FAQ
 * Slug: modiram/section-faq
 * Categories: content
 * Post Types: post, page
 */

global $post, $meta;

if (!$meta || !isset($meta['faqs'][0]) || empty($meta['faqs'][0])) {
    return;
}

?>

<!--FAQ-->
<div class="frequently-asked-questions">
    <h2 class="text-yellow font-extrabold mb-4">
        سوالات متداول
    </h2>
    <?php foreach (maybe_unserialize($meta['faqs'][0]) as $faq) { ?>
        <div class="question mb-2">
            <div class="header-question d-flex align-items-center justify-content-between fw-bold">
                    <span class="ml-3">
                        <?php echo $faq['question']; ?>
                    </span>
                <span class="arrow-icon mr-auto">
                    <svg width="15" height="10" viewBox="0 0 15 10" fill="none"
                         xmlns="http://www.w3.org/2000/svg">
                        <path d="M2 8L7.5 3L13 8" stroke="#FFAC00" stroke-width="3"
                              stroke-linecap="round"/>
                    </svg>
                </span>
            </div>
            <div class="body-question">
                <div class="text-justify">
                    <?php echo $faq['answer']; ?>
                </div>
            </div>
        </div>
    <?php } ?>
</div>

