<?php
/**
 * Title: Benefits
 * Slug: modiram/section-benefits
 * Categories: content
 * Post Types: post, page
 */

global $meta;

if (!$meta || !isset($meta['benefits'][0]) || empty($meta['benefits'][0])) {
    $meta['benefits'][0] = [
        [
            'icon' => '/wp-content/themes/modiram/assets/images/support.svg',
            'title' => '6 ماه پشتیبانی توسط تیم تخصصی',
        ],
        [
            'icon' => '/wp-content/themes/modiram/assets/images/update.svg',
            'title' => 'بروزرسانی رایگان محتوای دوره',
        ],
        [
            'icon' => '/wp-content/themes/modiram/assets/images/warranty.svg',
            'title' => 'یک ماه ضمانت بازگشت وجه',
        ],
        [
            'icon' => '/wp-content/themes/modiram/assets/images/time.svg',
            'title' => 'مشاهده دوره، مستقل از زما',
        ]
    ];
}

?>

<!--benefits-->
<div class="course-benefits p-md-0 p-4 mb-md-5 mb-4">
    <div class="benefits p-md-4">
        <div class="row">
            <?php foreach (maybe_unserialize($meta['benefits'][0]) as $benefit) { ?>
                <div class="col-lg-3 col-6">
                    <div class="text-center px-lg-2 mb-lg-0 mb-4">
                        <div class="mx-auto mb-2">
                            <img src="<?php echo $benefit['icon'] ?>">
                        </div>
                        <div class="fw-bold">
                            <?php echo $benefit['title'] ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</div>


