<?php
/**
 * Title: viewpoint
 * Slug: modiram/section-archive-viewpoint
 * Categories: content
 * Post Types: post, page
 */

global $posts, $wp_query, $category, $pagination;

$categories = get_categories([
    'taxonomy' => 'viewpoint_category',
    'parent' => 0,
    'number' => 4,
]);

if (!isset($category->slug)) {
    $category = $categories[array_key_first($categories)] ?? [];
    $wp_query = new WP_Query([
        'post_type' => 'viewpoint',
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC',
        'posts_per_page' => get_option('posts_per_page'),
        'offset' => 0,
        'tax_query' => [
            [
                'taxonomy' => 'viewpoint_category',
                'field' => 'slug',
                'terms' => $category->slug ?? '',
            ],
        ],
    ]);
    $posts = $wp_query->posts ?? [];
}

if (!$posts || empty($posts)) {
    return;
}

$pagination = [
    'post_type' => 'viewpoint',
    'taxonomy' => 'viewpoint_category',
    'term_slug' => $category->slug,
    'max_num_pages' => $wp_query->max_num_pages
];

?>
<section class="section-to-top mb-5">
    <div class="container">
        <div id="mdr_list_items" class="list-comments mb-5">
            <?php foreach ($posts as $post_list) {
                $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post_list->ID), 'single-post-thumbnail');
                ?>
                <div class="comment-card">
                    <div class="text-justify mb-5">
                        <?php echo $post_list->post_content; ?>
                    </div>
                    <div class="user-details text-sm mt-auto">
                        <div>
                            <div class="font-weight-bold line-clamp-1"><?php echo $post_list->post_title ?? '' ?></div>
                            <div class="line-clamp-1"><?php echo $post_list->post_excerpt ?? '' ; ?></div>
                        </div>
                        <div class="user-image">
                            <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png') ?>">
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div id="mdr_list_item" class="comment-card" style="display: none">
            <div class="mdr_list_item_content text-justify mb-5">

            </div>
            <div class="user-details text-sm mt-auto">
                <div>
                    <div class="mdr_list_item_title font-weight-bold line-clamp-1"></div>
                    <div class="mdr_list_item_description line-clamp-1"></div>
                </div>
                <div class="user-image">
                    <img class="mdr_list_item_image" src="">
                </div>
            </div>
        </div>
        <!-- wp:pattern {"slug":"modiram/section-pagination"} /-->
    </div>
</section>

