<?php
/**
 * Title: products
 * Slug: modiram/section-archive-product
 * Categories: query
 * Post Types: page
 */

global $posts, $theme_settings;

if (!class_exists('woocommerce')) {
    return;
}

$top_product = false;

if (isset($theme_settings['payment']['top_product']) && $theme_settings['payment']['top_product']) {
    $top_product = wc_get_product(82);
    if (!$top_product) $top_product = false;
}

?>

<?php if ($top_product) {
    $top_thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($top_product->get_id()), 'single-post-thumbnail');
    $top_meta = get_post_meta($top_product->get_id());
    $gallery_image_id = $top_product->get_gallery_image_ids()[0] ?? ''; ?>
    <section class="section-to-top mb-md-5 mb-4">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-12 pl-lg-1">
                    <div class="selected-course p-xl-4 p-3 mb-3">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="course-image mb-md-0 mb-3">
                                    <img src="<?php echo $top_thumbnail[0] ?? ''; ?>">
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="h-100 d-flex flex-column justify-content-center -py-3">
                                    <div class="d-flex align-items-center mb-md-3 mb-2">
                                        <div class="me-1 pb-1">
                                            <svg width="22" height="26" viewBox="0 0 22 26" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path d="M11.0352 18.9268L5.18738 21.9999L6.30688 15.4892L1.57422 10.8751L8.11127 9.92681L11.0352 4L13.9634 9.92681L20.5005 10.8751L15.7678 15.4892L16.8873 21.9999L11.0352 18.9268Z"
                                                      stroke="#FFAC00" stroke-width="3" stroke-linecap="round"
                                                      stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                        <div class="course-title font-weight-bold line-clamp-1">
                                            <?php echo $top_product->get_title(); ?>
                                        </div>
                                    </div>
                                    <div class="card-labels mb-3 pl-lg-5 mb-3">
                                        <?php if (!empty($top_meta['_teacher'][0])) { ?>
                                            <div class="card-label">
                                                <div>
                                                    <svg width="17" height="18" viewBox="0 0 17 18" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M4.77734 4.57548C4.77734 3.62721 5.15404 2.7178 5.82457 2.04727C6.4951 1.37674 7.40454 1 8.35281 1C9.30108 1 10.2105 1.37674 10.881 2.04727C11.5516 2.7178 11.9283 3.62721 11.9283 4.57548C11.9283 6.54992 10.3272 8.70172 8.35281 8.70172C6.37837 8.70172 4.77734 6.54525 4.77734 4.57548Z"
                                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                                        <path d="M15.4996 17.0011C14.9768 14.4198 11.9801 11.9646 8.35329 11.9646C4.72648 11.9646 1.72515 14.4198 1.20703 17.0011"
                                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"
                                                              stroke-linecap="round"/>
                                                    </svg>
                                                </div>
                                                <div class="text-label">
                                                    مدرس:
                                                </div>
                                                <div>
                                                    <?php echo $top_meta['_teacher'][0] ?? '' ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        <?php if (!empty($top_meta['_time'][0])) { ?>
                                            <div class="card-label">
                                                <div>
                                                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M8.20703 15.0005C12.073 15.0005 15.207 11.8665 15.207 8.00049C15.207 4.13449 12.073 1.00049 8.20703 1.00049C4.34104 1.00049 1.20703 4.13449 1.20703 8.00049C1.20703 11.8665 4.34104 15.0005 8.20703 15.0005Z"
                                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                                        <path d="M8.20703 4.15063V8.35063" stroke="#BBBBBB"
                                                              stroke-width="2"
                                                              stroke-linecap="round" stroke-linejoin="round"/>
                                                        <path d="M10.5453 9.56132L8.31934 8.53931" stroke="#BBBBBB"
                                                              stroke-width="2" stroke-linecap="round"
                                                              stroke-linejoin="round"/>
                                                    </svg>
                                                </div>
                                                <div class="text-label">
                                                    زمان:
                                                </div>
                                                <div>
                                                    <?php echo $top_meta['_time'][0] ?? 0 ?>ساعت
                                                </div>
                                            </div>
                                        <?php } ?>
                                        <?php if (!empty($top_meta['_participants'][0])) { ?>
                                            <div class="card-label">
                                                <div>
                                                    <svg width="21" height="19" viewBox="0 0 21 19" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M6.01074 4.77124C6.01074 6.05121 6.99874 7.02124 8.13574 7.02124V9.02124C5.82096 9.02124 4.01074 7.08112 4.01074 4.77124H6.01074ZM8.13574 7.02124C9.27274 7.02124 10.2607 6.05121 10.2607 4.77124H12.2607C12.2607 7.08112 10.4505 9.02124 8.13574 9.02124V7.02124ZM10.2607 4.77124C10.2607 3.49127 9.27274 2.52124 8.13574 2.52124V0.52124C10.4505 0.52124 12.2607 2.46136 12.2607 4.77124H10.2607ZM8.13574 2.52124C6.99874 2.52124 6.01074 3.49127 6.01074 4.77124H4.01074C4.01074 2.46136 5.82096 0.52124 8.13574 0.52124V2.52124ZM11.2607 12.2712H5.01074V10.2712H11.2607V12.2712ZM5.01074 16.7712H11.2607V18.7712H5.01074V16.7712ZM11.2607 16.7712C12.3977 16.7712 13.3857 15.8012 13.3857 14.5212H15.3857C15.3857 16.8311 13.5755 18.7712 11.2607 18.7712V16.7712ZM2.88574 14.5212C2.88574 15.8012 3.87374 16.7712 5.01074 16.7712V18.7712C2.69596 18.7712 0.885743 16.8311 0.885743 14.5212H2.88574ZM5.01074 12.2712C3.87374 12.2712 2.88574 13.2413 2.88574 14.5212H0.885743C0.885743 12.2114 2.69596 10.2712 5.01074 10.2712V12.2712ZM11.2607 10.2712C13.5755 10.2712 15.3857 12.2114 15.3857 14.5212H13.3857C13.3857 13.2413 12.3977 12.2712 11.2607 12.2712V10.2712Z"
                                                              fill="#BBBBBB"/>
                                                        <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                                              fill="#BBBBBB"/>
                                                        <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                                              fill="#BBBBBB"/>
                                                        <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                                              stroke="#BBBBBB" stroke-width="0.5"/>
                                                        <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                                              stroke="#BBBBBB" stroke-width="0.5"/>
                                                    </svg>
                                                </div>
                                                <div class="text-label">
                                                    شرکت‌کنندگان:
                                                </div>
                                                <div>
                                                    <?php echo number_format($top_meta['_participants'][0] ?? 0) ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                        <?php if (!empty($top_meta['_execution'][0])) { ?>
                                            <div class="card-label">
                                                <div class="pb-1">
                                                    <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M7.39941 9.57519C8.54497 9.57519 9.47363 8.64654 9.47363 7.50098C9.47363 6.35542 8.54497 5.42676 7.39941 5.42676C6.25385 5.42676 5.3252 6.35542 5.3252 7.50098C5.3252 8.64654 6.25385 9.57519 7.39941 9.57519Z"
                                                              stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                                              stroke-linejoin="round"/>
                                                        <path d="M13.5004 7.56657C13.5022 6.61966 13.2836 5.6853 12.8619 4.83749C12.4402 3.98968 11.8269 3.25168 11.0706 2.6819C10.3143 2.11212 9.4357 1.72622 8.50444 1.55473C7.57318 1.38325 6.61479 1.4309 5.70514 1.6939C4.79548 1.9569 3.95953 2.42803 3.26346 3.07001C2.56739 3.71199 2.03033 4.50718 1.69476 5.39264C1.35919 6.27811 1.23435 7.22953 1.3301 8.1716C1.42586 9.11366 1.73959 10.0205 2.24646 10.8203L3.02737 12.0405L7.39959 18.548L11.7718 12.0405L12.5527 10.8203C13.1716 9.84793 13.5003 8.7192 13.5004 7.56657V7.56657Z"
                                                              stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                                              stroke-linejoin="round"/>
                                                    </svg>
                                                </div>
                                                <div>
                                                    <?php echo $top_meta['_execution'][0] ?? '' ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <a href="<?php echo get_permalink($top_product->get_id()) ?>"
                                       class="btn-course bg-yellow btn-register d-flex align-items-center justify-content-between py-2 px-3">
                                        <div class="d-flex align-items-center">
                                            <div class="ml-1">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                     xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z"
                                                          stroke="#1B1B1B" stroke-width="1.5"/>
                                                    <path d="M9 12L11 14L15 10" stroke="#1B1B1B" stroke-width="1.5"
                                                          stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                            </div>
                                            <span class="font-weight-bold py-1">ثبت‌نام</span>
                                        </div>
                                        <div class="mr-auto">
                                            <?php if (!empty($top_meta['_sale_price'][0])) { ?>
                                                <div class="off-price text-sm">
                                                    <?php echo number_format($top_meta['_regular_price'][0] ?? 0) ?>
                                                </div>
                                            <?php } ?>
                                            <div class="d-flex align-items-center">
                                                <span class="current-price text-xl font-weight-bold ml-1 ">
                                                    <?php echo number_format($top_meta['_price'][0] ?? 0) ?>
                                                </span>
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                     xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                          d="M3.60288 1.63719L2.8437 0.78125L2.07261 1.59144L2.79879 2.39748L3.60288 1.63719ZM0.372938 2.01685L1.49673 2.514C1.45647 2.6587 1.41427 2.80037 1.37257 2.94032C1.28099 3.24769 1.19187 3.54682 1.13128 3.85185C0.979335 4.62655 1.31983 5.1273 2.0973 5.21437C2.567 5.2676 3.05306 5.23239 3.52581 5.18137C3.83081 5.1481 4.06289 4.9407 4.1006 4.60769C4.13471 4.30907 4.14524 4.00656 4.14968 3.70545C4.15514 3.32925 4.15534 2.95294 4.15554 2.57658V2.5762V2.5762V2.57619C4.15565 2.37959 4.15576 2.18297 4.15661 1.98635C4.16132 1.95891 4.16895 1.93205 4.17935 1.90622H5.37329C5.37329 2.19527 5.37911 2.48438 5.38493 2.77317C5.3982 3.43153 5.41143 4.08827 5.35554 4.73912C5.27763 5.64386 4.69009 6.22974 3.79366 6.36089C3.12155 6.45933 2.41256 6.50674 1.74627 6.40498C0.404547 6.20035 -0.315255 5.12952 -0.146673 3.74953C-0.115613 3.49151 -0.0618914 3.23673 0.0138685 2.98814C0.0809864 2.76986 0.164244 2.55625 0.253002 2.32853L0.253007 2.32852C0.292216 2.22792 0.332499 2.12457 0.372938 2.01685ZM0.42905 6.76642L0.429001 6.7664C0.318171 6.72224 0.204233 6.67685 0.0865058 6.62854C0.0865058 7.00028 0.0861867 7.36829 0.0858698 7.73368L0.0858698 7.73375C0.0851217 8.59638 0.0843863 9.44441 0.0878922 10.2924C0.0934376 11.6649 1.3664 12.4352 2.60332 11.8294C2.70785 11.7781 2.87116 11.7919 2.98845 11.8313C3.13364 11.8802 3.27556 11.9401 3.41735 11.9999L3.41738 11.9999C3.6108 12.0815 3.80399 12.163 4.00493 12.2164C4.82539 12.4346 5.54297 12.0875 5.75176 11.3411C5.85383 10.9712 5.8807 10.5847 5.83078 10.2043C5.73041 9.48279 5.37467 8.90717 4.6166 8.70116C3.89181 8.50429 3.26378 8.70476 2.80739 9.29341C2.59954 9.56171 2.46419 9.89439 2.3342 10.2139L2.31634 10.2578C2.14055 10.6903 1.99027 10.8331 1.63231 10.7613C1.31125 10.6974 1.32991 10.4668 1.34738 10.2508C1.35159 10.1988 1.35573 10.1475 1.35503 10.0997C1.34917 9.64433 1.34914 9.18873 1.3491 8.73306C1.34907 8.28288 1.34904 7.83262 1.34339 7.38244C1.34228 7.28207 1.27518 7.13068 1.1956 7.09241C0.95204 6.97477 0.699825 6.87429 0.42905 6.76642ZM4.66221 10.4542C4.67586 10.4957 4.68795 10.5325 4.69951 10.5619C4.68952 11.0474 4.56059 11.1406 4.18904 11.0314L4.17449 11.0271C4.10972 11.008 4.04488 10.9889 3.9822 10.9632C3.45011 10.7541 3.39216 10.3609 3.83829 9.98327C4.04375 9.80831 4.34543 9.82605 4.4921 10.0579C4.57481 10.1884 4.62444 10.3394 4.66221 10.4542ZM10.2552 10.2393C10.1625 10.238 10.0671 10.2366 9.96798 10.2366C9.96798 10.1769 9.96885 10.1175 9.96971 10.0583V10.0583V10.0582V10.0582C9.97157 9.93091 9.97341 9.80456 9.96659 9.67873C9.91973 8.79617 9.28561 8.05225 8.49372 7.94439C7.49581 7.80824 6.76519 8.21833 6.49929 9.12224C6.10307 10.4679 6.74884 11.4244 8.06838 11.471C8.19775 11.4755 8.327 11.4835 8.48073 11.4931L8.48086 11.4931L8.48124 11.4931C8.55733 11.4978 8.63943 11.503 8.73051 11.5082C8.36197 12.1395 7.80301 12.1927 7.2637 12.244C7.12702 12.257 6.99159 12.2699 6.86085 12.292V13.4976C7.64942 13.4682 8.39806 13.3917 9.07183 12.9855C9.6286 12.6494 9.88729 12.1218 9.98018 11.5024C10.089 11.4968 10.1952 11.4918 10.2995 11.4868L10.3002 11.4868H10.3002H10.3002C10.5415 11.4753 10.773 11.4642 11.0042 11.4491C11.7234 11.4017 12.3988 10.8965 12.4604 10.2588C12.5034 9.81244 12.4934 9.36105 12.4831 8.89918C12.4786 8.69369 12.474 8.48612 12.474 8.276L11.2373 8.6506C11.2373 8.77343 11.2366 8.893 11.2358 9.01029C11.2341 9.27401 11.2325 9.5262 11.2398 9.778C11.2482 10.0633 11.109 10.2147 10.8414 10.2324C10.651 10.245 10.4596 10.2423 10.2553 10.2393H10.2553H10.2553H10.2552H10.2552ZM8.70874 10.0289L8.70875 10.0289L8.70875 10.0289C8.71491 10.1021 8.72126 10.1774 8.72968 10.2555H8.73079C8.64254 10.2555 8.56184 10.2569 8.48631 10.2582H8.48626H8.48622H8.48618H8.48614H8.48612C8.33317 10.2608 8.20142 10.2631 8.07115 10.2527C7.74009 10.2263 7.59341 10.0797 7.58981 9.79962C7.58509 9.45719 7.77003 9.18934 8.0437 9.14165C8.32181 9.09341 8.57524 9.2509 8.64649 9.55396C8.68144 9.70475 8.69461 9.86105 8.70874 10.0289ZM9.58645 6.12429L9.62553 6.16131C9.85149 6.37539 10.0913 6.60264 10.3498 6.84797L9.56455 7.57942L8.90297 6.82856L9.58645 6.12429ZM10.4041 6.8556C10.6576 7.09683 10.9032 7.33112 11.1708 7.58649L11.9164 6.83314L11.1708 6.12859L10.4041 6.8556Z"
                                                          fill="black"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($gallery_image_id) { ?>
                    <div class="col-lg-4 col-12 pr-lg-1">
                        <div class="h-100 course-club">
                            <img src="<?php echo wp_get_attachment_url($gallery_image_id); ?>">

                            <!--course text-->
                            <div class="club-descripton">
                                <div>
                                    <svg width="294" height="105" viewBox="0 0 294 105" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <g style="mix-blend-mode:hard-light" filter="url(#filter0_f_2885_2159)">
                                            <mask id="path-1-inside-1_2885_2159" fill="white">
                                                <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0037 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"/>
                                                <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2244 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5682 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"/>
                                                <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.2 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"/>
                                                <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3587C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.217 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"/>
                                                <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9076 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7315 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"/>
                                                <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"/>
                                            </mask>
                                            <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0037 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                            <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2244 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5682 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                            <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.2 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                            <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3587C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.217 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                            <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9076 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7315 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                            <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"
                                                  stroke="#FFAB2D" stroke-width="10.7191"
                                                  mask="url(#path-1-inside-1_2885_2159)"/>
                                        </g>
                                        <g filter="url(#filter1_d_2885_2159)">
                                            <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0037 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"
                                                  fill="#FFC700"/>
                                            <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2244 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5682 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"
                                                  fill="#FFC700"/>
                                            <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.2 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"
                                                  fill="#FFC700"/>
                                            <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3587C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.217 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"
                                                  fill="#FFC700"/>
                                            <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9076 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7315 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"
                                                  fill="#FFC700"/>
                                            <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"
                                                  fill="#FFC700"/>
                                        </g>
                                        <g style="mix-blend-mode:hard-light" filter="url(#filter2_f_2885_2159)">
                                            <mask id="path-3-inside-2_2885_2159" fill="white">
                                                <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0037 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"/>
                                                <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2244 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5682 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"/>
                                                <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.2 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"/>
                                                <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3587C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.217 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"/>
                                                <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9076 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7315 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"/>
                                                <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"/>
                                            </mask>
                                            <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0037 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                            <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2244 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5682 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                            <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.2 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                            <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3587C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.217 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                            <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9076 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7315 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                            <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"
                                                  stroke="#FFAB2D" stroke-width="14.0172"
                                                  mask="url(#path-3-inside-2_2885_2159)"/>
                                        </g>
                                        <g style="mix-blend-mode:hard-light" filter="url(#filter3_ddi_2885_2159)">
                                            <mask id="path-4-inside-3_2885_2159" fill="white">
                                                <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0038 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"/>
                                                <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2245 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5683 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"/>
                                                <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.201 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"/>
                                                <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3588C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.218 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"/>
                                                <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9077 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7316 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"/>
                                                <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"/>
                                            </mask>
                                            <path d="M48.7641 32.0118C48.6805 32.0473 48.597 32.0887 48.5195 32.1241C58.7576 32.7862 64.3181 41.1454 64.2167 48.6119C64.1033 48.6178 63.99 48.6355 63.8766 48.6355C61.0725 48.6355 58.2743 48.6355 55.4701 48.6355C55.3866 48.6355 55.3031 48.6355 55.2196 48.6237C55.0764 48.6119 55.0048 48.535 54.9869 48.399C54.963 48.2335 54.9451 48.0739 54.9272 47.9084C54.7363 46.4245 54.1934 45.0767 53.2507 43.9121C52.2424 42.6647 50.9298 41.8666 49.3786 41.4351C48.5493 41.2045 47.6961 41.0922 46.837 41.0804C45.3573 41.0567 43.8777 41.0508 42.404 41.0804C40.7991 41.1158 39.2539 41.4351 37.8697 42.2923C36.7659 42.978 35.9187 43.8884 35.3042 45.0353C34.7792 46.0225 34.5405 47.0866 34.3496 48.1685C34.3198 48.3399 34.3257 48.5232 34.3257 48.6946C34.3257 53.4713 34.3198 58.242 34.3317 63.0187C34.3317 63.4857 34.451 63.9527 34.5465 64.4138C34.8269 65.7676 35.4056 66.9854 36.3543 68.0081C37.4998 69.2437 38.9257 69.9649 40.5903 70.2664C41.4852 70.426 42.3861 70.4792 43.293 70.4733C44.3789 70.4674 45.4647 70.4792 46.5506 70.4733C47.6782 70.4615 48.7879 70.3373 49.8559 69.9531C52.2424 69.0959 53.8294 67.4761 54.611 65.0759C54.8914 64.2246 54.963 63.3497 54.9869 62.4629C54.9869 62.4038 54.969 62.3506 54.957 62.256C54.8019 62.2501 54.6528 62.2324 54.5036 62.2324C51.5801 62.2324 48.6626 62.2324 45.7392 62.2324C45.5721 62.2324 45.411 62.2324 45.2142 62.2324C45.2022 62.0787 45.1784 61.9664 45.1784 61.854C45.1784 59.3652 45.1784 56.8823 45.1784 54.3935C45.1784 54.0388 45.2022 54.0211 45.5662 54.0092C45.7809 54.0092 45.9957 54.0092 46.2105 54.0092C52.0038 54.0092 57.803 54.0092 63.5962 54.0092C63.7513 54.0092 63.9064 54.0092 64.0616 54.0151C64.2286 54.0151 64.33 54.0979 64.3181 54.2753C64.3181 54.3698 64.3181 54.4644 64.3181 54.559C64.3181 57.2725 64.336 59.98 64.3181 62.6935C64.3062 64.0887 64.1212 65.4602 63.7752 66.8199C63.3814 68.3628 62.7788 69.8171 61.9793 71.1886C60.9293 72.9799 59.5749 74.5287 57.9223 75.8056C55.6909 77.5319 53.1851 78.6551 50.3988 79.1517C49.6769 79.2817 48.9371 79.3645 48.1973 79.4C47.0995 79.4532 46.0017 79.4532 44.9099 79.4532C43.7524 79.4532 42.595 79.4413 41.4435 79.4295C39.3792 79.4 37.3984 78.9566 35.4951 78.2058C32.6254 77.0707 30.2508 75.2795 28.4191 72.8143C27.6614 71.7975 27.029 70.7038 26.5219 69.5392C26.1818 68.7589 25.8835 67.9608 25.6687 67.1391C25.4181 66.1696 25.2332 65.1882 25.1317 64.1892C24.9826 62.7112 25.0064 61.2274 25.0064 59.7377C25.0064 56.2616 24.9885 52.7855 25.0124 49.3035C25.0184 48.0207 25.1675 46.7438 25.4181 45.4787C25.6926 44.0894 26.1281 42.7652 26.7367 41.4942C27.56 39.7798 28.6399 38.225 30.0062 36.8831C32.1361 34.7962 34.6658 33.3892 37.5475 32.603C38.4723 32.3488 39.415 32.2246 40.3636 32.1301C40.4531 32.1182 40.5963 32.1892 40.6082 32.0118C43.3288 32.0118 46.0435 32.0118 48.7641 32.0118Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                            <path d="M209.614 32.0118C209.71 32.1773 209.883 32.1419 210.032 32.1478C211.953 32.2128 213.821 32.5793 215.622 33.2296C217.901 34.0454 219.894 35.3046 221.541 37.0781C222.334 37.9294 223.015 38.8694 223.575 39.8862C224.429 41.441 224.983 43.0962 225.318 44.8343C225.502 45.7861 225.634 46.7378 225.646 47.7074C225.658 48.801 225.711 49.9006 225.711 50.9943C225.711 54.9078 225.711 58.8213 225.699 62.7349C225.693 64.6266 225.479 66.5006 224.936 68.3214C224.494 69.7934 223.898 71.2004 223.044 72.501C222.346 73.5651 221.523 74.5287 220.58 75.38C219.423 76.4145 218.11 77.2245 216.684 77.8511C215.044 78.5664 213.331 79.0039 211.559 79.2344C210.712 79.3467 209.847 79.3881 208.994 79.4059C207.693 79.4354 206.393 79.4059 205.092 79.4177C203.028 79.4295 201.005 79.1339 199.03 78.5428C196.578 77.8038 194.418 76.5683 192.628 74.7415C191.358 73.441 190.361 71.9571 189.657 70.2841C189.061 68.8594 188.679 67.3874 188.434 65.8622C188.231 64.5971 188.166 63.332 188.166 62.061C188.166 57.9701 188.154 53.8792 188.172 49.7883C188.172 48.7064 188.195 47.6128 188.321 46.5428C188.476 45.2126 188.673 43.8766 189.168 42.6115C189.389 42.038 189.58 41.4587 189.818 40.8912C190.158 40.0813 190.612 39.3305 191.113 38.6152C191.918 37.4683 192.867 36.4456 193.977 35.5766C195.26 34.5775 196.674 33.8031 198.213 33.2533C199.561 32.7685 200.963 32.467 202.383 32.2719C202.878 32.2069 203.38 32.1951 203.881 32.1596C204.018 32.1478 204.173 32.1833 204.263 32.0236H209.626L209.614 32.0118ZM197.384 55.7059C197.384 58.1592 197.348 60.6126 197.395 63.06C197.419 64.4907 197.724 65.8799 198.416 67.1746C199.048 68.3687 199.997 69.2023 201.238 69.7166C202.55 70.2605 203.94 70.4792 205.36 70.4969C206.375 70.5147 207.389 70.5147 208.403 70.4969C209.585 70.4733 210.754 70.3432 211.893 70.0004C213.838 69.4033 215.175 68.1618 215.855 66.276C216.285 65.0937 216.482 63.8581 216.482 62.5989C216.482 58.2952 216.482 53.9915 216.482 49.6937C216.482 48.334 216.392 46.992 215.998 45.6737C215.795 44.9939 215.515 44.3613 215.115 43.7938C214.429 42.8302 213.534 42.109 212.401 41.6893C211.201 41.24 209.954 41.0449 208.69 41.0212C207.27 40.9976 205.856 41.0212 204.436 41.0685C203.213 41.1099 202.031 41.3819 200.921 41.9198C199.83 42.4519 198.994 43.244 198.428 44.3141C198.141 44.8579 197.926 45.4314 197.765 46.0225C197.551 46.8147 197.401 47.6128 197.395 48.4286C197.384 50.8583 197.395 53.2821 197.395 55.7118L197.384 55.7059Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                            <path d="M146.724 32.0118C146.623 32.0532 146.521 32.0887 146.456 32.1123C149.254 32.2483 151.897 33.0405 154.331 34.5006C156.002 35.4997 157.439 36.7648 158.645 38.2841C159.677 39.5906 160.482 41.0331 161.097 42.576C161.652 43.9771 162.027 45.4195 162.201 46.9152C162.284 47.6423 162.344 48.3695 162.409 49.0966C162.421 49.2562 162.409 49.4218 162.409 49.5636C162.093 49.6701 153.597 49.6937 153.12 49.5991C153.108 49.4868 153.09 49.3626 153.084 49.2385C153.042 48.0148 152.851 46.8265 152.374 45.6915C151.545 43.7288 150.119 42.3691 148.114 41.5947C147.148 41.2222 146.133 41.0567 145.107 41.0331C143.628 40.9976 142.148 40.9917 140.674 41.0331C139.541 41.0626 138.425 41.2577 137.369 41.7011C135.185 42.6292 133.819 44.2431 133.151 46.4836C132.835 47.5478 132.733 48.6296 132.727 49.7292C132.727 53.7609 132.727 57.7927 132.727 61.8245C132.727 62.9122 132.823 63.9882 133.151 65.0345C134.058 67.9667 136.044 69.687 139.069 70.2723C139.928 70.4378 140.794 70.4851 141.665 70.4792C142.631 70.4733 143.598 70.4792 144.564 70.4792C145.584 70.4792 146.587 70.3551 147.565 70.089C149.403 69.5806 150.835 68.5343 151.831 66.9204C152.368 66.0573 152.702 65.1232 152.869 64.1182C152.983 63.4325 153.108 62.7467 153.084 62.0491C153.078 61.8245 153.126 61.7949 153.364 61.7831C153.436 61.7831 153.508 61.7831 153.579 61.7831C156.348 61.7831 159.11 61.7831 161.878 61.7831C162.033 61.7831 162.183 61.7831 162.374 61.7831C162.385 61.9427 162.415 62.0669 162.409 62.191C162.368 62.7999 162.344 63.4147 162.26 64.0236C162.147 64.8749 162.027 65.7321 161.837 66.5657C161.419 68.3333 160.745 70.0063 159.79 71.5551C157.535 75.2086 154.313 77.6205 150.143 78.7851C148.753 79.1753 147.333 79.4118 145.877 79.4236C144.111 79.4413 142.351 79.465 140.585 79.4591C137.56 79.4532 134.708 78.7378 132.053 77.2895C129.678 75.9948 127.727 74.239 126.236 72.0044C124.953 70.0831 124.1 67.9904 123.67 65.7203C123.479 64.7212 123.384 63.7162 123.384 62.6994C123.384 58.0292 123.39 53.3649 123.384 48.6946C123.384 47.0748 123.641 45.4905 124.118 43.9594C125.466 39.6497 128.115 36.3451 132.131 34.1519C133.801 33.2415 135.579 32.6089 137.47 32.2956C137.977 32.2128 138.485 32.1774 138.998 32.1182C139.075 32.1123 139.153 32.1064 139.081 32C141.617 32.0118 144.17 32.0118 146.724 32.0118Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                            <path d="M269.08 78.4836C267.803 78.4836 266.526 78.4836 265.256 78.4836C262.917 78.4836 260.584 78.4836 258.245 78.4895C258.013 78.4895 257.857 78.4304 257.72 78.2235C256.718 76.716 255.698 75.2263 254.683 73.7247C253.323 71.7029 251.963 69.6811 250.603 67.6652C249.594 66.1755 248.586 64.6857 247.578 63.2019C247.375 62.9004 247.166 62.5989 246.933 62.256C246.814 62.4275 246.724 62.5575 246.635 62.6935C245.824 63.9172 245.012 65.135 244.201 66.3588C243.521 67.3815 242.834 68.4042 242.154 69.4269C241.528 70.3728 240.907 71.3246 240.281 72.2704C239.487 73.4705 238.682 74.6706 237.888 75.8766C237.393 76.6274 236.892 77.3722 236.409 78.1289C236.236 78.395 236.045 78.5073 235.711 78.5073C232.179 78.4955 228.653 78.5014 225.121 78.5014C225.031 78.5014 224.936 78.4895 224.84 78.4895C224.918 78.194 226.893 75.3091 228.766 72.6724C230.114 70.7689 231.415 68.8417 232.74 66.9204C234.07 64.9931 235.4 63.0659 236.731 61.1387C238.055 59.2233 239.38 57.3079 240.734 55.3453C239.732 53.8851 238.718 52.4072 237.703 50.9292C236.683 49.4336 235.663 47.9438 234.643 46.4482C233.629 44.9643 232.608 43.4805 231.594 42.0026C230.568 40.5128 229.536 39.0231 228.521 37.5274C227.519 36.0436 226.487 34.5834 225.449 33.0286C225.664 33.0168 225.777 33.005 225.896 33.005C229.381 33.005 232.859 33.005 236.343 32.9991C236.635 32.9991 236.797 33.0996 236.946 33.3301C237.638 34.406 238.342 35.4702 239.04 36.5402C240.048 38.0831 241.051 39.632 242.059 41.1809C242.638 42.0735 243.228 42.9603 243.813 43.847C244.481 44.8638 245.143 45.8866 245.812 46.9034C246.187 47.4768 246.569 48.0443 246.981 48.6591C247.076 48.535 247.16 48.4404 247.226 48.3399C248.562 46.2353 249.893 44.1249 251.229 42.0144C252.237 40.4242 253.252 38.8457 254.254 37.2555C254.892 36.2446 255.525 35.2337 256.157 34.2228C256.372 33.8799 256.593 33.5489 256.801 33.206C256.891 33.0582 257.004 32.9872 257.183 32.9991C257.267 33.005 257.35 32.9991 257.434 32.9991C260.847 32.9991 264.253 32.9991 267.666 32.9991C267.815 32.9991 267.97 32.9991 268.197 32.9991C268.102 33.1764 268.048 33.2887 267.982 33.3892C266.729 35.2396 265.476 37.09 264.218 38.9344C263.561 39.9039 262.887 40.8616 262.231 41.8311C261.258 43.2618 260.304 44.6924 259.331 46.123C258.55 47.2758 257.762 48.4286 256.974 49.5814C256.127 50.8228 255.286 52.0643 254.445 53.3116C254.033 53.9205 253.621 54.5235 253.204 55.1265C253.156 55.1916 253.114 55.2625 253.067 55.3453C253.448 55.8951 253.824 56.4389 254.2 56.9769C255.22 58.443 256.241 59.9091 257.261 61.3752C258.275 62.8295 259.295 64.2837 260.31 65.738C261.103 66.8731 261.885 68.014 262.672 69.1491C263.472 70.2959 264.271 71.4369 265.071 72.5779C265.87 73.7247 266.664 74.8657 267.463 76.0125C268.006 76.787 268.543 77.5673 269.08 78.3418V78.4836Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                            <path d="M108.415 78.4896C108.403 78.2649 108.385 78.0757 108.385 77.8925C108.385 73.8489 108.385 69.8053 108.385 65.7617C108.385 62.7881 108.385 59.8204 108.385 56.8468C108.385 54.6181 108.367 52.3894 108.516 50.1666C108.546 49.6819 108.552 49.203 108.57 48.7183C108.57 48.6296 108.57 48.5409 108.57 48.3754C108.48 48.4818 108.439 48.5173 108.409 48.5646C107.806 49.5223 107.204 50.4859 106.595 51.4495C105.939 52.4899 105.27 53.5245 104.614 54.559C103.988 55.5463 103.373 56.5394 102.747 57.5326C101.935 58.8095 101.124 60.0865 100.313 61.3634C99.6562 62.4038 98.9999 63.4443 98.3437 64.4848C97.9499 65.1055 97.5561 65.7203 97.1683 66.341C97.049 66.5302 96.9058 66.6189 96.6731 66.6189C94.6684 66.613 92.6638 66.613 90.6651 66.6189C90.4503 66.6189 90.319 66.5479 90.2057 66.3647C89.096 64.5912 87.9743 62.8236 86.8526 61.0619C85.8861 59.5367 84.9077 58.0115 83.9411 56.4803C82.9448 54.9019 81.9484 53.3176 80.952 51.7391C80.3315 50.7578 79.711 49.7824 79.0906 48.8069C79.0249 48.7064 78.9593 48.6119 78.8519 48.4582C78.834 48.5941 78.8221 48.6651 78.8221 48.736C78.8638 50.007 78.9116 51.278 78.9533 52.549C78.9593 52.7973 78.9712 53.0456 78.9712 53.2939C78.9712 61.5112 78.9712 69.7284 78.9712 77.9457C78.9712 78.1053 78.9712 78.2708 78.9712 78.4659C78.8042 78.4777 78.6789 78.5014 78.5476 78.5014C75.7316 78.5014 72.9214 78.5014 70.1054 78.5014C70.0338 78.5014 69.9622 78.5014 69.8906 78.5014C69.7772 78.5014 69.7176 78.4304 69.7116 78.324C69.7116 78.2058 69.7056 78.0876 69.7056 77.9693C69.7056 63.1369 69.7056 48.3104 69.7056 33.4779C69.7056 33.342 69.7056 33.2001 69.7056 33.0286C69.8846 33.0168 70.0218 32.9991 70.1591 32.9991C72.9513 32.9991 75.7375 32.9991 78.5297 32.9932C78.828 32.9932 79.019 33.0878 79.1741 33.3301C79.5858 33.9804 80.0094 34.6189 80.427 35.2633C81.0535 36.2269 81.6739 37.1846 82.3004 38.1482C82.9806 39.1886 83.6547 40.2291 84.3349 41.2695C84.9494 42.2095 85.5699 43.1495 86.1844 44.0894C86.8109 45.0471 87.4373 46.0107 88.0638 46.9743C88.7201 47.9852 89.3883 48.9902 90.0386 50.007C90.4921 50.7164 90.9216 51.4317 91.3512 52.153C92.103 53.4122 92.8428 54.6773 93.5945 55.9364C93.6184 55.9719 93.6542 56.0074 93.7138 56.0724C93.8033 55.9424 93.8928 55.8359 93.9585 55.7177C94.931 54.0447 95.8975 52.3599 96.8819 50.6928C97.2697 50.0307 97.7112 49.3981 98.1289 48.7537C99.1312 47.2049 100.14 45.6619 101.148 44.119C101.756 43.1908 102.365 42.2627 102.973 41.3287C103.6 40.371 104.226 39.4074 104.853 38.4497C105.915 36.8239 107.001 35.2219 108.027 33.5725C108.313 33.1114 108.618 32.9813 109.137 32.9873C111.786 33.0168 114.429 32.9991 117.078 32.9991C117.233 32.9991 117.382 32.9991 117.579 32.9991C117.591 33.1823 117.609 33.3301 117.609 33.472C117.609 35.949 117.609 38.426 117.609 40.8971C117.609 53.2289 117.609 65.5607 117.609 77.8925C117.609 78.5369 117.68 78.5014 116.994 78.5014C114.297 78.5014 111.607 78.5014 108.91 78.5014C108.755 78.5014 108.606 78.5014 108.415 78.5014V78.4896Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                            <path d="M182.295 55.7827C182.295 63.1724 182.295 70.562 182.295 77.9516C182.295 78.3023 182.12 78.4797 181.77 78.4836C179.109 78.4836 176.454 78.4836 173.793 78.4836C173.439 78.4836 173.262 78.3083 173.262 77.9575C173.262 66.0986 173.262 54.2457 173.262 42.3868C173.262 41.6833 173.286 41.7602 172.618 41.7602C170.088 41.7602 167.564 41.7602 165.034 41.7602C164.289 41.7602 164.396 41.7247 164.396 41.1158C164.396 38.5915 164.396 36.0732 164.396 33.5489C164.396 32.9872 164.378 33.0109 164.951 33.0109C170.541 33.0109 176.132 33.0109 181.728 33.0109C182.325 33.0109 182.289 32.9991 182.289 33.5784C182.289 40.9799 182.289 48.3813 182.289 55.7827H182.295Z"
                                                  stroke="#FFC940" stroke-opacity="0.2" stroke-width="10.7191"
                                                  mask="url(#path-4-inside-3_2885_2159)"/>
                                        </g>
                                        <defs>
                                            <filter id="filter0_f_2885_2159" x="0.263695" y="7.26369" width="293.553"
                                                    height="96.9326" filterUnits="userSpaceOnUse"
                                                    color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                                         result="shape"/>
                                                <feGaussianBlur stdDeviation="12.3682"
                                                                result="effect1_foregroundBlur_2885_2159"/>
                                            </filter>
                                            <filter id="filter1_d_2885_2159" x="2.4" y="0.36" width="289.28"
                                                    height="92.66"
                                                    filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix"
                                                               values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                               result="hardAlpha"/>
                                                <feOffset dy="-9.04"/>
                                                <feGaussianBlur stdDeviation="11.3"/>
                                                <feComposite in2="hardAlpha" operator="out"/>
                                                <feColorMatrix type="matrix"
                                                               values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0"/>
                                                <feBlend mode="normal" in2="BackgroundImageFix"
                                                         result="effect1_dropShadow_2885_2159"/>
                                                <feBlend mode="normal" in="SourceGraphic"
                                                         in2="effect1_dropShadow_2885_2159"
                                                         result="shape"/>
                                            </filter>
                                            <filter id="filter2_f_2885_2159" x="16.7546" y="23.7546" width="260.571"
                                                    height="63.9508" filterUnits="userSpaceOnUse"
                                                    color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix"
                                                         result="shape"/>
                                                <feGaussianBlur stdDeviation="4.12272"
                                                                result="effect1_foregroundBlur_2885_2159"/>
                                            </filter>
                                            <filter id="filter3_ddi_2885_2159" x="14.2809" y="29.5264" width="265.518"
                                                    height="68.8981" filterUnits="userSpaceOnUse"
                                                    color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix"
                                                               values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                               result="hardAlpha"/>
                                                <feOffset dy="5.35953"/>
                                                <feGaussianBlur stdDeviation="2.06136"/>
                                                <feColorMatrix type="matrix"
                                                               values="0 0 0 0 0.224 0 0 0 0 0.15 0 0 0 0 0 0 0 0 0.7 0"/>
                                                <feBlend mode="multiply" in2="BackgroundImageFix"
                                                         result="effect1_dropShadow_2885_2159"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix"
                                                               values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                               result="hardAlpha"/>
                                                <feOffset dy="8.24543"/>
                                                <feGaussianBlur stdDeviation="5.35953"/>
                                                <feColorMatrix type="matrix"
                                                               values="0 0 0 0 0.56 0 0 0 0 0.44 0 0 0 0 0 0 0 0 1 0"/>
                                                <feBlend mode="color-dodge" in2="effect1_dropShadow_2885_2159"
                                                         result="effect2_dropShadow_2885_2159"/>
                                                <feBlend mode="normal" in="SourceGraphic"
                                                         in2="effect2_dropShadow_2885_2159"
                                                         result="shape"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix"
                                                               values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                               result="hardAlpha"/>
                                                <feOffset dx="-0.535953" dy="1.07191"/>
                                                <feGaussianBlur stdDeviation="0.267977"/>
                                                <feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/>
                                                <feColorMatrix type="matrix"
                                                               values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.5 0"/>
                                                <feBlend mode="normal" in2="shape"
                                                         result="effect3_innerShadow_2885_2159"/>
                                            </filter>
                                        </defs>
                                    </svg>
                                </div>
                                <div class="course-text text-xl">
                                    <?php echo $top_product->get_title(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>
<?php } ?>
<section class="mb-5">
    <div class="container">
        <div class="text-2xl font-extrabold mb-4">
            لیست آخرین آموزش ها
        </div>

        <div class="list-courses">
            <?php foreach ($posts as $post) {
                if ($top_product && $post->ID == $top_product->get_id()) continue;
                $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
                $meta = get_post_meta($post->ID); ?>
                <div class="card-course p-xl-4 p-3 mb-3">
                    <div class="card-image mb-3">
                        <img src="<?php echo $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png'); ?>">
                    </div>
                    <div class="d-flex align-items-center mb-2">
                        <div class="me-1 pb-1">
                            <svg width="22" height="26" viewBox="0 0 22 26" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.0352 18.9268L5.18738 21.9999L6.30688 15.4892L1.57422 10.8751L8.11127 9.92681L11.0352 4L13.9634 9.92681L20.5005 10.8751L15.7678 15.4892L16.8873 21.9999L11.0352 18.9268Z"
                                      stroke="#FFAC00" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="card-title font-weight-bold line-clamp-1">
                            <?php echo $post->post_title ?>
                        </div>
                    </div>
                    <div class="card-labels mb-3">
                        <?php if (!empty($meta['_teacher'][0])) { ?>
                            <div class="card-label">
                                <div>
                                    <svg width="17" height="18" viewBox="0 0 17 18" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M4.77734 4.57548C4.77734 3.62721 5.15404 2.7178 5.82457 2.04727C6.4951 1.37674 7.40454 1 8.35281 1C9.30108 1 10.2105 1.37674 10.881 2.04727C11.5516 2.7178 11.9283 3.62721 11.9283 4.57548C11.9283 6.54992 10.3272 8.70172 8.35281 8.70172C6.37837 8.70172 4.77734 6.54525 4.77734 4.57548Z"
                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                        <path d="M15.4996 17.0011C14.9768 14.4198 11.9801 11.9646 8.35329 11.9646C4.72648 11.9646 1.72515 14.4198 1.20703 17.0011"
                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"
                                              stroke-linecap="round"/>
                                    </svg>
                                </div>
                                <div class="text-label">
                                    مدرس:
                                </div>
                                <div>
                                    <?php echo $meta['_teacher'][0] ?? '' ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (!empty($meta['_time'][0])) { ?>
                            <div class="card-label">
                                <div>
                                    <svg width="17" height="16" viewBox="0 0 17 16" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.20703 15.0005C12.073 15.0005 15.207 11.8665 15.207 8.00049C15.207 4.13449 12.073 1.00049 8.20703 1.00049C4.34104 1.00049 1.20703 4.13449 1.20703 8.00049C1.20703 11.8665 4.34104 15.0005 8.20703 15.0005Z"
                                              stroke="#BBBBBB" stroke-width="2" stroke-miterlimit="10"/>
                                        <path d="M8.20703 4.15063V8.35063" stroke="#BBBBBB" stroke-width="2"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                        <path d="M10.5453 9.56132L8.31934 8.53931" stroke="#BBBBBB" stroke-width="2"
                                              stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div class="text-label">
                                    زمان:
                                </div>
                                <div>
                                    <?php echo $meta['_time'][0] ?? 0 ?>ساعت
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (!empty($meta['_participants'][0])) { ?>
                            <div class="card-label">
                                <div>
                                    <svg width="21" height="19" viewBox="0 0 21 19" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.01074 4.77124C6.01074 6.05121 6.99874 7.02124 8.13574 7.02124V9.02124C5.82096 9.02124 4.01074 7.08112 4.01074 4.77124H6.01074ZM8.13574 7.02124C9.27274 7.02124 10.2607 6.05121 10.2607 4.77124H12.2607C12.2607 7.08112 10.4505 9.02124 8.13574 9.02124V7.02124ZM10.2607 4.77124C10.2607 3.49127 9.27274 2.52124 8.13574 2.52124V0.52124C10.4505 0.52124 12.2607 2.46136 12.2607 4.77124H10.2607ZM8.13574 2.52124C6.99874 2.52124 6.01074 3.49127 6.01074 4.77124H4.01074C4.01074 2.46136 5.82096 0.52124 8.13574 0.52124V2.52124ZM11.2607 12.2712H5.01074V10.2712H11.2607V12.2712ZM5.01074 16.7712H11.2607V18.7712H5.01074V16.7712ZM11.2607 16.7712C12.3977 16.7712 13.3857 15.8012 13.3857 14.5212H15.3857C15.3857 16.8311 13.5755 18.7712 11.2607 18.7712V16.7712ZM2.88574 14.5212C2.88574 15.8012 3.87374 16.7712 5.01074 16.7712V18.7712C2.69596 18.7712 0.885743 16.8311 0.885743 14.5212H2.88574ZM5.01074 12.2712C3.87374 12.2712 2.88574 13.2413 2.88574 14.5212H0.885743C0.885743 12.2114 2.69596 10.2712 5.01074 10.2712V12.2712ZM11.2607 10.2712C13.5755 10.2712 15.3857 12.2114 15.3857 14.5212H13.3857C13.3857 13.2413 12.3977 12.2712 11.2607 12.2712V10.2712Z"
                                              fill="#BBBBBB"/>
                                        <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                              fill="#BBBBBB"/>
                                        <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                              fill="#BBBBBB"/>
                                        <path d="M12.5603 7.62978C12.7246 7.35529 13.0329 7.20874 13.3438 7.20874C14.6382 7.20874 15.6875 6.11743 15.6875 4.77124C15.6875 3.42505 14.6382 2.33374 13.3438 2.33374C13.0329 2.33374 12.7246 2.18719 12.5603 1.9127C12.553 1.90056 12.5457 1.88845 12.5383 1.87638C12.2648 1.42732 12.4034 0.791508 12.9115 0.733335C13.0534 0.717083 13.1976 0.70874 13.3438 0.70874C15.5011 0.70874 17.25 2.52758 17.25 4.77124C17.25 7.0149 15.5011 8.83374 13.3438 8.83374C13.1976 8.83374 13.0534 8.8254 12.9115 8.80915C12.4034 8.75097 12.2648 8.11516 12.5383 7.66611C12.5457 7.65403 12.553 7.64192 12.5603 7.62978Z"
                                              stroke="#BBBBBB" stroke-width="0.5"/>
                                        <path d="M15.7309 16.2187C15.8492 16.0135 16.0579 15.8754 16.2879 15.8754H16.4688C17.7632 15.8754 18.8125 14.7841 18.8125 13.4379C18.8125 12.0917 17.7632 11.0004 16.4688 11.0004H16.2879C16.0579 11.0004 15.8492 10.8623 15.7309 10.6571C15.4423 10.1563 15.7555 9.37541 16.317 9.37541H16.4688C18.6261 9.37541 20.375 11.1943 20.375 13.4379C20.375 15.6816 18.6261 17.5004 16.4688 17.5004H16.317C15.7555 17.5004 15.4423 16.7195 15.7309 16.2187Z"
                                              stroke="#BBBBBB" stroke-width="0.5"/>
                                    </svg>
                                </div>
                                <div class="text-label">
                                    شرکت‌کنندگان:
                                </div>
                                <div>
                                    <?php echo number_format($meta['_participants'][0] ?? 0) ?>
                                </div>
                            </div>
                        <?php } ?>
                        <?php if (!empty($meta['_execution'][0])) { ?>
                            <div class="card-label">
                                <div class="pb-1">
                                    <svg width="15" height="20" viewBox="0 0 15 20" fill="none"
                                         xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.39941 9.57519C8.54497 9.57519 9.47363 8.64654 9.47363 7.50098C9.47363 6.35542 8.54497 5.42676 7.39941 5.42676C6.25385 5.42676 5.3252 6.35542 5.3252 7.50098C5.3252 8.64654 6.25385 9.57519 7.39941 9.57519Z"
                                              stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                        <path d="M13.5004 7.56657C13.5022 6.61966 13.2836 5.6853 12.8619 4.83749C12.4402 3.98968 11.8269 3.25168 11.0706 2.6819C10.3143 2.11212 9.4357 1.72622 8.50444 1.55473C7.57318 1.38325 6.61479 1.4309 5.70514 1.6939C4.79548 1.9569 3.95953 2.42803 3.26346 3.07001C2.56739 3.71199 2.03033 4.50718 1.69476 5.39264C1.35919 6.27811 1.23435 7.22953 1.3301 8.1716C1.42586 9.11366 1.73959 10.0205 2.24646 10.8203L3.02737 12.0405L7.39959 18.548L11.7718 12.0405L12.5527 10.8203C13.1716 9.84793 13.5003 8.7192 13.5004 7.56657V7.56657Z"
                                              stroke="#BBBBBB" stroke-width="2" stroke-linecap="round"
                                              stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <div>
                                    <?php echo $meta['_execution'][0] ?? '' ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <a href="<?php echo get_permalink($post) ?>"
                       class="btn-card bg-yellow btn-register d-flex align-items-center justify-content-between py-2 px-3 mt-auto">
                        <div class="d-flex align-items-center">
                            <div class="me-1">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path d="M21.25 12C21.25 6.89137 17.1086 2.75 12 2.75C6.89137 2.75 2.75 6.89137 2.75 12C2.75 17.1086 6.89137 21.25 12 21.25C17.1086 21.25 21.25 17.1086 21.25 12Z"
                                          stroke="#1B1B1B" stroke-width="1.5"/>
                                    <path d="M9 12L11 14L15 10" stroke="#1B1B1B" stroke-width="1.5"
                                          stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <span class="font-weight-bold py-1">ثبت‌نام</span>
                        </div>
                        <div class="mr-auto">
                            <?php if (!empty($meta['_sale_price'][0])) { ?>
                                <div class="off-price text-sm">
                                    <?php echo number_format($meta['_regular_price'][0] ?? 0) ?>
                                </div>
                            <?php } ?>
                            <div class="d-flex align-items-center">
                                <span class="current-price text-xl font-weight-bold ml-1 ">
                                    <?php echo number_format($meta['_price'][0] ?? 0) ?>
                                </span>
                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M3.60288 1.63719L2.8437 0.78125L2.07261 1.59144L2.79879 2.39748L3.60288 1.63719ZM0.372938 2.01685L1.49673 2.514C1.45647 2.6587 1.41427 2.80037 1.37257 2.94032C1.28099 3.24769 1.19187 3.54682 1.13128 3.85185C0.979335 4.62655 1.31983 5.1273 2.0973 5.21437C2.567 5.2676 3.05306 5.23239 3.52581 5.18137C3.83081 5.1481 4.06289 4.9407 4.1006 4.60769C4.13471 4.30907 4.14524 4.00656 4.14968 3.70545C4.15514 3.32925 4.15534 2.95294 4.15554 2.57658V2.5762V2.5762V2.57619C4.15565 2.37959 4.15576 2.18297 4.15661 1.98635C4.16132 1.95891 4.16895 1.93205 4.17935 1.90622H5.37329C5.37329 2.19527 5.37911 2.48438 5.38493 2.77317C5.3982 3.43153 5.41143 4.08827 5.35554 4.73912C5.27763 5.64386 4.69009 6.22974 3.79366 6.36089C3.12155 6.45933 2.41256 6.50674 1.74627 6.40498C0.404547 6.20035 -0.315255 5.12952 -0.146673 3.74953C-0.115613 3.49151 -0.0618914 3.23673 0.0138685 2.98814C0.0809864 2.76986 0.164244 2.55625 0.253002 2.32853L0.253007 2.32852C0.292216 2.22792 0.332499 2.12457 0.372938 2.01685ZM0.42905 6.76642L0.429001 6.7664C0.318171 6.72224 0.204233 6.67685 0.0865058 6.62854C0.0865058 7.00028 0.0861867 7.36829 0.0858698 7.73368L0.0858698 7.73375C0.0851217 8.59638 0.0843863 9.44441 0.0878922 10.2924C0.0934376 11.6649 1.3664 12.4352 2.60332 11.8294C2.70785 11.7781 2.87116 11.7919 2.98845 11.8313C3.13364 11.8802 3.27556 11.9401 3.41735 11.9999L3.41738 11.9999C3.6108 12.0815 3.80399 12.163 4.00493 12.2164C4.82539 12.4346 5.54297 12.0875 5.75176 11.3411C5.85383 10.9712 5.8807 10.5847 5.83078 10.2043C5.73041 9.48279 5.37467 8.90717 4.6166 8.70116C3.89181 8.50429 3.26378 8.70476 2.80739 9.29341C2.59954 9.56171 2.46419 9.89439 2.3342 10.2139L2.31634 10.2578C2.14055 10.6903 1.99027 10.8331 1.63231 10.7613C1.31125 10.6974 1.32991 10.4668 1.34738 10.2508C1.35159 10.1988 1.35573 10.1475 1.35503 10.0997C1.34917 9.64433 1.34914 9.18873 1.3491 8.73306C1.34907 8.28288 1.34904 7.83262 1.34339 7.38244C1.34228 7.28207 1.27518 7.13068 1.1956 7.09241C0.95204 6.97477 0.699825 6.87429 0.42905 6.76642ZM4.66221 10.4542C4.67586 10.4957 4.68795 10.5325 4.69951 10.5619C4.68952 11.0474 4.56059 11.1406 4.18904 11.0314L4.17449 11.0271C4.10972 11.008 4.04488 10.9889 3.9822 10.9632C3.45011 10.7541 3.39216 10.3609 3.83829 9.98327C4.04375 9.80831 4.34543 9.82605 4.4921 10.0579C4.57481 10.1884 4.62444 10.3394 4.66221 10.4542ZM10.2552 10.2393C10.1625 10.238 10.0671 10.2366 9.96798 10.2366C9.96798 10.1769 9.96885 10.1175 9.96971 10.0583V10.0583V10.0582V10.0582C9.97157 9.93091 9.97341 9.80456 9.96659 9.67873C9.91973 8.79617 9.28561 8.05225 8.49372 7.94439C7.49581 7.80824 6.76519 8.21833 6.49929 9.12224C6.10307 10.4679 6.74884 11.4244 8.06838 11.471C8.19775 11.4755 8.327 11.4835 8.48073 11.4931L8.48086 11.4931L8.48124 11.4931C8.55733 11.4978 8.63943 11.503 8.73051 11.5082C8.36197 12.1395 7.80301 12.1927 7.2637 12.244C7.12702 12.257 6.99159 12.2699 6.86085 12.292V13.4976C7.64942 13.4682 8.39806 13.3917 9.07183 12.9855C9.6286 12.6494 9.88729 12.1218 9.98018 11.5024C10.089 11.4968 10.1952 11.4918 10.2995 11.4868L10.3002 11.4868H10.3002H10.3002C10.5415 11.4753 10.773 11.4642 11.0042 11.4491C11.7234 11.4017 12.3988 10.8965 12.4604 10.2588C12.5034 9.81244 12.4934 9.36105 12.4831 8.89918C12.4786 8.69369 12.474 8.48612 12.474 8.276L11.2373 8.6506C11.2373 8.77343 11.2366 8.893 11.2358 9.01029C11.2341 9.27401 11.2325 9.5262 11.2398 9.778C11.2482 10.0633 11.109 10.2147 10.8414 10.2324C10.651 10.245 10.4596 10.2423 10.2553 10.2393H10.2553H10.2553H10.2552H10.2552ZM8.70874 10.0289L8.70875 10.0289L8.70875 10.0289C8.71491 10.1021 8.72126 10.1774 8.72968 10.2555H8.73079C8.64254 10.2555 8.56184 10.2569 8.48631 10.2582H8.48626H8.48622H8.48618H8.48614H8.48612C8.33317 10.2608 8.20142 10.2631 8.07115 10.2527C7.74009 10.2263 7.59341 10.0797 7.58981 9.79962C7.58509 9.45719 7.77003 9.18934 8.0437 9.14165C8.32181 9.09341 8.57524 9.2509 8.64649 9.55396C8.68144 9.70475 8.69461 9.86105 8.70874 10.0289ZM9.58645 6.12429L9.62553 6.16131C9.85149 6.37539 10.0913 6.60264 10.3498 6.84797L9.56455 7.57942L8.90297 6.82856L9.58645 6.12429ZM10.4041 6.8556C10.6576 7.09683 10.9032 7.33112 11.1708 7.58649L11.9164 6.83314L11.1708 6.12859L10.4041 6.8556Z"
                                          fill="black"/>
                                </svg>
                            </div>
                        </div>
                    </a>
                </div>
            <?php } ?>
        </div>
    </div>
</section>
