<?php
/**
 * Title: login
 * Slug: modiram/login
 * Categories: [mdr-header]
 * Post Types: ["post", "page"].
 */

global $theme_settings;

if (is_front_page() && is_user_logged_in()) {
    wp_redirect(get_site_url());
    die();
}

?>
<div id="all_loading" style="display: none">
    <div class="spinner-border" role="status" style="width: 4rem; height: 4rem;">
        <span class="visually-hidden"></span>
    </div>
</div>
<div class="container text-center">
    <div class="row justify-content-center">
        <div class="col col-md-8 col-11 col-lg-5 col-sm-10 bg-body p-3 rounded-5">
            <div class="pt-5">
                <img src="<?php echo $theme_settings['information']['logo']['link-main-desktop'] ?? ''; ?>"
                     class="w-50 pb-5"/>
                <p class="fs-5 fw-bold pb-3">
                    ورود به حساب کاربری
                </p>
                <p id="notification"
                   style="background-color: #ffffff;text-align: center;color: #de0000;margin: 13px 57px 0 57px;border-radius: 3px;padding: 3px 0px;font-size: 13px;display: none;">
                    کد اشتباه</p>
                <input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo wp_create_nonce('wp_rest') ?>">
                <form id="otp_send" method="post">
                    <label for="phone-number" class="w-100 text-start text-xs">
                        شماره همراهی که با آن ثبت نام کرده اید را وارد کنید:
                    </label>
                    <div class="input-group mb-3">
                        <span class="input-group-text bg-gray">
                            <img src="/wp-content/themes/modiram/assets/images/phone.svg"/>
                        </span>
                        <input id="phone-number" type="text" class="form-control fs-6 text-start border-end-0"
                               placeholder="شماره تلفن همراه">
                        <span class="input-group-text bg-white">
                            <img src="/wp-content/themes/modiram/assets/images/iran.svg"/>
                        </span>
                    </div>
                    <p class="text-xs text-gray text-start opacity-75 pb-4">
                        توجه: در صورتی که خارج از ایران تشریف دارید ابتدای شماره تماس خود 00
                        و سپس پیش شماره کشورتان را باید بگزارید.
                    </p>

                    <div class="row pt-10 justify-content-around">
                        <button class="col-5 btn btn-secondary" type="button" onclick="submitForm('sms')">
                            <span class="row align-items-center">
                                <span class="col-2">
                                    <img src="/wp-content/themes/modiram/assets/images/email.svg"
                                         style="width: 20px;"/>
                                </span>
                            <span class="col text-xs p-0"> دریافت کد با پیامک </span>
                            </span>
                        </button>
                    </div>
                </form>
                <form id="otp_verify" style="display:none;">
                    <div class="input-group pb-5">
                        <span class="input-group-text text-xs text-box-shadow text-gray cursor_pointer" onclick="back_to_otp_send()">
                            اصلاح شماره
                        </span>
                        <input id="phone_number_display" type="text" class="form-control fs-6 text-start border-end-0"
                               placeholder="شماره تلفن همراه" disabled>
                        <span class="input-group-text bg-white">
                            <img src="/wp-content/themes/modiram/assets/images/iran.svg"/>
                        </span>
                    </div>
                    <div class="mb-3">
                        <label for="otp-code-input" class="w-100 text-start text-xs">
                            کد دریافتی را اینجا وارد کنید:
                        </label>
                        <input id="otp-code-input" type="text" class="form-control fs-6 text-center">
                    </div>
                    <p id="note_resend_otp" class="text-center text-xs pt-4">
                        کد را دریافت نکرده اید؟ <span id="otp_resend_time"></span> ثانیه برای دریافت مجدد کد صبر کنید.
                    </p>
                    <p class="fw-bold">
                        <a href="#" id="resend_otp" class="pt-2" style="display: none;"
                           onclick="back_to_otp_send()">دریافت مجدد کد</a>
                    </p>
                    <div class="row pt-10 justify-content-around">
                        <button class="col-5 btn btn-secondary" type="button" onclick="submitVerifyForm()">
                            <span class="row align-items-center">
                            <span class="col text-xs p-0"> تایید کد و ورود </span>
                                <span class="col-2">
                                    <img src="/wp-content/themes/modiram/assets/images/arrow-left.svg"
                                         style="width: 7px;"/>
                                </span>
                            </span>
                        </button>
                    </div>
                </form>
                <form id="register" style="display:none;">
                    <div class="pb-5">
                        <label for="name" class="w-100 text-start text-xs">
                            نام کامل خود را لطفا وارد نمایید:
                        </label>
                        <input id="full_name" type="text" class="form-control fs-6 text-start"
                               placeholder="نام کامل">
                    </div>
                    <div class="row pt-10 justify-content-around">
                        <button class="col-5 btn btn-secondary" type="button" onclick="registerForm()">
                            <span class="row align-items-center">
                            <span class="col text-xs p-0"> ورود </span>
                                <span class="col-2">
                                    <img src="/wp-content/themes/modiram/assets/images/arrow-left.svg"
                                         style="width: 7px;"/>
                                </span>
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
