<?php

namespace Mdr\Theme;

class Settings
{
    public function __construct()
    {
        global $theme_settings;

        $file = file_get_contents(__DIR__ . '/settings.json');

        if (file_exists(__DIR__ . '/settings.json') && !empty($file)) {
            $this->settings = json_decode($file, true);
        } else {
            wp_die('تنظیمات قابل دسترس نیست.');
        }

        $theme_settings = $this->settings;

    }

    public static function flow()
    {

        if (is_admin() && (current_user_can('subscriber') || current_user_can('customer'))
            && !(defined('DOING_AJAX') && DOING_AJAX)) {
            wp_redirect(home_url());
        }

        $instance = new self();
        add_action('after_setup_theme', $instance->widgets());
        add_action('after_setup_theme', $instance->register_menus());
        $instance->enqueue_block_styles();

        if (is_admin()) return;

        $instance->payment_verify();
        $instance->enqueue_scripts();
        $instance->admin_access();
        add_shortcode('mdr_show_block', ['Mdr\Theme\Settings', 'show_block_shortcode']);


    }

    public static function show_block_shortcode($attribute)
    {
        $default = array(
            'slug' => '',
        );
        $params = shortcode_atts($default, $attribute);

        if (!isset($params['slug']) || empty($params['slug'])) return;

        $block = '<!-- wp:pattern {"slug":"'. $params['slug']. '"} /-->';
        $parse_blocks = parse_blocks($block);
        echo render_block($parse_blocks[0]);
    }

    public function admin_access()
    {

        if (current_user_can('subscriber') || current_user_can('customer')) {
            add_filter('show_admin_bar', '__return_false');
        }

    }

    public static function admin_flow()
    {
        $instance = new self();
        $instance->enqueue_admin_styles();
        $instance->enqueue_admin_scripts();
        $instance->block_actions();
    }

    private function register_menus()
    {
        $menu_locations = $this->get_settings('menu,locations');
        register_nav_menus($menu_locations);
        return true;
    }

    private function payment_verify()
    {

        if (!is_admin() && isset($_GET['tra']) && isset($_GET['sign'])) {
            $verify = new \Mdr\Services\MdrPay();
            $verify->verify($_GET['tra'], $_GET['sign']);
        }

    }

    private function widgets()
    {
        add_theme_support('widgets');
        return true;
    }

    private function block_actions()
    {
        $pattern_categories = $this->get_settings('block,pattern_categories');

        if (!empty($pattern_categories)) {

            foreach ($pattern_categories as $name => $category) {
                register_block_pattern_category(
                    $name,
                    array(
                        'label' => $category['label'],
                        'description' => $category['description'],
                    )
                );
            }

        }

        $patterns = $this->get_settings('block,patterns');

        if (!empty($patterns)) {

            foreach ($patterns as $slug => $pattern) {
                register_block_pattern($pattern['name'], [
                    'title' => $pattern['name'],
                    'content' => '<!-- wp:pattern {"slug":"' . $slug . '", "templateLock":"all","lock":{"move":true,"remove":true}} /-->',
                    'slug' => $slug,
                    'categories' => $pattern['categories'] ?? [],
                    'postTypes' => $pattern['postTypes'] ?? [],
                ]);
            }

        }

    }

    private function enqueue_admin_scripts()
    {
        $admin_scripts = $this->get_settings('enqueue,admin,scripts');

        if (!empty($admin_scripts)) {

            foreach ($admin_scripts as $handle => $script) {
                wp_enqueue_script($handle, $script['src'], $script['deps'], $script['ver'], $script['args']);
            }

            wp_localize_script('theme_panel_scripts', 'MDRVars', [
                'wpnonce' => wp_create_nonce('wp_rest'),
                'api_key' => substr(NONCE_KEY, 0, 24),
                'rest_url' => esc_html(rest_url()),
                'url' => get_site_url(),
            ]);

        }

    }

    private function enqueue_admin_styles(): void
    {
        add_action('admin_enqueue_scripts', function () {
            $admin_styles = $this->get_settings('enqueue,admin,styles');

            if (!empty($admin_styles)) {

                foreach ($admin_styles as $handle => $style) {
                    wp_register_style($handle, $style['src'], false, $style['ver']);
                    wp_enqueue_style($handle);
                }

            }

        });
    }

    private function enqueue_scripts()
    {

        if (!is_admin()) {
            $front_scripts = $this->get_settings('enqueue,front,scripts');

            if (!empty($front_scripts)) {

                foreach ($front_scripts as $handle => $script) {
                    wp_enqueue_script($handle, $script['src'], $script['deps'], $script['ver'], $script['args']);
                }

                wp_localize_script('global', 'MDRVars', [
                    'wpnonce' => wp_create_nonce('wp_rest'),
                    'api_key' => substr(NONCE_KEY, 0, 24),
                    'rest_url' => esc_html(rest_url()),
                    'url' => get_site_url(),
                ]);

            }

            add_action('wp_enqueue_scripts', function () {
                //woocommerce
                wp_deregister_script('jquery-blockui');
                wp_deregister_script('wp-block-template-skip-link');
                wp_deregister_script('wc-order-attribution');
                wp_deregister_script('wc-order-attribution-js-extra');
                wp_deregister_script('sourcebuster-js');
                wp_dequeue_style('wc-block-vendors-style');
                wp_dequeue_style('wc-block-style');
                wp_dequeue_style('wc-blocks-style');
                wp_dequeue_style('woocommerce-general');
                wp_dequeue_style('woocommerce-layout');
                wp_dequeue_style('woocommerce-smallscreen');
                wp_dequeue_style('woocommerce-blocktheme');

                wp_dequeue_style('wp-fonts');
            }, 99);

        } else {
            $admin_scripts = $this->get_settings('enqueue,admin,scripts');

            if (!empty($admin_scripts)) {

                foreach ($admin_scripts as $handle => $script) {
                    wp_enqueue_script($handle, $script['src'], $script['deps'], $script['ver'], $script['args']);
                }

                wp_localize_script('theme_panel_scripts', 'MDRVars', [
                    'wpnonce' => wp_create_nonce('wp_rest'),
                    'api_key' => substr(NONCE_KEY, 0, 24),
                    'rest_url' => esc_html(rest_url()),
                    'url' => get_site_url(),
                ]);

            }

        }

    }

    private function enqueue_block_styles(): void
    {

        $front_styles = $this->get_settings('enqueue,front,styles');

        if (!empty($front_styles)) {

            foreach ($front_styles as $handle => $style) {
                wp_enqueue_block_style(
                    'core/' . $handle,
                    array(
                        'handle' => $handle,
                        'src' => $style['src'],
                        'ver' => $style['ver'],
                    )
                );
            }

        }

        if (!is_admin()) {
            remove_action('wp_head', 'print_emoji_detection_script', 7);
            remove_action('wp_print_styles', 'print_emoji_styles');

            add_action('wp_print_styles', function () {
                //wordpress
                wp_dequeue_style('wp-block-library');
                wp_deregister_style('global-styles');
                wp_deregister_style('wp-block-template-skip-link');

                //woocommerce
                wp_deregister_style('woocommerce-inline');
            }, 99);
        }

    }

    public function add_settings($key, $value)
    {
        $keys = explode(',', $key, 3);

        if (isset($keys[2])) {
            $this->settings[$keys[0]][$keys[1]][$keys[2]] = $value;
        } elseif (isset($keys[1])) {
            $this->settings[$keys[0]][$keys[1]] = $value;
        } elseif (isset($keys[0])) {
            $this->settings[$keys[0]] = $value;
        }

        return $this->save_settings();
    }

    public function get_settings($key = null)
    {

        if ($key) {
            $keys = explode(',', $key, 3);

            if (isset($keys[2])) {
                $result = $this->settings[$keys[0]][$keys[1]][$keys[2]] ?? [];
            } elseif (isset($keys[1])) {
                $result = $this->settings[$keys[0]][$keys[1]] ?? [];
            } elseif (isset($keys[0])) {
                $result = $this->settings[$keys[0]] ?? [];
            }

            return $result;
        }

        return $this->settings;
    }

    public function save_settings(): false|int
    {
        $check_array = array_keys($this->settings);

        if (!in_array('version', $check_array) || !in_array('site_name', $check_array) ||
            !in_array('installed', $check_array) || !in_array('database', $check_array) ||
            !in_array('menu', $check_array) || !in_array('gateways', $check_array) ||
            !in_array('payment', $check_array) || !in_array('information', $check_array) ||
            !in_array('social', $check_array) || !in_array('pages', $check_array) ||
            !in_array('addOns', $check_array) || !in_array('enqueue', $check_array) ||
            !in_array('enqueue', $check_array) || !in_array('notification', $check_array)) {
            return false;
        }

        return file_put_contents(__DIR__ . '/settings.json', json_encode($this->settings, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }

    public array $settings = [];
}