<?php

namespace Mdr\Theme;

use Mdr\Services\DBAccess;

class Install
{
    public function __construct()
    {
        $this->_settings = new Settings();
    }

    public static function install()
    {
        $install = new self();

        if ($install->_settings->get_settings('installed')) {
            return;
        }

        $install->check_tables();

        $pages = $install->_settings->get_settings('pages');

        if (!empty($pages)) {

            foreach ($pages as $page) {
                $install->create_page($page['title'], $page['name'], $page['post_type'], $page['template']);
            }

        }

        $install->_settings->add_settings('installed', true);

        flush_rewrite_rules();

    }

    private function check_tables()
    {

        if ($this->_settings->get_settings('database,inserted')) {
            return;
        }

        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();
        $table_name = $wpdb->prefix . "mdr_transactions";

        $sql = "CREATE TABLE `$table_name` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `order_id` bigint(20) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `products` text DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `utm` text DEFAULT NULL,
  `landing_url` text DEFAULT NULL,
  `callback` text DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `amount` bigint(20) NOT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `gateway` varchar(255) NOT NULL,
  `card_number` varchar(255) DEFAULT NULL,
  `authority` bigint(20) DEFAULT NULL,
  `paid_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) $charset_collate";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        $table_name = $wpdb->prefix . "mdr_gateways";

        $sql = "CREATE TABLE `$table_name` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `class` varchar(555) NOT NULL,
  `merchant` bigint(20) DEFAULT NULL,
  `active` int NOT NULL DEFAULT 1,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`)
) $charset_collate";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        $this->_settings->add_settings('database,inserted', true);
        $this->_settings->add_settings('database,version', '1.0.0');

    }

    public function create_page(string $title, string $name, string $post_type, string $template, string $content = '', int $parent_id = NULL)
    {
        global $wpdb;

        $post_tb = new DBAccess($wpdb->prefix. 'posts');
        $post = $post_tb->get_row([
            'post_title' => $title,
            'post_type' => $post_type,
            'post_status' => 'publish',
        ]);

        if (!empty($post)) return;

        $page_id = wp_insert_post(
            array(
                'comment_status' => 'close',
                'ping_status' => 'close',
                'post_author' => 1,
                'post_title' => $title,
                'post_name' => strtolower(str_replace(' ', '-', trim($name))),
                'post_status' => 'publish',
                'post_content' => $content,
                'post_type' => $post_type,
                'post_parent' => $parent_id
            )
        );

        update_post_meta($page_id, '_wp_page_template', $template);
    }

    public $_settings;
}