<?php
namespace Mdr\Services;
class SendMessage
{
    /**
     * @param  string  $phone
     * @param  string  $text
     * @param  array  $data
     * @param  string  $time
     */
    public function __construct(string $phone, string $text = '', array $data = [], string $time = '')
    {
        global $theme_settings;

        $this->theme_setting = $theme_settings;
        $this->set_gateway($this->theme_setting['message_sms']['default']);
        $this->set_phone($phone);
        $this->set_text($text);
        $this->set_time($time);
        $this->set_data($data);
    }

    /**
     * @param  string  $phone
     *
     * @return void
     */
    public function set_phone(string $phone)
    {
        $phone = $this->sanitize_mobile($phone);

        if ($this->is_phone($phone)) {
            $this->phone = $phone;
        } else {
            $this->set_error(['شماره همراه '.$phone.' معتبر نمی باشد.']);
        }
    }

    /**
     * @param  string  $text
     *
     * @return void
     */
    public function set_text(string $text)
    {
        $this->text = $text;
    }

    public function set_pattern_code(string $pattern_code)
    {
        $this->text = $pattern_code;
    }

    /**
     * @param  string  $time
     *
     * @return void
     */
    public function set_time(string $time)
    {
        $this->time = $time;
    }

    /**
     * @param  array  $data
     *
     * @return void
     */
    public function set_data(array $data)
    {
        $this->data = $data;
    }

    /**
     * @param  string  $gateway
     *
     * @return void
     */
    public function set_gateway(string $gateway)
    {
        $this->gateway = $gateway;
    }

    /**
     * @param  string  $gateway
     *
     * @return void
     */
    public function set_whatsapp_gateway(string $gateway): void
    {
        $this->whatsapp_gateway = $gateway;
    }

    /**
     * @param  bool  $whatsApp_subMessage
     *
     * @return void
     */
    public function set_whatsApp_subMessage(bool $whatsApp_subMessage)
    {
        $this->whatsApp_subMessage = $whatsApp_subMessage;
    }

    /**
     * @param  bool  $sms_subMessage
     *
     * @return void
     */
    public function set_sms_subMessage(bool $sms_subMessage)
    {
        $this->sms_subMessage = $sms_subMessage;
    }

    /**
     * @param  array  $error
     *
     * @return void
     */
    private function set_error(array $error)
    {
        $this->result['errors'][] = $error;
    }

    public function sendSMS()
    {

        if ($this->gateway == 'FarazSMS') {
            return $this->farazSMS();
        } elseif ($this->gateway == 'KaveNegar') {
            return $this->KaveNegar();
        }

    }

    public function send_pattern_sms($pattern_code, $data)
    {

        if ( ! $pattern_code) {
            return [
                'success' => false,
                'message' => 'کد پترن ضروری می باشد.'
            ];
        }

        if ( ! $data) {
            return [
                'success' => false,
                'message' => 'داده های ارسالی ضروری می باشد.'
            ];
        }

        $this->pattern_code = $pattern_code;
        $this->data         = $data;

        if ($this->gateway == 'FarazSMS') {
            return $this->faraz_pattern_sms();
        }

    }

    /**
     * @param  string  $type
     * @param  string  $link_url
     *
     * @return array
     */
    public function sendWhatsApp(string $type = 'text', string $link_url = '', $caption = ''): array
    {

        if ($type == 'text') {
            $response = $this->whatsAppSendText();
        } elseif ($type == 'image') {
            $response = $this->whatsAppSendImage($link_url, $caption);
        } elseif ($type == 'video') {
            $response = $this->whatsAppSendVideo($link_url, $caption);
        } else {
            $response = false;
        }

        return $response;
    }

    private function farazSMS()
    {

        if ( ! $this->phone || ! $this->text) {
            return false;
        }

        if ($this->sms_subMessage) {
            $sms_text = $this->text."\n".'لغو11';
        }

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL            => 'http://rest.ippanel.com/v1/messages',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 5,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => [
                'originator' => $this->theme_setting['message_sms']['FarazSMS']['number'],
                'recipients' => $this->phone,
                'message'    => $sms_text,
            ],
            CURLOPT_HTTPHEADER     => [
                'Authorization: AccessKey  '. $this->theme_setting['message_sms']['FarazSMS']['AccessKey'],
            ],
        ]);

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $this->set_error(['curl_error' => curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    private function faraz_pattern_sms()
    {
        if ( ! $this->phone) {
            return [
                'success' => false,
                'message' => 'موبایل موجود نیست.'
            ];
        }

        if ( ! $this->pattern_code) {
            return [
                'success' => false,
                'message' => 'کد پترن ضروری میباشد'
            ];
        }

        if ($this->sms_subMessage) {
            $sms_text = $this->text."\n".'لغو11';
        }

        $parameter = [
            'code'      => $this->pattern_code,
            'sender'    => $this->theme_setting['message_sms']['FarazSMS']['number'],
            'recipient' => $this->phone,
        ];

        foreach ($this->data as $key => $value) {
            $parameter['variable['.$key.']'] = $value;
        }

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL            => 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => $parameter,
            CURLOPT_HTTPHEADER     => array(
                'Accept: application/json',
                'apikey: '. $this->theme_setting['notification']['FarazSMS']['AccessKey'],
                'Cookie: TS0177e476=0150a3e24e88bef84585a4bc9ff13b3032ae65923a583a3c265adda2d95edf0d7ae96d1de81a8bcaaed76465260c4b2c8facfe03c1'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $this->set_error(['curl_error' => curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    private function KaveNegar()
    {

        if ($this->sms_subMessage) {
            $sms_text = $this->text."\n".'لغو11';
        }

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL            => 'https://api.kavenegar.com/v1/4F6A4B6F4F394D63526879394962382B626134472B774354324B343951524E4530306D584641635156446F3D/verify/lookup.json',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 5,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => [
                'receptor' => $this->phone,
                'token'    => $this->data['body'][0],
                'token2'   => $this->data['body'][1],
                'template' => $this->data['template'],
            ],
            CURLOPT_HTTPHEADER     => [
                'Cookie: cookiesession1=678A8C31OQSUWYACEGIKMOQSVWXY631F',
            ],
        ]);

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $this->set_error(['curl_error' => curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    private function whatsAppSendText()
    {

        $text = $this->text;

        if ($this->whatsApp_subMessage) {
            $text = $this->text."\n".'این پیام توسط ربات برای شما ارسال شده در صورت داشتن هرگونه سوال یا ابهامی با شماره 91007787-021 تماس بگیرید.';
        }

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL            => 'https://bot.modiram.com/wp-json/jet_wa_api/v1/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => [
                'key'      => '',
                'phone'    => $this->phone,
                'text'     => $text,
                'priority' => '0',
                'gateway'  => $this->whatsapp_gateway,
            ],
            CURLOPT_HTTPHEADER     => [
                'Cookie: PHPSESSID=b23dc8ef4402875cac1e8f5ef6949858',
            ],
        ]);

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            $this->set_error([curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    /**
     * @param  string  $image_url
     * @param  string  $caption
     *
     * @return array
     */
    private function whatsAppSendImage(string $image_url, string $caption = ''): array
    {
        $data = [
            'key'      => '',
            'phone'    => $this->phone,
            'link'     => $image_url,
            'caption'  => $caption,
            'priority' => 1,
            'gateway'  => $this->whatsapp_gateway,
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL            => 'https://bot.modiram.com/wp-json/jet_wa_api/v1/send/image',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 5,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => $data,
            CURLOPT_HTTPHEADER     => array(
                'Cookie: PHPSESSID=3564cd1aef33930a7f819e2fe8070010'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $this->set_error([curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    /**
     * @param  string  $video_url
     * @param  string  $caption
     *
     * @return array
     */
    private function whatsAppSendVideo(string $video_url, string $caption = ''): array
    {
        $data = [
            'key'      => '',
            'phone'    => $this->phone,
            'link'     => $video_url,
            'caption'  => $caption,
            'priority' => 1,
            'gateway'  => $this->whatsapp_gateway,
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL            => 'https://bot.modiram.com/wp-json/jet_wa_api/v1/send/video',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 5,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => $data,
            CURLOPT_HTTPHEADER     => array(
                'Cookie: PHPSESSID=3564cd1aef33930a7f819e2fe8070010'
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $this->set_error([curl_error($curl)]);
            $success = false;
        } else {
            $success = true;
        }
        curl_close($curl);

        return [
            'success'  => $success,
            'response' => $response,
        ];
    }

    /**
     * @param  string  $string
     *
     * @return string
     */
    private function convert_persian_to_english_number(string $string): string
    {

        $persian = [
            '۰',
            '۱',
            '۲',
            '۳',
            '۴',
            '۵',
            '۶',
            '۷',
            '۸',
            '۹',
            '٠',
            '١',
            '٢',
            '٣',
            '٤',
            '٥',
            '٦',
            '٧',
            '٨',
            '٩',
        ];
        $english = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9];

        return str_replace($persian, $english, $string);
    }

    /**
     * @param  string  $phone
     *
     * @return string
     */
    public function sanitize_mobile(string $phone): string
    {
        $phone = trim($phone);
        $phone = $this->convert_persian_to_english_number($phone);
        $phone = str_replace(['+98', ' '], ['', ''], $phone);

        if (preg_match('/([^+]\d{5,}$)/', $phone)) {
            $phone = str_replace(['+'], ['00'], $phone);
        }

        if (preg_match('/(^009809\d{9}$)/', $phone)) {
            $phone = substr($phone, 5);
        }

        if (preg_match('/(^0098\d{10}$)/', $phone)) {
            $phone = substr($phone, 4);
        }

        if (preg_match('/(^9809\d{10}$)/', $phone)) {
            $phone = substr($phone, 4);
        }

        if (preg_match('/(^98\d{10}$)/', $phone)) {
            $phone = substr($phone, 2);
        }

        if (preg_match('/(^9\d{9}$)/', $phone)) {
            $phone = 0 .$phone;
        }

        return $phone;
    }

    /**
     * @param  string  $phone
     *
     * @return string
     */
    private function is_phone(string $phone): string
    {
        $phone = $this->sanitize_mobile($phone);

        if (preg_match('/(^09\d{9}$)/', $phone)) {
            return 'IR';
        }

        if (preg_match('/(^00[^0]\d{5,}$)/', $phone)) {
            return 'other';
        }

        return false;
    }

    public array $theme_setting = [];
    public string $phone;
    public string $text;
    public string $time;
    public bool $whatsApp_subMessage = true;
    public array $data;
    public string $pattern_code;
    public array $result;
    private string $gateway;
    private string $whatsapp_gateway = 'external';
    public $sms_subMessage = true;
}