<?php
namespace Mdr\Services;

class DBAccess
{
    function __construct( string $table_name ) {
        $this->table = $table_name;
    }

    public function set_dh_host( $DB_HOST ) {
        $this->DB_HOST = $DB_HOST;
    }

    public function set_dh_user( $DB_USER ) {
        $this->DB_USER = $DB_USER;
    }

    public function set_dh_pass( $DB_PASSWORD ) {
        $this->DB_PASSWORD = $DB_PASSWORD;
    }

    public function set_dh_name( $DB_NAME ) {
        $this->DB_NAME = $DB_NAME;
    }

    public function set_dh_charset( $DB_CHARSET ) {
        $this->DB_CHARSET = $DB_CHARSET;
    }

    /*
     * Connecting to database
     *
     * if you want to change parameters import variable value.
     */
    public function DB_connection(
        $db_user = null,
        $db_pass = null,
        $db_name = null,
        $dh_charset = null,
        $db_host = null
    ) {
            isset( $db_user ) ?? $this->set_dh_host( $db_host );
            isset( $db_user ) ?? $this->set_dh_user( $db_user );
            isset( $db_pass ) ?? $this->set_dh_pass( $db_pass );
            isset( $db_name ) ?? $this->set_dh_name( $db_name );
            isset( $dh_charset ) ?? $this->set_dh_charset( $dh_charset );

        $this->connection = new \mysqli( $this->DB_HOST, $this->DB_USER, $this->DB_PASSWORD, $this->DB_NAME );
        $this->connection->set_charset( $this->DB_CHARSET );

        if ( $this->connection->connect_error ) {
            die( "Database Connection failed!" );
        }

        return $this->connection;
    }

    /*
     * using specific query
     * @return first result from query
     */
    public function query( $query ) {
        $this->connection  = $this->DB_connection();
        $result            = $this->connection->query( $query );
        $this->sql_results = $result;
        $this->connection->close();

        return $result;
    }


    public function get_sql() {

        if ( $this->sql_results->num_rows > 0 ) {
            $result = $this->sql_results->fetch_all( MYSQLI_ASSOC );
        } else {
            $result = false;
        }

        return $result;
    }

    /*
    * insert data in table
    */
    function insert( array $details ) {
        $this->connection = $this->DB_connection();

        $columns       = '';
        $values        = '';
        $details_count = count( $details );
        $i             = 0;

        foreach ( $details as $column => $value ) {
            $i ++;

            $columns .= ' ' . $column;
            $values  .= " '" . $value . "'";

            if ( $i < $details_count ) {
                $columns .= ',';
                $values  .= ',';
            }

        }

        $sql = "INSERT INTO  " . $this->table . "  ( {$columns} ) VALUES ({$values})";
        $this->connection->query( $sql );
        $result = $this->connection->insert_id;
        $this->connection->close();

        if ( $result == 0 ) {
            $result = false;
        }

        return $result;

    }

    /*
    * get count of table
    */
    function count( array $where = null ) {
        $connection = $this->DB_connection();

        if ( $where ) {
            $where_query = $this->make_query( $where, 'where' );
        }

        $sql    = "SELECT count(1) FROM " . $this->table . " {$where_query} ";
        $result = $connection->query( $sql );
        $connection->close();

        if ( isset($result->num_rows) && $result->num_rows > 0 ) {
            $result = $result->fetch_assoc()["count(1)"];

            if ( $result == 0 ) {
                $result = false;
            }

        } else {
            $result = false;
        }

        return $result;

    }

    /*
     * update row
     * $where is array of many column => value
     * $details is array that want to update many column => value
     */
    function update( array $where, array $details ) {
        $connection = $this->DB_connection();

        if ( $where ) {
            $where_query = $this->make_query( $where, 'where' );
        }

        $update = $this->make_query( $details, 'update' );

        $sql    = "UPDATE " . $this->table . " SET " . $update . $where_query;
        $result = $connection->query( $sql );
        $result = $connection->query( $sql );
        $connection->close();

        return $result;
    }

    /*
     * get row
     * $where is column => value
     */
    function get_row( array $where ) {
        $connection = $this->DB_connection();

        if ( $where ) {
            $where_query = $this->make_query( $where, 'where' );
        }

        $sql    = "SELECT * FROM " . $this->table . " {$where_query} ";
        $result = $connection->query( $sql );
        $connection->close();

        if ( isset($result->num_rows) && $result->num_rows > 0 ) {
            $result = $result->fetch_assoc();
        } else {
            $result = false;
        }

        return $result;
    }

    /*
     * get all
     * $where is column => value
     */
    function get_all( array $where = [], array $order_by = [], int $page = 0, int $count = 10 ) {
        $connection  = $this->DB_connection();
        $where_query = '';

        if ( $where ) {
            $where_query = $this->make_query( $where, 'where' );
        }

        $sql = "SELECT * FROM " . $this->table . " {$where_query} ";

        if ( ! empty( $order_by ) ) {
            $key = key( $order_by );
            $sql .= "ORDER BY `{$key}` {$order_by[$key]}";
        }

        if ( $page > 1 ) {
            $offset = ( $page - 1 ) * $count;
            $sql    .= " LIMIT {$offset}, {$count}";
        } elseif ( $page == 1 ) {
            $sql .= " LIMIT {$count}";
        }

        $result = $connection->query( $sql );
        $connection->close();

        if ( isset($result->num_rows) && $result->num_rows > 0 ) {
            $result = $result->fetch_all( MYSQLI_ASSOC );
        } else {
            $result = false;
        }

        return $result;
    }

    /*
     * get all value by all where set
     * $where is [
     *              [
     *                  'column' => $column,
     *                  'compare' => $compare,
     *                  'value' => $value
     *              ],
     * 	            [
     *                  'column' => $column,
     *                  'compare' => $compare,
     *                  'value' => $value
     *              ],
     *              ...
     *           ]
     */
    function get_all_value( array $where, $order_by = [] ) {
        $connection = $this->DB_connection();

        if ( $where ) {
            $where_query = $this->make_query( $where, 'where_all' );
        }

        $sql = "SELECT * FROM " . $this->table . " {$where_query} ";

        if ( ! empty( $order_by ) ) {
            $key = key( $order_by );
            $sql .= "ORDER BY `{$key}` {$order_by[$key]}";
        }

        $result = $connection->query( $sql );
        $connection->close();

        if ( isset($result->num_rows) && $result->num_rows > 0 ) {
            $result = $result->fetch_all( MYSQLI_ASSOC );
        } else {
            $result = false;
        }

        return $result;
    }

    //make some query
    private function make_query( array $parameters, string $set ): string {
        if ( $set == 'where' ) {
            $where_query = ' WHERE ';
            $i           = 0;

            foreach ( $parameters as $column => $value ) {
                $i ++;

                if ( $i != 1 ) {
                    $where_query .= 'AND ';
                }

                if ( $column == 'query' ) {
                    $l = 0;

                    foreach ( $value as $each ) {
                        $l ++;

                        if ( $l != 1 ) {
                            $where_query .= 'AND ';
                        }

                        if ( strpos( $each['compare'], 'IN' ) === false && strpos( $each['compare'], 'IS' ) === false  ) {
                            $value = ( $each['value'] ) ? " '" . $each['value'] . "' " : '';
                        } else {
                            $value = ( $each['value'] ) ? " " . $each['value'] . " " : '';
                        }

                        $where_query .= $each['column'] . " " . $each['compare'] . $value;

                    }

                } else {
                    $where_query .= $column . " = '" . $value . "' ";
                }

            }

            return $where_query;
        } elseif ( $set == 'update' ) {
            $update = '';
            $i      = 0;

            foreach ( $parameters as $column => $value ) {
                $i ++;
                $separator = ', ';

                if ( $i == 1 ) {
                    $separator = '';
                }

                $update .= $separator . $column . ' = ' . "'" . $value . "' ";
            }

            return $update;
        } elseif ( $set == 'where_all' ) {
            $where_query = ' WHERE ';
            $i           = 0;

            foreach ( $parameters as $part ) {
                $i ++;

                if ( $i != 1 ) {
                    $where_query .= 'AND ';
                }

                $where_query .= $part['column'] . ' ' . $part['compare'] . " '" . $part['value'] . "' ";
            }

            return $where_query;
        }

        return '';
    }

    public $sql_results;
    private
        $connection;
    private
    string
        $DB_HOST = DB_HOST,
        $DB_USER = DB_USER,
        $DB_PASSWORD = DB_PASSWORD,
        $DB_NAME = DB_NAME,
        $DB_CHARSET = DB_CHARSET,
        $table;
}