<?php

use Mdr\Services\MdrPay;

function mdr_pay_product_request(WP_REST_Request $request)
{

    $inputs['phone'] = mdr_sanitize_mobile($request['phone'] ?? '');

    if (!mdr_is_phone($inputs['phone'])) {
        mdr_send_json(false, 'شماره موبایل وارد شده صحیح نیست.');
    }

    $inputs['full_name'] = sanitize_text_field($request['full_name'] ?? '');

    if (!$inputs['full_name'] || strlen($inputs['full_name']) < 3) {
        mdr_send_json(false, 'نام خود را به صورت کامل وارد نمایید.');
    }

    $product_id = intval($request['product_id'] ?? 0);

    if (!$product_id) {
        mdr_send_json(false, 'محصول ارسال نشد.');
    }

    $data['products'] = [$product_id => -1];

    if (isset($request['utm_source'])) {
        $data['utm']['utm_source'] = sanitize_text_field($request['utm_source']);
    }

    if (isset($request['utm_campaign'])) {
        $data['utm']['utm_campaign'] = sanitize_text_field($request['utm_campaign']);
    }

    $landing_url = $request['landing_url'] ?? '';

    if (!$landing_url) {
        mdr_send_json(false, 'لندینگ یافت نشد.');
    }

    $data['landing_url'] = $landing_url;

    $pay = new MdrPay();
    $pay->set_data($inputs, $data);
    $link = $pay->getPayLink();

    if (isset($link['success']) && $link['success']) {
        mdr_send_json(true, 'در حال انتقال به درگاه پرداخت ...', ['url' => $link['data']['payment_link']]);
    }elseif(isset($link['data']['errors'])) {
        mdr_send_json(false, $link['message'] ?? 'خطایی رخ داده.', ['errors' => $link['data']['errors']]);
    }else {
        mdr_send_json(false, $link['message'] ?? 'خطایی ایجاد شده. لطفا با پشتیبانی تماس بگیرید.');
    }


}
