<?php

use Mdr\Services\SendMessage;

function mdr_login_sms_callback()
{

    if (is_user_logged_in()) {
        mdr_send_json(false, 'شما وارد شده اید.');
    }

    if (!isset($_POST['phone'])) {
        mdr_send_json(false, 'شماره همراه الزامی می باشد.');
    }

    $phone = mdr_sanitize_mobile($_POST['phone']);

    if (!mdr_is_phone($phone)) {
        mdr_send_json(false, 'شماره همراه معتبر نمی باشد.');
    }

    if (get_transient('login_otp_' . $phone) !== false) {
        mdr_send_json(false, 'برای درخواست مجدد لطفا کمی صبر کنید.');
    }

    $otp = mt_rand(10000, 99999);

    $message = new SendMessage($phone);
    $message->send_pattern_sms('p9jzy7l5khp9ql5', ['code' => $otp]);

    set_transient('login_otp_' . $phone, $otp, 120);

    mdr_send_json(true, 'کد با موفقیت ارسال شد.');
}

function mdr_login_whatsapp_callback()
{

    if (is_user_logged_in()) {
        mdr_send_json(false, 'شما وارد شده اید.');
    }

    if (!isset($_POST['phone'])) {
        mdr_send_json(false, 'شماره همراه الزامی می باشد.');
    }

    $phone = mdr_sanitize_mobile($_POST['phone']);

    if (!mdr_is_phone($phone)) {
        mdr_send_json(false, 'شماره همراه معتبر نمی باشد.');
    }

    if (get_transient('login_otp_' . $phone) !== false) {
        mdr_send_json(false, 'برای درخواست مجدد لطفا کمی صبر کنید.');
    }

    $otp = mt_rand(10000, 99999);

    whatsapp_send_message($phone, sprintf('کد ورود شما: %s', $otp));

    set_transient('login_otp_' . $phone, $otp, 120);

    mdr_send_json(true, 'کد با موفقیت ارسال شد.');
}

function mdr_login_confirm_callback()
{

    if (is_user_logged_in()) {
        mdr_send_json(false, 'شما وارد شده اید.');
    }

    if (!isset($_POST['phone'])) {
        mdr_send_json(false, 'شماره همراه الزامی می باشد.');
    }

    $phone = mdr_sanitize_mobile($_POST['phone']);

    if (!mdr_is_phone($phone)) {
        mdr_send_json(false, 'شماره همراه معتبر نمی باشد.');
    }

    $otp = get_transient('login_otp_' . $phone);

    if ($otp === false) {
        mdr_send_json(false, 'کد وارد شده معتبر نمی‌باشد.');
    }

    $code = $_POST['code'];

    if ($code != $otp) {
        mdr_send_json(false, 'کد وارد شده صحیح نمی باشد.');
    }

    $new_user = false;
    $user = mdr_get_user($phone);

    if ($user === false) {
        $user = mdr_create_user($phone, $phone);
        $new_user = true;
        $new_nonce = wp_create_nonce('wp_rest');
    }

    if ($user === false) {
        mdr_send_json(false, 'مشکلی در دریافت کاربر ایجاد شده.');
    }

    if ($new_user) {
        mdr_send_json(true, 'کاربر جدید', ['new_user' => true]);
    } else {
        clean_user_cache($user->ID);
        wp_clear_auth_cookie();

        wp_set_current_user($user->ID, $phone);
        wp_set_auth_cookie($user->ID, true);

        if (isset($_POST['callback'])) {
            $back = $_POST['callback'];
        } else {
            $back = site_url();
        }

        delete_user_meta($user->ID, 'login_otp');

        mdr_send_json(true, 'شما با موفقیت وارد شدید.', ['back' => $back]);
    }

}

function mdr_register_callback()
{

    if (!isset($_POST['full_name'])) {
        mdr_send_json(false, 'لطفا نام خود را وارد نمایید.');
    }

    $full_name = sanitize_text_field($_POST['full_name']);

    if (!isset($_POST['phone'])) {
        mdr_send_json(false, 'شماره همراه الزامی می باشد.');
    }

    $phone = mdr_sanitize_mobile($_POST['phone']);

    if (!mdr_is_phone($phone)) {
        mdr_send_json(false, 'شماره همراه معتبر نمی باشد.');
    }

    $user = mdr_get_user($phone);

    if ($user === false) {
        mdr_send_json(false, 'کاربر یافت نشد.');
    }

    $user_id = wp_update_user(['ID' => $user->ID, 'display_name' => $full_name]);
    update_user_meta($user->ID, 'nickname', $full_name);

    clean_user_cache($user->ID);
    wp_clear_auth_cookie();

    wp_set_current_user($user->ID, $phone);
    wp_set_auth_cookie($user->ID, true);

    if (isset($_POST['callback'])) {
        $back = $_POST['callback'];
    } else {
        $back = site_url();
    }

    delete_user_meta($user->ID, 'login_otp');

    mdr_send_json(true, 'شما با موفقیت وارد شدید.', ['back' => $back]);

}

function mdr_logout_callback()
{
    if (!is_user_logged_in()) {
        mdr_send_json(false, 'شما وارد نشدید.');
    }

    wp_logout();

    mdr_send_json(true, 'خروج انجام شد.', [
        'back' => get_site_url(),
    ]);

}

function mdr_login_callback()
{
    if (is_user_logged_in()) {
        mdr_send_json(false, 'شما وارد نشدید.');
    }

    $block = '<!-- wp:pattern {"slug":"modiram/login"} /-->';
    $parse_blocks = parse_blocks($block);
    $login_html = render_block($parse_blocks[0]);

    mdr_send_json(true, 'دریافت شد.', [
        'login' => $login_html
    ]);

}