<?php

function mdr_add_consultation(WP_REST_Request $request)
{

    $phone = mdr_sanitize_mobile($request['phone']);

    if (!mdr_is_phone($phone)) {
        mdr_send_json(false, 'شماره موبایل صحیح نمی باشد.');
    }

    $full_name = $request['full_name'];

    if (empty($full_name)) {
        mdr_send_json(false, 'وارد کردن نام الزامی می باشد.');
    }

    $user = mdr_get_or_create_user($phone, $full_name);

    if (!$user) {
        mdr_send_json(false, 'مشکلی در ایجاد درخواست شما رخ داده لطفا با پشتیبانی تماس بگیرید.');
    }

    $check = get_user_meta($user->ID, 'consultation_status', true);

    if ($check && $check == 'pending') {
        mdr_send_json(false, 'عملیات ثبت شما قبلا ایجاد شده کارشناس به زودی با شما تماس خواهد گرفت.');
    }

    update_user_meta($user->ID, 'consultation_status', 'pending');
    update_user_meta($user->ID, 'consultation_date', current_time('mysql'));

    if (isset($request['post_id']) && !empty($request['post_id'])) {
        update_user_meta($user->ID, 'consultation_post_id', $request['post_id']);
    }

    mdr_send_json(true, 'درخواست شما ثبت شد.');

}
