<?php

function mdr_add_comment(WP_REST_Request $request)
{

    $user_id = get_current_user_id();
//    $user_id = $request['user_id'];
//    $user = get_user_by('id', $user_id);

    if (!$user_id) {
        $block = '<!-- wp:pattern {"slug":"modiram/login"} /-->';
        $parse_blocks = parse_blocks($block);
        $login_html = render_block( $parse_blocks[0] );

        mdr_send_json(false, 'جهت ثبت تیکت ابتدا می بایست وارد سایت شوید.', [
            'login' => $login_html
        ]);
    }

    $post_id = $request['post_id'];

    if (empty($post_id)) {
        mdr_send_json(false, 'پست نامشخص');
    }

    $comment_content = sanitize_text_field($request['comment_content']);

    if (empty($comment_content) || strlen($comment_content) < 20) {
        mdr_send_json(false, 'دیدگاه وارد نشده و یا بسیار کوتاه میباشد.');
    }

    $comment_author = $request['comment_author'];

    if (empty($comment_author)) {
        mdr_send_json(false, 'وارد کردن نام الزامی می باشد.');
    }

    $insert = wp_insert_comment([
        'comment_agent' => $_SERVER['HTTP_USER_AGENT'],
        'comment_post_ID' => $post_id,
        'comment_content' => $comment_content,
        'comment_author' => $comment_author,
        'comment_author_email' => sanitize_email($request['comment_author_email']) ?? '',
        'comment_author_url' => sanitize_url($request['comment_author_url']) ?? '',
        'comment_author_IP' => mdr_get_user_ip() ?? '',
        'comment_approved' => 0,
        'comment_type' => 'comment',
        'comment_parent' => $request['comment_parent'] ?? 0,
        'user_id' => $user_id,
    ]);

    if ($insert) {
        mdr_send_json(true, 'کامنت شما با موفقیت ثبت شد پس از تایید قابل نمایش می باشد.', [
            'name' => $comment_author,
            'date' => verta()->format('Y/n/j'),
            'content' => $comment_content,
        ]);
    }

    mdr_send_json(false, 'خطایی در ایجاد کامنت رخ داده.');

}
