<?php

function mdr_get_archive_posts(WP_REST_Request $request)
{

    $post_type = $request['post_type'] ?? null;
    $taxonomy = $request['taxonomy'] ?? null;
    $term_slug = $request['term_slug'] ?? null;
    $orderby = $request['orderby'] ?? null;
    $order = $request['order'] ?? null;
//    $posts_per_page = $request['posts_per_page'] ?? null;
    $posts_per_page = get_option('posts_per_page');
    $page = $request['page'] ?? 1;

    if (!$post_type || !$taxonomy || !$term_slug) {
        mdr_send_json(false, 'اطلاعات کامل نیست.');
    }

    $offset = ($page - 1) * ($posts_per_page ?? 1);
    $posts_class = new WP_Query([
        'post_type' => $post_type,
        'post_status' => 'publish',
        'orderby' => $orderby ?? 'date',
        'order' => $order ?? 'DESC',
        'posts_per_page' => $posts_per_page ?? 1,
        'offset' => $offset,
        'tax_query' => [
            [
                'taxonomy' => $taxonomy,
                'field' => 'slug',
                'terms' => $term_slug,
            ],
        ],
    ]);

    if ($posts_class && !empty($posts_class->posts)) {

        foreach ($posts_class->posts as $post) {
            $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail');
            $post->thumbnail = $thumbnail[0] ?? get_theme_file_uri('assets/images/card.png');
            $post->link = get_permalink($post);
        }

        mdr_send_json(true, 'با موفقیت دریافت شد.', [
            'posts' => $posts_class->posts,
            'page' => $page,
            'max_num_pages' => $posts_class->max_num_pages,
        ]);
    }

    mdr_send_json(false, 'موردی یافت نشد.');

}
