<?php

function mdr_faq_product_update(WP_REST_Request $request)
{

    $product_id = $request['product_id'];

    if (!$product_id) {
        mdr_send_json(false, 'شناسه محصول الزامی می باشد.');
    }

    $faqs = [];

    for ($i= 0; $i <= 10; $i++) {

        if (isset($request['question_' . $i]) && isset($request['answer_' . $i]) &&
            !empty($request['question_' . $i]) && !empty($request['answer_' . $i])) {
            $faqs[$i] = [
                'question' => $request['question_' . $i],
                'answer' => $request['answer_' . $i],
            ];
        }

    }

    if (empty($faqs)) {
        mdr_send_json(false, 'موارد نباید خالی باشد.');
    }

    update_post_meta($product_id, 'faqs', $faqs);

    mdr_send_json(true, 'درخواست شما ثبت شد.');

}

function mdr_seasons_product_update(WP_REST_Request $request)
{

    $product_id = $request['product_id'];

    if (!$product_id) {
        mdr_send_json(false, 'شناسه محصول الزامی می باشد.');
    }

    $seasons = [];

    for ($i= 0; $i <= 20; $i++) {

        if (isset($request['title_' . $i]) && !empty($request['title_' . $i]) ) {
            $seasons[$i] = [
                'title' => $request['title_' . $i],
                'description' => $request['description_' . $i] ?? '',
            ];
        }

    }

    if (empty($seasons)) {
        mdr_send_json(false, 'موارد نباید خالی باشد.');
    }

    update_post_meta($product_id, 'seasons', $seasons);

    mdr_send_json(true, 'درخواست شما ثبت شد.');

}

function mdr_results_product_update(WP_REST_Request $request)
{

    $product_id = $request['product_id'];

    if (!$product_id) {
        mdr_send_json(false, 'شناسه محصول الزامی می باشد.');
    }

    $faqs = [];

    for ($i= 0; $i <= 10; $i++) {

        if (isset($request['poster_' . $i]) && isset($request['video_' . $i]) &&
            !empty($request['poster_' . $i]) && !empty($request['video_' . $i])) {
            $faqs[$i] = [
                'poster' => $request['poster_' . $i],
                'video' => $request['video_' . $i],
                'full_name' => $request['full_name_' . $i] ?? '',
                'title' => $request['title_' . $i] ?? '',
            ];
        }

    }

    if (empty($faqs)) {
        mdr_send_json(false, 'موارد نباید خالی باشد.');
    }

    update_post_meta($product_id, 'results', $faqs);

    mdr_send_json(true, 'درخواست شما ثبت شد.');

}

function mdr_benefits_product_update(WP_REST_Request $request)
{

    $product_id = $request['product_id'];

    if (!$product_id) {
        mdr_send_json(false, 'شناسه محصول الزامی می باشد.');
    }

    $faqs = [];

    for ($i= 0; $i <= 10; $i++) {

        if (isset($request['icon_' . $i]) && isset($request['title_' . $i]) &&
            !empty($request['icon_' . $i]) && !empty($request['title_' . $i])) {
            $faqs[$i] = [
                'icon' => $request['icon_' . $i],
                'title' => $request['title_' . $i],
            ];
        }

    }

    if (empty($faqs)) {
        mdr_send_json(false, 'موارد نباید خالی باشد.');
    }

    update_post_meta($product_id, 'benefits', $faqs);

    mdr_send_json(true, 'درخواست شما ثبت شد.');

}
