<?php
namespace Mdr\Gateways;
class GatewayNabik
{
    public function __construct($gateway)
    {

        if (!empty($gateway) && isset($gateway['merchant']) && !empty($gateway['merchant'])) {
            $this->merchant = $gateway['merchant'];
        }

    }

    public function request($details)
    {

        if (!$this->merchant) {
            return [
                'success' => false,
                'message' => 'درگاه دریافت نشد.',
            ];
        }

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://pay.sookhtejet.com/request',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'merchant' => $this->merchant,
                'callback' => $details['callback'],
                'amount' => $details['amount'],
                'currency' => $details['currency'],
                'order_id' => $details['order_id'],
                'mobile' => $details['phone'],
                'description' => $details['description'],
            ],
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
                'cache-control: no-cache',
                'content-type: multipart/form-data',
            ],
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            return [
                'success' => false,
                'message' => 'خطایی در ارتباط با درگاه رخ داده.',
                'error' => $error
            ];
        }

        $response = json_decode($response, JSON_OBJECT_AS_ARRAY);

        if (isset($response['success']) && $response['success'] && isset($response['data']['payment_link'])) {
            return [
                'success' => true,
                'message' => $response['message'] ?? 'با موفقیت انجام شد.',
                'data' => [
                    'payment_link' => $response['data']['payment_link'],
                    'authority' => $response['data']['authority'],
                ],
            ];
        } else {
            return [
                'success' => false,
                'message' => $response['message'] ?? 'خطایی رخ داده.',
                'data' => [
                    'errors' => [
                        'name' => $response['data']['name'] ?? 'undefined',
                        'message' => $response['data']['error'] ?? '',
                    ]
                ],
            ];
        }

    }

    public function verify($authority)
    {

        if (!$this->merchant || !$authority) {
            return [
                'success' => false,
                'message' => 'درگاه دریافت نشد.',
            ];
        }

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://pay.sookhtejet.com/verify',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => [
                'merchant' => $this->merchant,
                'authority' => $authority,
            ],
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
                'cache-control: no-cache',
                'content-type: multipart/form-data',
            ],
        ]);

        $response = curl_exec($curl);
        $error = curl_error($curl);

        curl_close($curl);

        if ($error) {
            return [
                'success' => false,
                'message' => 'خطایی در ارتباط با درگاه رخ داده.',
                'error' => $error
            ];
        }

        $response = json_decode($response, JSON_OBJECT_AS_ARRAY);

        if (isset($response['success']) && $response['success'] ) {
            return [
                'success' => true,
                'message' => $response['message'] ?? 'پرداخت با موفقیت انجام شد.',
                'data' => $response['data'] ?? [],
            ];
        } else {
            return [
                'success' => false,
                'message' => $response['message'] ?? 'متاسفانه پرداخت انجام نشد.',
                'data' => $response['data'],
            ];
        }
    }

    private string $merchant = '';
}