<?php

if (!class_exists('woocommerce')) {
    return;
}

add_filter('product_type_options', 'mdr_add_course_product_option');
/**
 * add course product data in edit woocommerce product page
 * @return void
 */
function mdr_add_course_product_option($product_type_options)
{
    $product_type_options['course'] = array(
        'id' => '_course',
        'wrapper_class' => '',
        'label' => 'دوره',
        'description' => 'اگر محصول شما یک دوره آموزشی می باشد این گزینه را انتخاب کنید.',
        'default' => 'no'
    );

    return $product_type_options;
}

add_action('woocommerce_process_product_meta_simple', 'mdr_save_course_option_fields');
add_action('woocommerce_process_product_meta_variable', 'mdr_save_course_option_fields');
/**
 * @param int $post_id
 * @return void
 */
function mdr_save_course_option_fields($post_id)
{
    $is_course = isset($_POST['_course']) ? 'yes' : 'no';
    update_post_meta($post_id, '_course', $is_course);
}

add_action('woocommerce_product_options_advanced', 'mdr_add_course_info_product_option');
/**
 * add info and inputs in to edit page product options advanced
 * @return void
 */
function mdr_add_course_info_product_option()
{

    $teacher = [
        'id' => '_teacher',
        'label' => 'معلم دوره:',
        'class' => '',
        'desc_tip' => true,
        'description' => 'نام معلم را وارد نمایید.',
    ];

    $time = [
        'id' => '_time',
        'label' => 'مدت زمان دوره:',
        'class' => '',
        'desc_tip' => true,
        'description' => 'مدت زمان دوره به ساعت را وارد نمایید.',
    ];

    $participants = [
        'id' => '_participants',
        'label' => 'تعداد شرکت کنندگان:',
        'class' => 'wc_input_decimal',
        'desc_tip' => true,
        'description' => 'تعداد شرکت کنندگان را وارد نمایید.',
    ];

    $execution = [
        'id' => '_execution',
        'label' => 'نوع اجرای دوره:',
        'class' => '',
        'desc_tip' => false,
        'description' => 'آنلاین / حضوری',
    ];

    $poster = [
        'id' => '_poster',
        'label' => 'لینک پوستر ویدیو:',
        'class' => '',
        'desc_tip' => false,
        'description' => 'لینک',
    ];

    $video = [
        'id' => '_video',
        'label' => 'لینک ویدیو:',
        'class' => '',
        'desc_tip' => false,
        'description' => 'لینک',
    ];

    woocommerce_wp_text_input($teacher);
    woocommerce_wp_text_input($time);
    woocommerce_wp_text_input($participants);
    woocommerce_wp_text_input($execution);
    woocommerce_wp_text_input($poster);
    woocommerce_wp_text_input($video);
}

add_action('woocommerce_process_product_meta', 'mdr_save_course_info_product_option');
/**
 * save added inputs in products save process
 * @param $post_id
 * @return void
 */
function mdr_save_course_info_product_option($post_id)
{

    if (isset($_POST['_teacher']) && !empty($_POST['_teacher'])) {
        update_post_meta($post_id, '_teacher', $_POST['_teacher']);
    }

    if (isset($_POST['_time']) && !empty($_POST['_time'])) {
        update_post_meta($post_id, '_time', $_POST['_time']);
    }

    if (isset($_POST['_participants']) && !empty($_POST['_participants'])) {
        update_post_meta($post_id, '_participants', $_POST['_participants']);
    }

    if (isset($_POST['_execution']) && !empty($_POST['_execution'])) {
        update_post_meta($post_id, '_execution', $_POST['_execution']);
    }

    if (isset($_POST['_poster']) && !empty($_POST['_poster'])) {
        update_post_meta($post_id, '_poster', $_POST['_poster']);
    }

    if (isset($_POST['_video']) && !empty($_POST['_video'])) {
        update_post_meta($post_id, '_video', $_POST['_video']);
    }

}

add_action('add_meta_boxes', 'mdr_add_faq_meta_box');
/**
 * Add FAQ products
 * @return void
 */
function mdr_add_faq_meta_box()
{
    add_meta_box(
        'faq_meta_box', // Unique ID
        'سوالات متداول', // Box title
        'mdr_faq_meta_box_callback', // Content callback
        'product', // Post type
        'normal', // Context
        'low' // Priority
    );
}

/**
 * FAQ callback
 * @return void
 */
function mdr_faq_meta_box_callback()
{
    $product = wc_get_product();
    $faqs = get_post_meta($product->get_id(), 'faqs', true);

    $old = '';
    $num = 0;

    if ($faqs) {

        foreach ($faqs as $faq) {
            $num++;
            $old .= '
            <div class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1">'. $num. '</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">سوال: </span>
                        <input type="text" class="form-control faq_question faq_inputs" name="question_' . $num . '" placeholder="سوال را وارد نمایید" value="'. $faq['question']. '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">پاسخ: </span>
                        <textarea class="form-control faq_answer faq_inputs" name="answer_' . $num . '" placeholder="پاسخ را وارد نمایید">' . $faq['answer'] . '</textarea>
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_faq_remove(this)">حذف</button>
                </div>
            </div>
        ';
        }

    }

    echo '
    <div class="contaner">
        <p>سوالات متداول خود را وارد نمایید:</p>
        <div id="form_faq">
            <div id="form_faq_in" style="display: none" class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1 number">1</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">سوال: </span>
                        <input type="text" class="form-control faq_question faq_inputs" name="question" placeholder="سوال را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">پاسخ: </span>
                        <textarea class="form-control faq_answer faq_inputs" name="answer" placeholder="پاسخ را وارد نمایید"></textarea>
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_faq_remove(this)">حذف</button>
                </div>
           </div>
           ' . $old . '
       </div>
        
    </div>
    <div class="row">
        <button type="button" class="col btn btn-primary me-4" onclick="mdr_form_faq_add()">+جدید</button>
        <button type="button" class="col btn btn-success" onclick="mdr_form_faq_submit('. $product->get_id(). ')">ثبت تغییرات</button>
    </div>
    <div id="faq_response"></div>
    <script>
            let faq_num = ' . $num . ';
    </script> 
    ';
}

add_action('add_meta_boxes', 'mdr_add_seasons_meta_box');
/**
 * Add Seasons products
 * @return void
 */
function mdr_add_seasons_meta_box()
{
    add_meta_box(
        'seasons_meta_box', // Unique ID
        'سرفصل ها', // Box title
        'mdr_seasons_meta_box_callback', // Content callback
        'product', // Post type
        'normal', // Context
        'low' // Priority
    );
}

/**
 * Seasons callback
 * @return void
 */
function mdr_seasons_meta_box_callback()
{
    $product = wc_get_product();
    $seasons = get_post_meta($product->get_id(), 'seasons', true);

    $old = '';
    $num = 0;

    if ($seasons) {

        foreach ($seasons as $season) {
            $num++;
            $old .= '
            <div class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1">'. $num. '</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">سوال: </span>
                        <input type="text" class="form-control seasons_title seasons_inputs" name="title_' . $num . '" placeholder="عنوان را وارد نمایید" value="'. $season['title']. '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">پاسخ: </span>
                        <textarea class="form-control seasons_description seasons_inputs" name="description_' . $num . '" placeholder="توضیح را وارد نمایید">' . $season['description'] . '</textarea>
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_seasons_remove(this)">حذف</button>
                </div>
            </div>
        ';
        }

    }

    echo '
    <div class="contaner">
        <p>سوالات متداول خود را وارد نمایید:</p>
        <div id="form_seasons">
            <div id="form_seasons_in" style="display: none" class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1 number">1</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">سوال: </span>
                        <input type="text" class="form-control seasons_title seasons_inputs" name="title" placeholder="عنوان را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">پاسخ: </span>
                        <textarea class="form-control seasons_description seasons_inputs" name="description" placeholder="توضیح را وارد نمایید"></textarea>
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_seasons_remove(this)">حذف</button>
                </div>
           </div>
           ' . $old . '
       </div>
        
    </div>
    <div class="row">
        <button type="button" class="col btn btn-primary me-4" onclick="mdr_form_seasons_add()">+جدید</button>
        <button type="button" class="col btn btn-success" onclick="mdr_form_seasons_submit('. $product->get_id(). ')">ثبت تغییرات</button>
    </div>
    <div id="seasons_response"></div>
    <script>
            let seasons_num = ' . $num . ';
    </script> 
    ';

}

add_action('add_meta_boxes', 'mdr_add_results_meta_box');
/**
 * Add Seasons products
 * @return void
 */
function mdr_add_results_meta_box()
{
    add_meta_box(
        'results_meta_box', // Unique ID
        'نتایج', // Box title
        'mdr_results_meta_box_callback', // Content callback
        'product', // Post type
        'normal', // Context
        'low' // Priority
    );
}

/**
 * results callback
 * @return void
 */
function mdr_results_meta_box_callback()
{
    $product = wc_get_product();
    $results = get_post_meta($product->get_id(), 'results', true);

    $old = '';
    $num = 0;

    if ($results) {

        foreach ($results as $result) {
            $num++;
            $full_name = $result['full_name'] ?? '';
            $title = $result['title'] ?? '';

            $old .= '
            <div class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1">'. $num. '</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">لینک پوستر: </span>
                        <input type="text" class="form-control results_poster results_inputs" name="poster_' . $num . '" placeholder="لینک پوستر را وارد نمایید" value="'. $result['poster']. '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">لینک ویدیو: </span>
                        <input type="text" class="form-control results_video results_inputs" name="video_' . $num . '" placeholder="لینک ویدیو را وارد نمایید" value="'. $result['video']. '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">نام کامل: </span>
                        <input type="text" class="form-control results_full_name results_inputs" name="full_name_' . $num . '" placeholder="نام کامل را وارد نمایید" value="'. $full_name . '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">عنوان: </span>
                        <input type="text" class="form-control results_title results_inputs" name="title_' . $num . '" placeholder="عنوان را وارد نمایید" value="'. $title . '">
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_results_remove(this)">حذف</button>
                </div>
            </div>
        ';
        }

    }

    echo '
    <div class="contaner">
        <p>نتایج دوره را وارد نمایید:</p>
        <div id="form_results">
            <div id="form_results_in" style="display: none" class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1 number">1</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">لینک پوستر: </span>
                        <input type="text" class="form-control results_poster results_inputs" name="poster" placeholder="لینک پوستر را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">لینک ویدیو: </span>
                        <input type="text" class="form-control results_video results_inputs" name="video" placeholder="لینک ویدیو را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">نام کامل: </span>
                        <input type="text" class="form-control results_full_name results_inputs" name="full_name" placeholder="نام کامل را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">عنوان: </span>
                        <input type="text" class="form-control results_title results_inputs" name="title" placeholder="عنوان را وارد نمایید" >
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_results_remove(this)">حذف</button>
                </div>
           </div>
           ' . $old . '
       </div>
        
    </div>
    <div class="row">
        <button type="button" class="col btn btn-primary me-4" onclick="mdr_form_results_add()">+جدید</button>
        <button type="button" class="col btn btn-success" onclick="mdr_form_results_submit('. $product->get_id(). ')">ثبت تغییرات</button>
    </div>
    <div id="results_response"></div>
    <script>
            let results_num = ' . $num . ';
    </script> 
    ';

}

add_action('add_meta_boxes', 'mdr_add_benefits_meta_box');
/**
 * Add Seasons products
 * @return void
 */
function mdr_add_benefits_meta_box()
{
    add_meta_box(
        'benefits_meta_box', // Unique ID
        'مزایای دوره', // Box title
        'mdr_benefits_meta_box_callback', // Content callback
        'product', // Post type
        'normal', // Context
        'low' // Priority
    );
}

/**
 * benefits callback
 * @return void
 */
function mdr_benefits_meta_box_callback()
{
    $product = wc_get_product();
    $benefits = get_post_meta($product->get_id(), 'benefits', true);

    $old = '';
    $num = 0;

    if ($benefits) {

        foreach ($benefits as $result) {
            $num++;
            $old .= '
            <div class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1">'. $num. '</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">لینک آیکون: </span>
                        <input type="text" class="form-control benefits_icon benefits_inputs" name="icon_' . $num . '" placeholder="لینک آیکون را وارد نمایید" value="'. $result['icon']. '">
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">عنوان: </span>
                        <input type="text" class="form-control benefits_title benefits_inputs" name="title_' . $num . '" placeholder="عنوان را وارد نمایید" value="'. $result['title']. '">
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_benefits_remove(this)">حذف</button>
                </div>
            </div>
        ';
        }

    }

    echo '
    <div class="contaner">
        <p>مزایای دوره را ایجاد نمایید:</p>
        <div id="form_benefits">
            <div id="form_benefits_in" style="display: none" class="row bg-secondary-subtle align-items-center text-center mb-3">
                <div class="col-1 number">1</div>
                <div class="col-10">
                    <div class="input-group">
                        <span class="input-group-text w-15" id="basic-addon2">لینک آیکون: </span>
                        <input type="text" class="form-control benefits_icon benefits_inputs" name="icon" placeholder="لینک آیکون را وارد نمایید" >
                    </div>
                    <div class="input-group">
                        <span class="input-group-text w-15">عنوان: </span>
                        <input type="text" class="form-control benefits_title benefits_inputs" name="title" placeholder="عنوان را وارد نمایید" >
                    </div>
                </div>
                <div class="col-1">
                    <button class="btn btn-sm btn-danger" onclick="mdr_form_benefits_remove(this)">حذف</button>
                </div>
           </div>
           ' . $old . '
       </div>
        
    </div>
    <div class="row">
        <button type="button" class="col btn btn-primary me-4" onclick="mdr_form_benefits_add()">+جدید</button>
        <button type="button" class="col btn btn-success" onclick="mdr_form_benefits_submit('. $product->get_id(). ')">ثبت تغییرات</button>
    </div>
    <div id="benefits_response"></div>
    <script>
            let benefits_num = ' . $num . ';
    </script> 
    ';

}
