<?php

add_action('after_setup_theme', [\Mdr\Theme\Install::class, 'install']);
add_action('admin_init', [\Mdr\Theme\Settings::class, 'admin_flow']);
add_action('init', [\Mdr\Theme\Settings::class, 'flow']);

/**
 * front print breadcrumb
 * @return void
 */
function mdr_print_breadcrumb()
{
    global $wp_query, $category;

    $results = '';

    $sep = '<!-- wp:pattern {"slug":"modiram/section-breadcrumb"} /-->';
    $sep = parse_blocks($sep);
    $sep = render_block($sep[0]);

    $arrow = '<!-- wp:pattern {"slug":"modiram/section-breadcrumb-arrow"} /-->';
    $arrow = parse_blocks($arrow);
    $arrow = render_block($arrow[0]);

    //home
    $first = str_replace('%Link%', get_site_url(), $sep);
    $first = str_replace('%Name%', 'خانه', $first);
    $first = str_replace('%Arrow%', $arrow, $first);

    $results .= $first;

    if (isset($category->slug) && !empty($category->slug)) {
        $category_parents[0] = $category;
    }elseif (is_archive() || is_category()) {
        $category = $wp_query->queried_object;
        $category_parents[0] = $category;
    } elseif (is_single()) {
        $category = get_the_category()[0] ?? [];
        $category_parents[0] = $category;
    }

    if (!empty($category_parents) && isset($category->slug) && !empty($category->slug)) {

        if (isset($category->parent) && $category->parent != 0) {

            do {
                $category = get_category($category->parent);
                $category_parents[] = $category;
            } while ($category->parent != 0);

        }

        $category_parents = array_reverse($category_parents);

        foreach ($category_parents as $key => $category) {
            $add = str_replace('%Link%', get_category_link($category->term_id), $sep);
            $add = str_replace('%Name%', $category->name, $add);

            if (isset($category_parents[$key + 1])) {
                $add = str_replace('%Arrow%', $arrow, $add);
            } else {
                $add = str_replace('%Arrow%', '', $add);
            }

            $results .= $add;
        }
    }

    echo $results;
}

/**
 * get all menu set in panel for a location
 * @param string $location
 * @return array
 */
function mdr_get_menu_array(string $location): array
{

    $cache_location = get_transient($location);

    if ($cache_location !== false) {
        return $cache_location;
    }

    $locations = get_nav_menu_locations();

    if (empty($location) || !isset($locations[$location])) {
        return [];
    }

    $menu = wp_get_nav_menu_object($locations[$location]);
    $menu_items = wp_get_nav_menu_items($menu->term_id);

    $main_menu = [];
    $sub1 = 0;
    $sub2 = 0;

    foreach ($menu_items as $menu_item) {
        if ($menu_item->menu_item_parent == 0) {
            $main_menu[$menu_item->ID] = (array)$menu_item;
            $sub1 = $menu_item->ID;
            $sub2 = 0;
        } elseif ($sub1 && array_key_exists($menu_item->menu_item_parent, $main_menu)) {
            $main_menu[$menu_item->menu_item_parent]['sub_menus'][$menu_item->ID] = (array)$menu_item;
            $sub2 = $menu_item->ID;
        } elseif ($sub1 && $sub2 && array_key_exists($menu_item->menu_item_parent, $main_menu[$sub1]['sub_menus'])) {
            $main_menu[$sub1]['sub_menus'][$sub2]['sub_menus'][$menu_item->ID] = (array)$menu_item;
        }

    }

    set_transient($location, $main_menu);
    return $main_menu;

}

/**
 * front add id "section-i" to h2 tag in content and print
 * @param $content
 * @return void
 */
function mdr_print_content_by_h2_section_id($content)
{
    if (empty($content)) {
        return;
    }

    $num = 0;

    for ($i = 1; $i <= 5; $i++) {

        $id = ' id="section-' . $i . '" ';

        if ($num > 0) {
            $num = strpos($content, '<h2', $num + 1);
        } else {
            $num = strpos($content, '<h2');
        }

        if ($num === false) {
            break;
        }

        $content = substr($content, 0, $num + 3) . $id . substr($content, $num + 3);

    }

    echo $content;
}

/**
 * find all h2 tags in content and make a list of it by link in their ids
 * @param $content
 * @return void
 */
function mdr_print_h2_lists_from_content($content)
{

    if (!empty($content)) return;

    $select_h2 = '<!-- wp:pattern {"slug":"modiram/section-h2-list-link"} /-->';
    $select_h2 = parse_blocks($select_h2);
    $select_h2 = render_block($select_h2[0]);

    $num = 0;
    $num_find = 0;
    $result = '';

    for ($i = 1; $i <= 5; $i++) {

        $id = 'section-' . $i;

        if ($num > 0) {
            $num = strpos($content, '</h2>', $num + 1);
            $num_find = strpos($content, '<h2', $num_find + 1);
        } else {
            $num = strpos($content, '</h2>') ?? -1;
            $num_find = strpos($content, '<h2') ?? -1;
        }

        if ($num === false) {
            break;
        }

        $tag = substr($content, $num_find, $num - $num_find);
        $close_num = strpos($tag, '>');
        $name = substr($tag, $close_num + 1);

        $add = str_replace('%Id%', $id, $select_h2);
        $add = str_replace('%Name%', $name, $add);
        $result .= $add;

    }

    echo $result;
}

/**
 * Function to get the user IP address
 * @return mixed|string
 */
function mdr_get_user_ip()
{
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if (isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if (isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if (isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if (isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}

/**
 * send json for rest response
 * @param bool $success
 * @param string $message
 * @param $data
 * @return void
 */
function mdr_send_json(bool $success, string $message, $data = []): void
{
    $json = [];
    $json['success'] = $success;
    $json['message'] = $message;
    $json['data'] = $data;

    wp_send_json($json);
    die();
}

/**
 * @param string $string
 * @return string
 */
function mdr_convert_persian_to_english_number(string $string): string
{

    $persian = [
        '۰',
        '۱',
        '۲',
        '۳',
        '۴',
        '۵',
        '۶',
        '۷',
        '۸',
        '۹',
        '٠',
        '١',
        '٢',
        '٣',
        '٤',
        '٥',
        '٦',
        '٧',
        '٨',
        '٩',
    ];
    $english = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9];

    return str_replace($persian, $english, $string);
}

/**
 * @param string $phone
 * @return string
 */
function mdr_sanitize_mobile($phone): string
{
    $phone = trim($phone);
    $phone = mdr_convert_persian_to_english_number($phone);
    $phone = str_replace(['+98', ' '], ['', ''], $phone);

    if (preg_match('/([^+]\d{5,}$)/', $phone)) {
        $phone = str_replace(['+'], ['00'], $phone);
    }

    if (preg_match('/(^009809\d{9}$)/', $phone)) {
        $phone = substr($phone, 5);
    }

    if (preg_match('/(^0098\d{10}$)/', $phone)) {
        $phone = substr($phone, 4);
    }

    if (preg_match('/(^9809\d{10}$)/', $phone)) {
        $phone = substr($phone, 4);
    }

    if (preg_match('/(^98\d{10}$)/', $phone)) {
        $phone = substr($phone, 2);
    }

    if (preg_match('/(^9\d{9}$)/', $phone)) {
        $phone = 0 . $phone;
    }

    return $phone;
}

/**
 * @param string $phone
 * @return false|string
 */
function mdr_is_phone(string $phone)
{
    $phone = mdr_sanitize_mobile($phone);

    if (preg_match('/(^09\d{9}$)/', $phone)) {
        return 'IR';
    }

    if (preg_match('/(^00[^0]\d{5,}$)/', $phone)) {
        return 'other';
    }

    return false;
}

/**
 * @param string $phone
 * @return false|mixed|WP_User
 */
function mdr_get_user(string $phone)
{
    $user = get_user_by('login', $phone);

    if (!$user) {
        $users = get_users(array(
            'meta_key' => 'billing_phone',
            'meta_value' => $phone,
        ));

        if (!empty($users)) {
            return $users[0];
        }

    }

    if (!$user) {
        $users = get_users([
            'meta_query' => [
                [
                    'key' => 'digits_phone_no',
                    'value' => '%' . intval($phone) . '%',
                    'compare' => 'LIKE',
                ],
            ],
        ]);

        if (!empty($users)) {
            return $users[0];
        }

    }

    if ($user) {
        return $user;
    }

    return false;
}

/**
 * @param string $phone
 * @param string $nicename
 * @param string $pre_phone
 * @return false|mixed|WP_User
 */
function mdr_get_or_create_user(string $phone, string $nicename, $pre_phone = '+98')
{

    $user = mdr_get_user($phone);

    if ($user) {
        return $user;
    }

    if (!$nicename) {
        $nicename = $phone;
    }

    $userdata = [
        'user_login' => $phone,
        'user_nicename' => $phone,
        'display_name' => $nicename,
        'nickname' => $nicename,
        'user_pass' => $nicename,
        'user_email' => 'm' . $phone . '@zarshot.com',
        'role' => 'subscriber',
    ];

    $user_id = wp_insert_user($userdata);
    add_user_meta($user_id, 'digits_form_data', 'a:0:{}');
    add_user_meta($user_id, 'digits_phone_no', intval($phone));
    add_user_meta($user_id, 'billing_phone', $phone);
    add_user_meta($user_id, 'digits_phone_verification_skipped', 'pending');

    if (mdr_is_phone($phone) == 'IR') {
        add_user_meta($user_id, 'digits_phone', $pre_phone . intval($phone));
        add_user_meta($user_id, 'digt_countrycode', $pre_phone);
    }

    return get_user_by('id', $user_id);
}

/**
 * @param string $phone
 * @param string $nicename
 * @param string $pre_phone
 * @return false|WP_User
 */
function mdr_create_user(string $phone, string $nicename, $pre_phone = '+98')
{

    if (!$nicename) {
        $nicename = $phone;
    }

    $userdata = [
        'user_login' => $phone,
        'user_nicename' => $phone,
        'display_name' => $nicename,
        'nickname' => $nicename,
        'user_pass' => $nicename,
        'user_email' => 'm' . $phone . '@zarshot.com',
        'role' => 'subscriber',
    ];

    $user_id = wp_insert_user($userdata);
    add_user_meta($user_id, 'digits_form_data', 'a:0:{}');
    add_user_meta($user_id, 'digits_phone_no', intval($phone));
    add_user_meta($user_id, 'billing_phone', $phone);
    add_user_meta($user_id, 'digits_phone_verification_skipped', 'pending');

    if (mdr_is_phone($phone) == 'IR') {
        add_user_meta($user_id, 'digits_phone', $pre_phone . intval($phone));
        add_user_meta($user_id, 'digt_countrycode', $pre_phone);
    }

    return get_user_by('id', $user_id);
}

