<?php

namespace Mdr\AddOns\Viewpoint;

class PostType
{
    public function __construct() {
        $this->register_post_type();
        $this->register_tag_taxonomies();
        $this->register_taxonomies();
    }

    private function register_post_type(): void
    {
        $args = [
            'name' => 'کامنت ها',
            'singular_name' => 'کامنت',
            'menu_name' => 'کامنت',
            'name_admin_bar' => 'کامنت',
            'add_new' => 'اضافه کردن کامنت',
            'add_new_item' => 'اضافه کردن کامنت',
            'new_item' => 'کامنت جدید',
            'edit_item' => "ویرایش کامنت",
            'view_item' => 'مشاهده کامنت',
            'all_items' => 'همه کامنت ها',
            'search items' => 'جست و جوی کامنت',
            'parent_item_colon' => 'والد کامنت',
            'not_found' => 'کامنت یافت نشد',
            'not_found_in_trash' => 'کامنت در سطل زباله یافت نشد',
            'featured_image'        => 'تصویر برجسته',
            'set_featured_image'    => 'افزودن تصویر برجسته',
            'remove_featured_image' => 'حذف تصویر برجسته',
            'use_featured_image'    => 'استفاده از تصویر برجسته',
            'archives'              => 'آرشیو ها',
            'insert_into_item'      => 'اضافه کردن به آیتم',
            'uploaded_to_this_item' => 'آپلود به این آیتم',
            'filter_items_list'     => 'فیلتر لیست آیتم ها',
            'items_list_navigation' => 'نویگیشن لیست آیتم ها',
            'items_list'            => 'لیست آیتم ها',
        ];

        register_post_type('viewpoint', array(
            'labels' => $args,
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'viewpoint'),
            'capability_type' => 'post',
            'has_archive' => true,
            'Hierarchical' => false,
            'menu_position' => 6,
            'menu_icon' => 'dashicons-admin-comments',
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments', 'hierarchical', 'trackbacks', 'custom-fields', 'revisions', 'page-attributes'),
            'taxonomies' => array('viewpoint_category'),
//        'taxonomies' => array('category','post_tag'),
            'description'        => 'کامنت های تم رنه سینانی',
            'show_in_rest'       => true
        ));

    }

    private function register_taxonomies(): void
    {
        $labels = array(
            'name' => _x('دسته بندی کامنت ها', 'کامنت ها'),
            'singular_name' => _x('کامنت', 'کامنت'),
            'search_items' => __('جست و جوی کامنت'),
            'all_items' => __('همه کامنت های'),
            'parent_item' => __('والد کامنت'),
            'parent_item_colon' => __('والد کامنت'),
            'edit_item' => __('ویرایش کامنت'),
            'update_item' => __('آپدیت کامنت'),
            'add_new_item' => __('اضافه کردن کامنت جدید'),
            'new_item_name' => __('نام آیتم جدید'),
            'menu_name' => __('دسته بندی کردن کامنت'),
        );

        $args = array(
            'hierarchical' => true,
            'labels' => $labels,
            'public' => true,
            'publicly_queryable' => true,
            'show_in_nav_menus' => true,
            'show_in_rest' => true,
            'show_in_rest_api' => true,
            'show_ui' => true,
            'show_tagcloud' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'has_archive' => true,
            'exclude_from_search' => true,
            'rewrite' => array('slug' => 'viewpoint_category', 'with_front' => true, 'hierarchical' => true),
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments', 'hierarchical', 'trackbacks', 'custom-fields', 'revisions', 'page-attributes'),
            'capabilities' => array(
                'manage_terms' => true,
                'edit_terms' => true,
                'delete_terms' => true,
                'assign_terms' => true,
            )
        );

        register_taxonomy('viewpoint_category', array('viewpoint'), $args);
    }

    private function register_tag_taxonomies()
    {

    }
}