<?php

namespace Mdr\AddOns\Viewpoint;

use Mdr\Theme\Install;
use Mdr\Theme\Settings;

class Load
{
    public function __construct()
    {
        $this->settings = new Settings();

        if (!$this->settings->get_settings($this->settingBaseName) || !$this->settings->get_settings($this->settingBaseName. 'installed')) {
            $this->install();
        }

        $this->flow();

    }

    private function flow()
    {
        add_action('init', function () {
            new PostType();
        });

    }

    public function install() {
        $this->settings->add_settings($this->settingBaseName. 'installed', true);
        $this->settings->add_settings($this->settingBaseName. 'version', '1.0.0');
        $this->add_page();
    }

    public function add_page()
    {
        $install = new Install();
        $install->create_page('نظر دانش آموختگان', 'viewpoint', 'page', 'taxonomy-viewpoint_category');
        $setting_pages = $this->settings->get_settings('pages');
        $setting_pages['viewpoint'] = [
            'title' => 'نظر دانش آموختگان',
            'name' => 'viewpoint',
            'post_type' => 'page',
            'template' => 'taxonomy-viewpoint_category',
        ];

        $this->settings->add_settings('pages', $setting_pages);
    }

    public $settings;
    private $settingBaseName = 'addOns,viewpoint,';
}

new Load();

