<?php

namespace Mdr\AddOns\Video;

class PostType
{
    public function __construct() {
        $this->register_post_type();
        $this->register_tag_taxonomies();
        $this->register_taxonomies();
    }

    private function register_post_type(): void
    {
        $args = [
            'name' => 'ویدیو ها',
            'singular_name' => 'ویدیو',
            'menu_name' => 'ویدیو',
            'name_admin_bar' => 'ویدیو',
            'add_new' => 'اضافه کردن ویدیو',
            'add_new_item' => 'اضافه کردن ویدیو',
            'new_item' => 'ویدیو جدید',
            'edit_item' => "ویرایش ویدیو",
            'view_item' => 'مشاهده ویدیو',
            'all_items' => 'همه ویدیو ها',
            'search items' => 'جست و جوی ویدیو',
            'parent_item_colon' => 'والد ویدیو',
            'not_found' => 'ویدیو یافت نشد',
            'not_found_in_trash' => 'ویدیو در سطل زباله یافت نشد',
            'featured_image'        => 'تصویر برجسته',
            'set_featured_image'    => 'افزودن تصویر برجسته',
            'remove_featured_image' => 'حذف تصویر برجسته',
            'use_featured_image'    => 'استفاده از تصویر برجسته',
            'archives'              => 'آرشیو ها',
            'insert_into_item'      => 'اضافه کردن به آیتم',
            'uploaded_to_this_item' => 'آپلود به این آیتم',
            'filter_items_list'     => 'فیلتر لیست آیتم ها',
            'items_list_navigation' => 'نویگیشن لیست آیتم ها',
            'items_list'            => 'لیست آیتم ها',
        ];

        register_post_type('video', array(
            'labels' => $args,
            'public' => true,
            'publicly_queryable' => true,
            'show_ui' => true,
            'show_in_menu' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'videos'),
            'capability_type' => 'post',
            'has_archive' => true,
            'Hierarchical' => false,
            'menu_position' => 6,
            'menu_icon' => 'dashicons-format-video',
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments', 'hierarchical', 'trackbacks', 'custom-fields', 'revisions', 'page-attributes'),
            'taxonomies' => array('video_category'),
//        'taxonomies' => array('category','post_tag'),
            'description'        => 'ویدیو های تم رنه سینانی',
            'show_in_rest'       => true
        ));

    }

    private function register_taxonomies(): void
    {
        $labels = array(
            'name' => _x('دسته بندی ویدیو ها', 'ویدیو ها'),
            'singular_name' => _x('ویدیو', 'ویدیو'),
            'search_items' => __('جست و جوی ویدیو'),
            'all_items' => __('همه ویدیو های'),
            'parent_item' => __('والد ویدیو'),
            'parent_item_colon' => __('والد ویدیو'),
            'edit_item' => __('ویرایش ویدیو'),
            'update_item' => __('آپدیت ویدیو'),
            'add_new_item' => __('اضافه کردن ویدیو جدید'),
            'new_item_name' => __('نام آیتم جدید'),
            'menu_name' => __('دسته بندی کردن ویدیو'),
        );

        $args = array(
            'hierarchical' => true,
            'labels' => $labels,
            'public' => true,
            'publicly_queryable' => true,
            'show_in_nav_menus' => true,
            'show_in_rest' => true,
            'show_in_rest_api' => true,
            'show_ui' => true,
            'show_tagcloud' => true,
            'query_var' => true,
            'show_admin_column' => true,
            'has_archive' => true,
            'exclude_from_search' => true,
            'rewrite' => array('slug' => 'video_category', 'with_front' => true, 'hierarchical' => true),
            'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments', 'hierarchical', 'trackbacks', 'custom-fields', 'revisions', 'page-attributes'),
            'capabilities' => array(
                'manage_terms' => true,
                'edit_terms' => true,
                'delete_terms' => true,
                'assign_terms' => true,
            )
        );

        register_taxonomy('video_category', array('video'), $args);
    }

    private function register_tag_taxonomies()
    {

    }
}