<?php

namespace Mdr\AddOns\Video;

class MetaBox
{
    public function __construct()
    {
        add_action('add_meta_boxes', [$this, 'add_custom_meta_box']);
        add_action('save_post', [$this, 'save_custom_widget_data']);
    }

    public function add_custom_meta_box()
    {
        add_meta_box(
            'custom_widget',
            ' سفارشی',
            [$this, 'custom_widget_callback'],
            array('video'),
            'normal', // مکان (side, normal, advanced)
            'default' // اولویت (default, high, low)
        );
    }

    public function custom_widget_callback($post)
    {
        $videos = get_post_meta($post->ID, 'videos', true);

        $old = '';
        $num = 0;

        if ($videos) {

            foreach ($videos as $video) {
                $num++;
                $old .= '
            <div>
                <div style="margin-bottom: 5px; display: flex;align-items: center;background-color: #dddddd;padding: 8px;border-radius: 8px;">
                    <div style="width: 10%; display: flex;justify-content: space-around;align-items: center;">
                        <div class="number">1</div>
                        <div>
                            <div>پوستر:</div>
                            <div>ویدیو:</div>
                        </div>
                    </div>
                    <div style="width: 80%">
                        <div><input class="video_poster_link" type="text" name="video_poster_link_'. $num. '" value="'. $video['poster']. '" style="width: 98%;"></div>
                        <div><input class="video_src_link" type="text" name="video_src_link_'. $num. '" value="'. $video['video']. '" style="width: 98%;"></div>
                    </div>
                    <div style="width: 10%">
                        <button type="button" onclick="mdr_form_video_details_remove(this)">حذف</button>
                    </div>
                </div>
            </div>
        ';
            }

        }

        ?>
        <div>
            <p>اطلاعات ویدیو خود را وارد نمایید:</p>
            <div id="form_video_details">
                <div id="form_video_details_in" style="display: none">
                    <div style="margin-bottom: 5px; display: flex;align-items: center;background-color: #dddddd;padding: 8px;border-radius: 8px;">
                        <div style="width: 10%; display: flex;justify-content: space-around;align-items: center;">
                            <div class="number">1</div>
                            <div>
                                <div>پوستر:</div>
                                <div>ویدیو:</div>
                            </div>
                        </div>
                        <div style="width: 80%">
                            <div><input class="video_poster_link" type="text" name="video_poster_link" placeholder="لینک پوستر ویدیو را وارد نمایید" style="width: 98%;"></div>
                            <div><input class="video_src_link" type="text" name="video_src_link" placeholder="لینک ویدیو را وارد نمایید" style="width: 98%;"></div>
                        </div>
                        <div style="width: 10%">
                            <button type="button" onclick="mdr_form_video_details_remove(this)">حذف</button>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $old; ?>
        </div>
        <div>
            <button type="button" onclick="mdr_form_video_details_add()">+جدید</button>
        </div>
        <script>
            let video_details_num = <?php echo $num ?>

            function mdr_form_video_details_remove(el) {
                jQuery(el).parent().parent().parent().remove();
                video_details_num = video_details_num - 1;
            }

            function mdr_form_video_details_add() {
                video_details_num = video_details_num + 1;

                let row = jQuery("#form_video_details_in").clone().show().attr("id", "");
                row.find(".number").text(video_details_num);
                row.find(".video_poster_link").attr("name", "video_poster_link_" + video_details_num);
                row.find(".video_src_link").attr("name", "video_src_link_" + video_details_num).show();
                jQuery("#form_video_details").append(row);

            }
        </script>
        <?php
    }

    public function save_custom_widget_data($post_id)
    {

        $videos = [];

        for ($i= 0; $i <= 10; $i++) {

            if (isset($_POST['video_poster_link_' . $i]) && isset($_POST['video_src_link_' . $i]) &&
                !empty($_POST['video_poster_link_' . $i]) && !empty($_POST['video_src_link_' . $i])) {
                $videos[$i] = [
                    'poster' => $_POST['video_poster_link_' . $i],
                    'video' => $_POST['video_src_link_' . $i],
                ];
            }

        }

        if (empty($videos)) {
            return;
        }

        update_post_meta($post_id, 'videos', $videos);

    }
}