<?php

namespace Mdr\AddOns\Video;

use Mdr\Theme\Install;
use Mdr\Theme\Settings;

class Load
{
    public function __construct()
    {
        $this->settings = new Settings();

        if (!$this->settings->get_settings($this->settingBaseName) || !$this->settings->get_settings($this->settingBaseName . 'installed')) {
            $this->install();
        }

        $this->flow();

    }

    private function flow()
    {
        add_action('init', function () {
            new PostType();
        });

        new MetaBox();

    }

    public function install()
    {
        $this->settings->add_settings($this->settingBaseName . 'installed', true);
        $this->settings->add_settings($this->settingBaseName . 'version', '1.0.0');
        $this->add_page();

    }

    public function add_page()
    {
        $install = new Install();
        $install->create_page('ویدیوها', 'video', 'page', 'taxonomy-video_category');
        $setting_pages = $this->settings->get_settings('pages');
        $setting_pages['video'] = [
            'title' => 'ویدیوها',
            'name' => 'video',
            'post_type' => 'page',
            'template' => 'taxonomy-video_category',
        ];

        $this->settings->add_settings('pages', $setting_pages);
    }

    public $settings;
    private $settingBaseName = 'addOns,video,';
}

new Load();

