function loadingHandler() {

    let loading = jQuery('#mdr_loading');

    if (loading.is(":visible")) {
        loading.remove();
    } else {
        jQuery('body').append('<div id="mdr_loading">\n' +
            '   <span class="loader"></span>\n' +
            '</div>')
    }

}

async function mdr_api(address, form = null) {

    if (!form) {
        form = new FormData;
    }

    form.append('key', MDRVars.api_key);
    form.append('_wpnonce', MDRVars.wpnonce);

    let settings = {
        "url": MDRVars.rest_url + address,
        "method": "POST",
        "timeout": 0,
        "processData": false,
        "Accept": "application/json",
        "contentType": false,
        "data": form
    };

    return await jQuery.ajax(settings);
}

function mdr_form_faq_remove(el) {
    jQuery(el).parent().parent().remove();
    faq_num = faq_num - 1;
}

function mdr_form_faq_add() {
    faq_num = faq_num + 1;

    let row = jQuery("#form_faq_in").clone().show().attr("id","");
    row.find(".number").text(faq_num);
    row.find(".faq_question").attr("name", "question_" + faq_num);
    row.find(".faq_answer").attr("name", "answer_" + faq_num).show();
    jQuery("#form_faq").append(row);

}

async function mdr_form_faq_submit(product_id) {
    loadingHandler();

    let inputs = jQuery("#form_faq").find(".faq_inputs");
    let send = false;
    let form = new FormData;
    form.append("product_id", product_id);

    jQuery(inputs).each(function(key, value) {
        let name = jQuery(value).attr("name");

        if (name === "question" || name === "answer" || !jQuery(value).val()) {
            return true;
        }

        send = true;
        form.append(name,jQuery(value).val());

    })

    if(!send) {
        jQuery("#faq_response").empty().append("<p>موردی برای ارسال یافت نشد.</p>");
        loadingHandler();
        return;

    }

    await mdr_api('admin/v1/faq_product_update', form).then(async function (response) {

        if (response.success === true) {
            jQuery("#faq_response").empty().append("<p class='text-success'>" + response.message + "</p>");
        } else {
            jQuery("#faq_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            jQuery("#faq_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");
        }

        console.log('error in curl')
    });

    loadingHandler();

}

function mdr_form_seasons_remove(el) {
    jQuery(el).parent().parent().remove();
    seasons_num = seasons_num - 1;
}

function mdr_form_seasons_add() {
    seasons_num = seasons_num + 1;

    let row = jQuery("#form_seasons_in").clone().show().attr("id","");
    row.find(".number").text(seasons_num);
    row.find(".seasons_title").attr("name", "title_" + seasons_num);
    row.find(".seasons_description").attr("name", "description_" + seasons_num).show();
    jQuery("#form_seasons").append(row);

}

async function mdr_form_seasons_submit(product_id) {
    loadingHandler();

    let inputs = jQuery("#form_seasons").find(".seasons_inputs");
    let send = false;
    let form = new FormData;
    form.append("product_id", product_id);

    jQuery(inputs).each(function(key, value) {
        let name = jQuery(value).attr("name");

        if (name === "title" || name === "description" ) {
            return true;
        }

        send = true;
        form.append(name,jQuery(value).val());

    })

    if(!send) {
        jQuery("#seasons_response").empty().append("<p>موردی برای ارسال یافت نشد.</p>");
        loadingHandler();
        return;
    }

    await mdr_api('admin/v1/seasons_product_update', form).then(async function (response) {

        if (response.success === true ) {
            jQuery("#seasons_response").empty().append("<p class='text-success'>" + response.message + "</p>");
        } else {
            jQuery("#seasons_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");
        }

    }).catch(function (xhr, err) {

        let response = JSON.parse(xhr.responseText);
        jQuery("#seasons_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");

        console.log('error in curl')
    });

    loadingHandler();

}

function mdr_form_results_remove(el) {
    jQuery(el).parent().parent().remove();
    results_num = results_num - 1;
}

function mdr_form_results_add() {
    results_num = results_num + 1;

    let row = jQuery("#form_results_in").clone().show().attr("id","");
    row.find(".number").text(results_num);
    row.find(".results_poster").attr("name", "poster_" + results_num);
    row.find(".results_video").attr("name", "video_" + results_num).show();
    jQuery("#form_results").append(row);

}

async function mdr_form_results_submit(product_id) {
    loadingHandler();

    let inputs = jQuery("#form_results").find(".results_inputs");
    let send = false;
    let form = new FormData;
    form.append("product_id", product_id);

    jQuery(inputs).each(function(key, value) {
        let name = jQuery(value).attr("name");

        if (name === "poster" || name === "video" || name === "full_name" || name === "title" ) {
            return true;
        }

        send = true;
        form.append(name,jQuery(value).val());

    })

    if(!send) {
        jQuery("#results_response").empty().append("<p>موردی برای ارسال یافت نشد.</p>");
        loadingHandler();
        return;
    }

    await mdr_api('admin/v1/results_product_update', form).then(async function (response) {

        if (response.success === true ) {
            jQuery("#results_response").empty().append("<p class='text-success'>" + response.message + "</p>");
        } else {
            jQuery("#results_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");
        }

    }).catch(function (xhr, err) {

        let response = JSON.parse(xhr.responseText);
        jQuery("#results_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");

        console.log('error in curl')
    });

    loadingHandler();

}

function mdr_form_benefits_remove(el) {
    jQuery(el).parent().parent().remove();
    benefits_num = benefits_num - 1;
}

function mdr_form_benefits_add() {
    benefits_num = benefits_num + 1;

    let row = jQuery("#form_benefits_in").clone().show().attr("id","");
    row.find(".number").text(benefits_num);
    row.find(".benefits_icon").attr("name", "icon_" + benefits_num);
    row.find(".benefits_title").attr("name", "title_" + benefits_num).show();
    jQuery("#form_benefits").append(row);

}

async function mdr_form_benefits_submit(product_id) {
    loadingHandler();

    let inputs = jQuery("#form_benefits").find(".benefits_inputs");
    let send = false;
    let form = new FormData;
    form.append("product_id", product_id);

    jQuery(inputs).each(function(key, value) {
        let name = jQuery(value).attr("name");

        if (name === "icon" || name === "title" ) {
            return true;
        }

        send = true;
        form.append(name,jQuery(value).val());

    })

    if(!send) {
        jQuery("#benefits_response").empty().append("<p>موردی برای ارسال یافت نشد.</p>");
        loadingHandler();
        return;
    }

    await mdr_api('admin/v1/benefits_product_update', form).then(async function (response) {

        if (response.success === true ) {
            jQuery("#benefits_response").empty().append("<p class='text-success'>" + response.message + "</p>");
        } else {
            jQuery("#benefits_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");
        }

    }).catch(function (xhr, err) {

        let response = JSON.parse(xhr.responseText);
        jQuery("#benefits_response").empty().append("<p class='text-danger'>" + response.message ?? "خطایی رخ داده" + "</p>");

        console.log('error in curl')
    });

    loadingHandler();

}

