// Open and close menu ---------------------------------------------------------
$(".btn-open-navigation").click(function () {
    $(".navigation").addClass("active")
})

$(".btn-close-navigation").click(function () {
    $(".navigation").removeClass('active')
})

function checkIsMobile() {
    return window.innerWidth <= 992;
}

// Filters dropdown -------------------------------------------------------------
$(".dropdown-filters .filter").click(function () {

    const parentEl = $(".dropdown-filters .filter").closest(".dropdown-filters");

    $(".dropdown-filters .filter").removeClass("selected");
    $(this).addClass("selected");

    const newValue = $(this).attr("value");
    const newText = $(this).text();

    parentEl.find(".current-value").text(newText)

    if (checkIsMobile()) {
        parentEl.children(".filters-items").slideUp(300);
    }

    //sned ajax by new value

})

$(".dropdown-filters .clickable").click(function () {

    const parentEl = $(".dropdown-filters .filter").closest(".dropdown-filters");
    parentEl.children(".filters-items").slideToggle(300);

})

$(document).click(function (event) { //Click outside
    const targetEl = event.target;

    if (!$(targetEl).closest(".dropdown-filters")[0]) {
        if (checkIsMobile()) {
            $(".dropdown-filters").children(".filters-items").slideUp(300);
        }
    }

})

// Audio Player -------------------------------------------------------------------
const audioPlayerEl = document.getElementById("audio-player");

if (audioPlayerEl) {
    const audioEl = audioPlayerEl.querySelector("audio");
    const buttonPlayPause = audioPlayerEl.querySelector(".btn-play-pause");
    const buttonBack = audioPlayerEl.querySelector(".btn-back");
    const buttonForward = audioPlayerEl.querySelector(".btn-forward");
    const buttonMute = audioPlayerEl.querySelector(".btn-mute");
    const buttonPlayBackRate = audioPlayerEl.querySelector(".btn-play-back-rate");
    const volumeControlEl = audioPlayerEl.querySelector(".volume-control input");
    const currentTimeEl = audioPlayerEl.querySelector(".current-time");
    const totalDurationEl = audioPlayerEl.querySelector(".total-duration");
    const trackSliderEl = audioPlayerEl.querySelector(".track-slider input")
    const progressActiveVolumeEl = audioPlayerEl.querySelector(".progress-active-volume");
    const progressActiveTrackEl = audioPlayerEl.querySelector(".progress-active-track");
    const audioAnimationEl = document.querySelector(".audio-bar-animation .bars")

    window.addEventListener("load", function () {
        volumeControlEl.value = 1;
        trackSliderEl.value = 0
        progressActiveVolumeEl.style.width = '100%';
        progressActiveTrackEl.style.width = '0';
    })

    let playing = false;

    function formatTime(seconds) {
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = Math.floor(seconds % 60);
        return `${minutes}:${remainingSeconds < 10 ? "0" : ""}${remainingSeconds}`;
    }

    //play and pause
    buttonPlayPause.addEventListener("click", function () {

        if (!playing) {
            audioEl.play();
        } else {
            audioEl.pause();
        }

    })

    audioEl.addEventListener("play", function () {
        playing = true;
        audioPlayerEl.classList.add("playing");
        audioAnimationEl.classList.remove("stop")
    })

    audioEl.addEventListener("pause", function () {
        playing = false;
        audioPlayerEl.classList.remove("playing");
        audioAnimationEl.classList.add("stop")
    })

//volume controll
    volumeControlEl.addEventListener("input", function () {
        audioEl.volume = volumeControlEl.value;
        progressActiveVolumeEl.style.width = (volumeControlEl.value * 100) + '%';

        if (!Number(volumeControlEl.value)) {
            buttonMute.classList.add("mute");
        } else {
            buttonMute.classList.remove("mute");
        }

    });

    buttonMute.addEventListener("click", function () {
        if (Number(volumeControlEl.value)) {
            volumeControlEl.value = 0;
            audioEl.volume = 0;
            progressActiveVolumeEl.style.width = 0 + '%';
            buttonMute.classList.add("mute");
        } else {
            volumeControlEl.value = 1;
            audioEl.volume = 1;
            progressActiveVolumeEl.style.width = 100 + '%';
            buttonMute.classList.remove("mute");
        }
    })

    audioEl.addEventListener("timeupdate", function () {
        const currentTime = formatTime(audioEl.currentTime);
        const totalDuration = formatTime(audioEl.duration);
        currentTimeEl.textContent = currentTime;
        totalDurationEl.textContent = totalDuration;

        const position = (audioEl.currentTime / audioEl.duration) * 100;
        trackSliderEl.value = position;

        progressActiveTrackEl.style.width = (trackSliderEl.value) + '%';
    });

    trackSliderEl.addEventListener("input", function () {
        const newPosition = (trackSliderEl.value / 100) * audioEl.duration;
        audioEl.currentTime = newPosition;
    });

    // speed
    buttonPlayBackRate.addEventListener("click", function (event) {
        if (audioEl.playbackRate >= 2) {
            audioEl.playbackRate = 1;
            buttonPlayBackRate.classList.remove("active");
        } else {
            audioEl.playbackRate = 2;
            buttonPlayBackRate.classList.add("active")
        }
    })

    // back
    buttonBack.addEventListener("click", function () {
        audioEl.currentTime -= 15;
    })

    // forward
    buttonForward.addEventListener("click", function () {
        audioEl.currentTime += 15;
    })

}

// Sliders ----------------------------------------------------------------------
const swiperWorks = document.querySelectorAll('.works-slider .swiper');
swiperWorks.forEach(swiperEl => {
    new Swiper(swiperEl, {

        spaceBetween: 0,
        autoplay: true,
        delay: 10000,
        speed: 2000,

        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 'auto',
                loop: true
            },
            768: {
                slidesPerView: 'auto'
            },
            1200: {
                slidesPerView: 5,
            }
        },

        navigation: {
            nextEl: '.works-slider .btn-next-slide',
        }

    });
})

const swiperArticles = document.querySelectorAll('.new-articles .swiper');
swiperArticles.forEach(swiperEl => {
    new Swiper(swiperEl, {

        spaceBetween: 0,

        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 'auto'
            },
            // when window width is >= 640px
            992: {
                slidesPerView: 3,
            }
        }
    });
})

const swiperComments = document.querySelectorAll('.comments-slider .swiper');
swiperComments.forEach(swiperEl => {
    new Swiper(swiperEl, {

        spaceBetween: 0,

        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 'auto'
            },
            // when window width is >= 640px
            992: {
                slidesPerView: 3,
            }
        },

        pagination: {
            el: ".comments-slider .swiper-pagination",
            clickable: true
        },
    });
})

const swiperCommentVideos = document.querySelectorAll('.videos-slider .swiper');
swiperCommentVideos.forEach(swiperEl => {
    const swiperTemp = new Swiper(swiperEl, {

        spaceBetween: 5,
        initialSlide: 1,
        centeredSlides: true,
        centerInsufficientSlides: true,

        navigation: {
            nextEl: swiperEl.parentNode.querySelector('.slide-next'),
            prevEl: swiperEl.parentNode.querySelector('.slide-prev'),
        },

        breakpoints: {
            // when window width is >= 320px
            320: {
                slidesPerView: 'auto',
                spaceBetween: 20,
            },
            // when window width is >= 640px
            992: {
                slidesPerView: 3,

            }
        },

        pagination: {
            el: ".comments-slider .swiper-pagination",
            clickable: true
        },
    });

    swiperEl.querySelectorAll('.swiper-slide').forEach((slide, index) => {
        slide.addEventListener('click', () => {
            swiperTemp.slideTo(index); // Change to clicked slide
        });
    });

})

// Frequently-asked-questions -------------------------------------------------------
$(".frequently-asked-questions .question").click(function () {
    const parentEl = $(this).closest(".question");
    const currentOpenEl = $(".frequently-asked-questions .question.open");

    if (parentEl.hasClass("open")) {

        $(parentEl).children(".body-question").slideUp(300);
        $(parentEl).removeClass("open");

    } else {

        $(parentEl).children(".body-question").slideDown(300);
        $(parentEl).addClass("open");

        $(currentOpenEl).children(".body-question").slideUp(300);
        $(currentOpenEl).removeClass("open");

    }

})

// Course headlines -------------------------------------------------------
$(".course-headlines .headline-number, .course-headlines .headline-header").click(function () {
    const parentEl = $(this).closest(".headline");
    const currentOpenEl = $(".course-headlines .headline.open");

    //check is deactivate
    if (parentEl.hasClass("deactivate")) {
        return;
    }

    if (parentEl.hasClass("open")) {

        $(parentEl).find(".headline-body").slideUp(300, function () {
            $(parentEl).removeClass("open");
        });


    } else {

        $(parentEl).find(".headline-body").slideDown(300, function () {
            $(parentEl).addClass("open");
        });

        $(currentOpenEl).find(".headline-body").slideUp(300, function () {
            $(currentOpenEl).removeClass("open");
        });

    }

})

//Count down seminars page -------------------------------------------------------
const timerEl = document.getElementById("timer-holder");
const timeValue = timerEl?.getAttribute('data-date');

function countdownTimer(time, el) {
    let now = new Date().getTime();

    let distance = time - now;

    if (distance < 0 && loopTimer) {
        clearInterval(loopTimer);
        return;
    }

    let days = String(Math.floor(distance / (1000 * 60 * 60 * 24))).padStart(2, '0');
    let hours = String(Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60))).padStart(2, '0');
    let minutes = String(Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60))).padStart(2, '0');
    let seconds = String(Math.floor((distance % (1000 * 60)) / 1000)).padStart(2, '0');

    el.querySelector(".days .digit-1").innerHTML = days.charAt(0);
    el.querySelector(".days .digit-2").innerHTML = days.charAt(1);

    el.querySelector(".hours .digit-1").innerHTML = hours.charAt(0);
    el.querySelector(".hours .digit-2").innerHTML = hours.charAt(1);

    el.querySelector(".minutes .digit-1").innerHTML = minutes.charAt(0);
    el.querySelector(".minutes .digit-2").innerHTML = minutes.charAt(1);

}

if (timeValue) {

    const countDownDate = new Date(timeValue).getTime();

    let loopTimer = null;
    countdownTimer(countDownDate, timerEl);
    loopTimer = setInterval(countdownTimer(countDownDate, timerEl), 1000)

}

// Videos -------------------------------------------------------------------
function formatTimeVideo(seconds) {
    const minutes = Math.floor(seconds / 60);
    const secondsLeft = Math.floor(seconds % 60);
    return `${String(minutes).padStart(2, '0')}:${String(secondsLeft).padStart(2, '0')}`;
}

$(".holder-video .holder-play-video").click(function () {
    const parentEl = $(this).closest(".holder-video");
    const videoEl = $(parentEl).children("video")[0];

    videoEl.play();
})

$('.holder-video video').on('play', function (event) {

    const parentEl = $(this).closest(".holder-video");
    const videoEl = $(parentEl).children("video")[0];

    const currentVideoPlayingEl = $('.holder-video.playing video')[0];
    if (currentVideoPlayingEl && !event.target.isEqualNode(currentVideoPlayingEl)) {
        currentVideoPlayingEl.pause();
    }

    $(videoEl).attr("controls", true);
    parentEl.addClass("playing");

});

$('.holder-video video').on('ended', function () {

    const parentEl = $(this).closest(".holder-video");
    const videoEl = $(parentEl).children("video")[0];
    parentEl.removeClass("playing");

    //check has class
    if (parentEl.hasClass("pause-hide-controls")) {
        $(videoEl).attr("controls", false);
    }

});

$('.holder-video video').on('pause', function () {

    const parentEl = $(this).closest(".holder-video");
    const videoEl = $(parentEl).children("video")[0];
    parentEl.removeClass("playing");

    //check has class
    if (parentEl.hasClass("pause-hide-controls")) {
        $(videoEl).attr("controls", false);
    }

});

//change video src by click home page
$(".new-videos .small-video").click(function () {
    const videoEl = $(this).children("video");
    const srcVideo = $(videoEl).children('source').attr("src");
    const poster = $(videoEl).attr("poster");

    const largeVideoEl = $('.new-videos .large-video video')[0];
    $(largeVideoEl).attr("poster", poster)
    $(largeVideoEl).children("source").attr("src", srcVideo);

    largeVideoEl.load();
    largeVideoEl.play();

    $(".new-videos .small-video.active").removeClass("active")
    $(this).addClass("active")

})

//change video src by click videos page
$(".video-preview .small-video").click(function () {
    const videoEl = $(this).children("video");
    const srcVideo = $(videoEl).children('source').attr("src");
    const poster = $(videoEl).attr("poster");

    const largeVideoEl = $('.video-preview .large-video video')[0];
    $(largeVideoEl).attr("poster", poster)
    $(largeVideoEl).children("source").attr("src", srcVideo);

    largeVideoEl.load();
    largeVideoEl.play();

    $(".video-preview .small-video.active").removeClass("active")
    $(this).addClass("active")

})

//header video single page
$(document).ready(function () {

    $('.course-header-video video').on('loadeddata', function () {
        $(this).closest(".course-header-video").find(".time-video").text(formatTimeVideo(this.duration))
    });

});

//other scripts
async function submitForm(typeCode) {
    loadingHandler();
    let base_url = '';
    let interval = null;
    $("#notification").empty().hide();
    const phone = $("#phone-number").val();

    if (phone === "") {
        alert("لطفا شماره همراه خود را وارد کنید");
        loadingHandler();
        return;
    }

    if (typeCode === "sms") {
        base_url = "login/v1/sms";
    }

    if (typeCode === "whatsapp") {
        base_url = "login/v1/whatsapp";
    }

    var form = new FormData();
    form.append("phone", phone);

    await mdr_api(base_url, form).then(function (response) {

        if (response.success === true) {
            $("#otp_send").hide();
            $("#resend_otp").hide();
            $("#otp_verify").show();
            $("#note_resend_otp").show();
            $("#otp_resend_time").show();
            $("#phone_number_display").val(phone).show();

            clearInterval(interval);

            t = 120;
            interval = setInterval(function () {
                t = t - 1;
                $("#otp_resend_time").empty().append(t);

                if (t < 1) {
                    $("#otp_resend_time").empty().hide();
                    $("#note_resend_otp").hide();
                    $("#resend_otp").show();
                    clearInterval(interval);
                    // return;
                }

            }, 1000);
        } else {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

        console.log('error in curl')
    });

    loadingHandler();

    // var settings = {
    //     "url": base_url,
    //     "method": "POST",
    //     "timeout": 0,
    //     "processData": false,
    //     "mimeType": "multipart/form-data",
    //     "headers": {
    //         "Accept": "application/json"
    //     },
    //     "contentType": false,
    //     "data": form
    // };
    //
    // $.ajax(settings).done(function (response) {
    //     response = JSON.parse(response);
    //
    //     if (response.success === true) {
    //         $("#otp_send").hide();
    //         $("#resend_otp").hide();
    //         $("#otp_verify").show();
    //         $("#note_resend_otp").show();
    //         $("#otp_resend_time").show();
    //         $("#phone_number_display").val(phone).show();
    //         loadingHandler();
    //
    //         clearInterval(interval);
    //
    //         t = 120;
    //         interval = setInterval(function () {
    //             t = t - 1;
    //             $("#otp_resend_time").empty().append(t);
    //
    //             if (t < 1) {
    //                 $("#otp_resend_time").empty().hide();
    //                 $("#note_resend_otp").hide();
    //                 $("#resend_otp").show();
    //                 clearInterval(interval);
    //                 // return;
    //             }
    //
    //         }, 1000);
    //     } else {
    //         loadingHandler();
    //         $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
    //     }
    //
    // }).fail(function (xhr, err) {
    //     let response = JSON.parse(xhr.responseText);
    //     loadingHandler();
    //     $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
    // });

}

async function submitVerifyForm() {

    loadingHandler();
    $("#notification").empty().hide();
    const phone = $("#phone-number").val();
    const otp = $("#otp-code-input").val();
    const callback = window.location.href;

    if (phone === "") {
        $("#notification").show().empty().append('لطفا شماره همراه خود را وارد کنید.')
        loadingHandler();
        return;
    }

    if (otp === "") {
        $("#notification").show().empty().append('لطفا کد ارسال شده را وارد کنید.')
        loadingHandler();
        return;
    }

    var form = new FormData();
    form.append("phone", phone);
    form.append("code", otp);
    form.append("callback", callback);

    await mdr_api('login/v1/confirm', form).then(function (response) {

        if (response.success === true && (response.data.back)) {
            window.location.href = response.data.back;
        }

        if (response.success === true && (response.data.new_user)) {
            $("#otp_verify").hide();
            $("#register").show();
        } else {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

        console.log('error in curl')
    });

    loadingHandler();

}

async function registerForm() {
    loadingHandler();
    $("#notification").empty().hide();
    const phone = $("#phone-number").val();
    const full_name = $("#full_name").val();
    const callback = window.location.href;

    if (phone === "") {
        $("#notification").show().empty().append('لطفا شماره همراه خود را وارد کنید.')
        return;
    }

    if (full_name === "") {
        $("#notification").show().empty().append('لطفا نام خود را وارد کنید.')
        return;
    }

    var form = new FormData();
    form.append("phone", phone);
    form.append("full_name", full_name);
    form.append("callback", callback);

    await mdr_api('login/v1/register', form).then(function (response) {

        if (response.success === true && response.data.back) {
            window.location.href = response.data.back;
        } else {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

        console.log('error in curl')
    });

    loadingHandler();

}

function back_to_otp_send() {

    if (t > 1) {
        $("#notification").show().empty().append('لطفا تا اتمام زمان ارسال مجدد صبر کنید.')
        return;
    }

    $("#notification").empty().hide();
    $("#otp_send").show();
    $("#resend_otp").hide();
    $("#otp_verify").hide();
}

function loadingHandler() {

    let loading = $('#mdr_loading');

    if (loading.is(":visible")) {
        loading.remove();
    } else {
        $('body').append('<div id="mdr_loading">\n' +
            '   <span class="loader"></span>\n' +
            '</div>')
    }

}

function modal_close() {
    $("#modal").modal('toggle');
}

async function reply_comment(el, comment_id) {
    let comment_parent = $(el).parent().parent().parent();

    if (comment_parent.find("#reply_comment_form").is(":visible")) {
        $("#reply_comment_form").toggle('slow', 'swing').remove();
        return;
    }

    $("#reply_comment_form").toggle('slow', 'swing').remove();
    let comment_form = $("#comment_form").clone().prop('id', 'reply_comment_form').hide();
    comment_form.addClass('bg-body-secondary p-lg-5 p-md-5');
    comment_form.find(".comment_parent").val(comment_id);
    comment_form.find(".comment_title").text('پاسخ به دیدگاه');
    comment_parent.append(comment_form.toggle('slow', 'swing'));

}

async function mdr_api(address, form = null) {

    if (!form) {
        form = new FormData;
    }

    form.append('key', MDRVars.api_key);
    form.append('_wpnonce', MDRVars.wpnonce);

    let settings = {
        "url": MDRVars.rest_url + address,
        "method": "POST",
        "timeout": 0,
        "processData": false,
        "Accept": "application/json",
        "contentType": false,
        "data": form
    };

    return await $.ajax(settings);
}

async function send_comment(form_element) {
    let element = $(form_element).parent().parent().parent();

    loadingHandler();

    let form = new FormData;

    $.each(element.serializeArray(), function (index, value) {
        form.append(value.name, value.value);
    });


    await mdr_api('comments/v1/add-comment', form).then(function (res) {

        if (res.success === true) {
            $.each(element.find(".empty_loud"), function (index, value) {
                $(value).val('')
            })
            element.find(".response").empty().append('<p class="response_success">' + res.message + '</p>');
        } else if (!res.success && res.data.login) {
            $("#modal").modal()
            $("#modal").find(".modal-body").empty().append(res.data.login);
            $("#modal").find(".col-lg-5").addClass('w-100');

        } else {
            element.find(".response").empty().append('<p class="response_error">' + res.message + '</p>');
        }

    }).catch(function (Object) {

        if (Object && Object.status && bject.responseJSON.message) {
            element.find(".response").empty().append('<p class="response_error">' + Object.responseJSON.message + '</p>');
        }

        console.log('error in curl')
    });

    loadingHandler();

}

async function login() {

    loadingHandler();

    await mdr_api('login/v1/login').then(function (response) {

        if (response.success) {
            $("#modal").modal()
            $("#modal").find(".modal-body").empty().append(response.data.login);
            $("#modal").find(".col-lg-5").addClass('w-100');
        }

    }).catch(function (Object) {

        if (Object && Object.status && Object.responseJSON.message) {
            console.log(Object.responseJSON.message);
        }

        console.log('error in curl');
    });

    loadingHandler();

}

async function logout() {

    loadingHandler();

    await mdr_api('login/v1/logout').then(function (response) {

        if (response.success === true && response.data.back) {
            window.location.href = response.data.back;
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            console.log(xhr);
        }

        console.log('error in curl');
    });

    loadingHandler();

}

async function consultation_submit(form_element) {

    let element = $(form_element).parent();

    loadingHandler();

    let form = new FormData;

    $.each(element.serializeArray(), function (index, value) {
        form.append(value.name, value.value);
    });

    await mdr_api('consultation/v1/add', form).then(function (response) {

        if (response.success) {
            element.find(".response").empty().append('<p class="response_success">' + response.message + '</p>');
        } else {
            element.find(".response").empty().append('<p class="response_error">' + response.message ?? "در دریافت اطلاعات خطایی رخ داده" + '</p>');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            element.find(".response").empty().append('<p class="response_error">' + bject.responseJSON.message + '</p>');
        }

        console.log('error in curl')
    });

    loadingHandler();
}

async function mdr_product_pay(el) {
    loadingHandler();
    $("#notification").empty().hide();
    let element = $(el).parent();

    var form = new FormData();
    form.append("landing_url", window.location.origin + window.location.pathname);

    $.each(element.serializeArray(), function (index, value) {
        form.append(value.name, value.value);
    });

    await mdr_api('pay/v1/product_request', form).then(function (response) {

        element.find(".response").empty();

        if (response.success === true && response.data.url) {
            element.find(".response").empty().append('<p class="response_success">' + response.message + '</p>');
            window.location.href = response.data.url;
        } else {

            if (response.data && response.data.errors && response.data.errors.inputs) {
                $(response.data.errors.inputs).each(function (key, value) {
                    element.find(".response").append('<p class="response_error">' + value.message + '</p>');
                })

            }

            if (response.data && response.data.errors && response.data.errors.data) {
                $(response.data.errors.data).each(function (key, value) {
                    element.find(".response").append('<p class="response_error">' + value.message + '</p>');
                })
                return;
            }

            element.find(".response").append('<p class="response_error">' + response.message ?? "در دریافت اطلاعات خطایی رخ داده" + '</p>');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            element.find(".response").empty().append('<p class="response_error">' + bject.responseJSON.message + '</p>');
        }

        console.log('error in curl')
    });

    loadingHandler();


}

async function mdr_get_list_items(post_type, taxonomy, term_slug, page = 1) {

    if (!post_type || !taxonomy || !term_slug) {
        return;
    }

    loadingHandler();

    var form = new FormData();
    form.append("post_type", post_type);
    form.append("taxonomy", taxonomy);
    form.append("term_slug", term_slug);
    form.append("page", page);

    await mdr_api('archive/v1/get-archive-posts', form).then(async function (response) {
        let items = $("#mdr_list_items");
        items.empty().hide();

        if (response.success === true && response.data.posts) {

            $.each(response.data.posts, async function (index, post) {
                let item = $("#mdr_list_item").clone().prop('id', '');
                item.find(".mdr_list_item_link").prop('href', post.link);
                item.find(".mdr_list_item_image").prop('src', post.thumbnail ?? '');
                item.find(".mdr_list_item_title").text(post.post_title);
                item.find(".mdr_list_item_description").text(post.post_excerpt);
                item.find(".mdr_list_item_content").html(post.post_content);
                item.show();
                await items.append(item);
            });

            let pagination = $("#pagination");
            pagination.empty();

            if (response.data.max_num_pages > 1) {

                let pagination_nav = $("#mdr_pagination_clone").clone().prop('id', '');
                let pagination_ul = pagination_nav.find('.mdr_pagination_ul');
                let pagination_prev = pagination_nav.find('.mdr_pagination_prev');
                let pagination_next = pagination_nav.find('.mdr_pagination_next');
                let pagination_li = pagination_nav.find('.mdr_pagination_li');

                pagination_nav.empty().append(pagination_ul.empty());
                pagination_nav.find('.mdr_pagination_ul').append(pagination_prev);

                if (parseInt(page) === 1) {
                    pagination_nav.find('.mdr_pagination_ul').find('.mdr_pagination_prev').addClass('disabled');
                }else {
                    pagination_nav.find('.mdr_pagination_ul').find('.mdr_pagination_prev').find('.mdr_pagination_link')
                        .attr('onclick', 'mdr_get_list_items(\'' + post_type + '\', \'' + taxonomy + '\', \'' + term_slug + '\', ' + (parseInt(page) - 1) + ' )');
                }

                for (let i = 1; i <= parseInt(response.data.max_num_pages); i++) {
                    let li = pagination_li.clone();

                    if (parseInt(page) === i) {
                        li.addClass('active');
                    }

                    li.find('.mdr_pagination_link').text(i);
                    li.find('.mdr_pagination_link')
                        .attr('onclick', 'mdr_get_list_items(\'' + post_type + '\', \'' + taxonomy + '\', \'' + term_slug + '\', ' + i + ' )');

                    pagination_nav.find('.mdr_pagination_ul').append(li);
                }

                pagination_nav.find('.mdr_pagination_ul').append(pagination_next);

                if (parseInt(page) === parseInt(response.data.max_num_pages)) {
                    pagination_nav.find('.mdr_pagination_ul').find('.mdr_pagination_next').addClass('disabled');
                }else {
                    pagination_nav.find('.mdr_pagination_ul').find('.mdr_pagination_next').find('.mdr_pagination_link')
                        .attr('onclick', 'mdr_get_list_items(\'' + post_type + '\', \'' + taxonomy + '\', \'' + term_slug + '\', ' + (parseInt(page) + 1) + ' )');
                }

                pagination.append(pagination_nav.show());

            }

            items.toggle('slow', 'swing');
        } else {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

    }).catch(function (xhr, err) {

        if (Object && Object.status && bject.responseJSON.message) {
            $("#notification").show().empty().append(response.message ?? 'خطایی رخ داده.');
        }

        console.log('error in curl')
    });

    loadingHandler();

}

//story scripts
let currentStoryIndex = 0;
let story_timer;
let progressInterval;

$(document).ready(function() {

    if ($("#storyContainer").length) {
        stories.forEach((story, index) => {
            $('#storyContainer').append(`<div class="story"><img src="${story.icon}" onclick="openStory(${index})"></div>`);
        });
    }

});

function openStory(index) {
    currentStoryIndex = index;
    showStory();
    $('#storyViewer').fadeIn();
}

function closeStory() {
    $('#storyViewer').fadeOut();
    clearTimeout(story_timer);
    clearInterval(progressInterval);
}

function showStory() {
    const story = stories[currentStoryIndex];
    $('#storyContent').html(`<${story.type} id="story-${currentStoryIndex}" src="${story.src}" autoplay controls="false"></${story.type}>`);

    clearTimeout(story_timer);
    clearInterval(progressInterval);
    $('#progress').css('width', '0%');

    let duration = story.duration;
    let startTime = Date.now();
    progressInterval = setInterval(() => {
        let elapsedTime = Date.now() - startTime;
        let progress = (elapsedTime / duration) * 100;
        $('#progress').css('width', progress + '%');
        if (progress >= 100) clearInterval(progressInterval);
    }, 30);

    story_timer = setTimeout(nextStory, duration);
}

function nextStory() {
    if (currentStoryIndex < stories.length - 1) {
        currentStoryIndex++;
        showStory();
    } else {
        closeStory();
    }
}

function prevStory() {
    if (currentStoryIndex > 0) {
        currentStoryIndex--;
        showStory();
    }
}
